/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.fragment;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.portal.api.Portal;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.api.StoredState;
import org.sakaiproject.portal.render.api.RenderResult;
import org.sakaiproject.portal.render.api.ToolRenderException;
import org.sakaiproject.portal.render.api.ToolRenderService;
import org.sakaiproject.portal.util.ToolURLManagerImpl;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.ActiveToolManager;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.Web;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentToolRenderService
implements ToolRenderService {
    private static final String TOOL_FRAGMENT_PRODUCER_ID = "fragment-producer";
    private static final Logger log = LoggerFactory.getLogger(FragmentToolRenderService.class);
    private PortalService portal;

    public boolean accept(Portal portal, ToolConfiguration configuration, HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        return this.isFragmentTool(configuration);
    }

    private boolean isFragmentTool(ToolConfiguration configuration) {
        Properties placementProperties = configuration.getConfig();
        String fragmentCapable = placementProperties.getProperty(TOOL_FRAGMENT_PRODUCER_ID);
        return fragmentCapable != null && fragmentCapable.length() != 0;
    }

    public boolean preprocess(Portal portal, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException {
        return true;
    }

    public RenderResult render(Portal portal, final ToolConfiguration toolConfiguration, final HttpServletRequest request, final HttpServletResponse response, ServletContext context) throws IOException, ToolRenderException {
        if (this.isFragmentTool(toolConfiguration)) {
            return new RenderResult(){

                public String getContent() throws ToolRenderException {
                    Session session = SessionManager.getCurrentSession();
                    String option = request.getPathInfo();
                    if (option == null || "/".equals(option)) {
                        option = session.getUserId() == null ? "/site/" + ServerConfigurationService.getGatewaySiteId() : "/site/" + SiteService.getUserSiteId((String)session.getUserId());
                    }
                    String[] parts = option.split("/");
                    try {
                        FragmentToolRenderService.this.doTool(toolConfiguration, request, response, session, toolConfiguration.getId(), request.getContextPath() + request.getServletPath() + Web.makePath((String[])parts, (int)1, (int)3), Web.makePath((String[])parts, (int)3, (int)parts.length));
                    }
                    catch (Exception e) {
                        throw new ToolRenderException("Failed to perform render ", (Throwable)e);
                    }
                    return "";
                }

                public void setContent(String content) {
                }

                public String getTitle() throws ToolRenderException {
                    return Web.escapeHtml((String)toolConfiguration.getTitle());
                }

                public String getJSR168EditUrl() {
                    return null;
                }

                public String getJSR168HelpUrl() {
                    return null;
                }

                public String getHead() {
                    return "";
                }
            };
        }
        return null;
    }

    protected void doTool(ToolConfiguration toolConfiguration, HttpServletRequest req, HttpServletResponse res, Session session, String placementId, String toolContextPath, String toolPathInfo) throws ToolException, IOException {
        ActiveTool tool;
        if (this.portal.isResetRequested(req)) {
            Session s = SessionManager.getCurrentSession();
            ToolSession ts = s.getToolSession(placementId);
            ts.clearAttributes();
            this.portal.setResetState(null);
            log.debug("Tool state reset");
        }
        if ((tool = ActiveToolManager.getActiveTool((String)toolConfiguration.getToolId())) == null) {
            throw new ToolRenderException("Failed to render fragment, no Active Tool found for " + toolConfiguration.getToolId());
        }
        if (tool.getAccessSecurity() == Tool.AccessSecurity.PORTAL) {
            Site site = null;
            try {
                site = SiteService.getSiteVisit((String)toolConfiguration.getSiteId());
            }
            catch (IdUnusedException e) {
                throw new ToolRenderException("No site permissions found for site " + toolConfiguration.getSiteId());
            }
            catch (PermissionException e) {
                throw new ToolRenderException("Permission Deined for placement " + toolConfiguration.getId() + " in " + toolConfiguration.getSiteId());
            }
        }
        this.forwardTool(tool, req, res, (Placement)toolConfiguration, toolConfiguration.getSkin(), toolContextPath, toolPathInfo);
    }

    protected void forwardTool(ActiveTool tool, HttpServletRequest req, HttpServletResponse res, Placement p, String skin, String toolContextPath, String toolPathInfo) throws ToolException {
        if (this.portal.isEnableDirect()) {
            StoredState ss = this.portal.getStoredState();
            if (ss == null || !toolContextPath.equals(ss.getToolContextPath())) {
                req.setAttribute("tool.url.manager", (Object)new ToolURLManagerImpl(res));
                tool.include(req, res, p, toolContextPath, toolPathInfo);
            } else {
                log.debug("Restoring Fragment  StoredState [" + ss + "]");
                HttpServletRequest sreq = ss.getRequest(req);
                Placement splacement = ss.getPlacement();
                String stoolContext = ss.getToolContextPath();
                String stoolPathInfo = ss.getToolPathInfo();
                ActiveTool stool = ActiveToolManager.getActiveTool((String)p.getToolId());
                String sskin = ss.getSkin();
                req.setAttribute("tool.url.manager", (Object)new ToolURLManagerImpl(res));
                stool.include(sreq, res, splacement, stoolContext, stoolPathInfo);
                this.portal.setStoredState(null);
            }
        } else {
            req.setAttribute("tool.url.manager", (Object)new ToolURLManagerImpl(res));
            tool.include(req, res, p, toolContextPath, toolPathInfo);
        }
    }

    public void setPortalService(PortalService portal) {
        this.portal = portal;
    }

    public void reset(ToolConfiguration configuration) {
    }
}

