/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.iframe;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.api.Portal;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.api.StoredState;
import org.sakaiproject.portal.render.api.RenderResult;
import org.sakaiproject.portal.render.api.ToolRenderException;
import org.sakaiproject.portal.render.api.ToolRenderService;
import org.sakaiproject.portal.util.URLUtils;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.util.Web;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IFrameToolRenderService
implements ToolRenderService {
    private static final Logger LOG = LoggerFactory.getLogger(IFrameToolRenderService.class);
    private PortalService portalService;

    public boolean preprocess(Portal portal, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException, ToolRenderException {
        return true;
    }

    public RenderResult render(Portal portal, ToolConfiguration configuration, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException, ToolRenderException {
        String sakaiPanel;
        final String titleString = Web.escapeHtml((String)configuration.getTitle());
        String toolUrl = ServerConfigurationService.getToolUrl() + "/" + Web.escapeUrl((String)configuration.getId());
        StoredState ss = this.portalService.getStoredState();
        LOG.debug("Restoring Iframe [" + ss + "]");
        Map parametermap = ss == null ? request.getParameterMap() : ss.getRequest(request).getParameterMap();
        String URLstub = this.portalService.decodeToolState(parametermap, configuration.getId());
        if (URLstub != null) {
            toolUrl = toolUrl + URLstub;
        }
        if ((sakaiPanel = request.getParameter("panel")) != null && sakaiPanel.matches(".*[\"'<>].*")) {
            sakaiPanel = null;
        }
        if (sakaiPanel == null) {
            sakaiPanel = "Main";
        }
        toolUrl = URLUtils.addParameter((String)toolUrl, (String)"panel", (String)sakaiPanel);
        final StringBuilder sb = new StringBuilder();
        toolUrl = toolUrl.replace("&", "&amp;");
        String sakaiAction = request.getParameter("sakai_action");
        if (sakaiAction != null && sakaiAction.matches(".*[\"'<>].*")) {
            sakaiAction = null;
        }
        sb.append("<iframe").append("\tname=\"").append(Web.escapeJavascript((String)("Main" + configuration.getId()))).append("\"\n").append("\tid=\"").append(Web.escapeJavascript((String)("Main" + configuration.getId()))).append("\"\n\ttitle=\"").append(titleString).append(" ").append("\"").append("\n").append("\tclass =\"portletMainIframe\"").append("\n").append("\theight=\"475\"").append("\n").append("\twidth=\"100%\"").append("\n").append("\tframeborder=\"0\"").append("\n").append("\tmarginwidth=\"0\"").append("\n").append("\tmarginheight=\"0\"").append("\n").append("\tscrolling=\"auto\"").append(" allowfullscreen=\"allowfullscreen\"").append("\n").append("\tsrc=\"").append(toolUrl);
        if (sakaiAction != null) {
            sb.append(toolUrl.indexOf(63) >= 0 ? (char)'&' : '?');
            sb.append("sakai_action=").append(Web.escapeHtml((String)sakaiAction));
        }
        sb.append("\">").append("\n").append("</iframe>");
        RenderResult result = new RenderResult(){

            public String getHead() {
                return "";
            }

            public String getTitle() {
                return titleString;
            }

            public String getContent() {
                return sb.toString();
            }

            public void setContent(String content) {
            }

            public String getJSR168EditUrl() {
                return null;
            }

            public String getJSR168HelpUrl() {
                return null;
            }
        };
        return result;
    }

    public boolean accept(Portal portal, ToolConfiguration configuration, HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        return true;
    }

    public void reset(ToolConfiguration configuration) {
    }

    public PortalService getPortalService() {
        return this.portalService;
    }

    public void setPortalService(PortalService portalService) {
        this.portalService = portalService;
    }
}

