/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletContainerFactory;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.RequiredContainerServices;
import org.apache.pluto.core.PortletContextManager;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.SupportsDD;
import org.apache.pluto.spi.PortalCallbackService;
import org.apache.pluto.spi.PortletURLProvider;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.api.Portal;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.render.api.RenderResult;
import org.sakaiproject.portal.render.api.ToolRenderException;
import org.sakaiproject.portal.render.api.ToolRenderService;
import org.sakaiproject.portal.render.portlet.PortletRegistry;
import org.sakaiproject.portal.render.portlet.SakaiPortletWindow;
import org.sakaiproject.portal.render.portlet.services.SakaiOptionalPortletContainerServices;
import org.sakaiproject.portal.render.portlet.services.SakaiPortalCallbackService;
import org.sakaiproject.portal.render.portlet.services.SakaiPortalContext;
import org.sakaiproject.portal.render.portlet.services.SakaiPortletContainerServices;
import org.sakaiproject.portal.render.portlet.services.state.PortletState;
import org.sakaiproject.portal.render.portlet.services.state.PortletStateAccess;
import org.sakaiproject.portal.render.portlet.services.state.PortletStateEncoder;
import org.sakaiproject.portal.render.portlet.servlet.SakaiServletActionRequest;
import org.sakaiproject.portal.render.portlet.servlet.SakaiServletRequest;
import org.sakaiproject.portal.util.BufferedServletResponse;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.Web;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.tidy.Tidy;

public class PortletToolRenderService
implements ToolRenderService {
    private static final Logger LOG = LoggerFactory.getLogger(PortletToolRenderService.class);
    private PortletContainer container;
    private PortletRegistry registry = new PortletRegistry();
    private PortletStateEncoder portletStateEncoder;
    private PortalService portalService;

    public PortletStateEncoder getPortletStateEncoder() {
        return this.portletStateEncoder;
    }

    public void setPortletStateEncoder(PortletStateEncoder portletStateEncoder) {
        this.portletStateEncoder = portletStateEncoder;
    }

    public boolean preprocess(Portal portal, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException {
        String stateParam = request.getParameter("org.sakaiproject.portal.pluto.PORTLET_STATE");
        if (stateParam == null) {
            return true;
        }
        PortletState state = this.portletStateEncoder.decode(stateParam);
        PortletStateAccess.setPortletState(request, state);
        if (LOG.isDebugEnabled()) {
            LOG.debug("New Portlet State retrieved for Tool '" + state.getId() + ".");
        }
        if (state.isAction()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing action for placement id " + state.getId());
            }
            PortletStateAccess.setPortletState(request, state);
            SakaiPortletWindow window = PortletToolRenderService.isIn168TestMode(request) ? this.createPortletWindow(state.getId()) : this.registry.getPortletWindow(state.getId());
            window.setState(state);
            try {
                PortletContainer portletContainer = this.getPortletContainer(context);
                portletContainer.doAction((PortletWindow)window, (HttpServletRequest)new SakaiServletActionRequest(request, state), response);
            }
            catch (PortletException e) {
                throw new ToolRenderException(e.getMessage(), (Throwable)e);
            }
            catch (PortletContainerException e) {
                throw new ToolRenderException(e.getMessage(), (Throwable)e);
            }
            finally {
                state.setAction(false);
            }
            return true;
        }
        return true;
    }

    public RenderResult render(Portal portal, ToolConfiguration toolConfiguration, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException {
        this.getPortletDD((Placement)toolConfiguration);
        SakaiPortletWindow window = PortletToolRenderService.isIn168TestMode(request) ? this.createPortletWindow(toolConfiguration.getId()) : this.registry.getOrCreatePortletWindow((Placement)toolConfiguration);
        PortletState state = PortletStateAccess.getPortletState(request, window.getId().getStringId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieved PortletState from request cache.  Applying to window.");
        }
        if (this.portalService.isResetRequested(request) && state != null) {
            String statePrefix = "javax.portlet.p." + state.getId();
            HttpSession session = request.getSession(true);
            Enumeration e = session.getAttributeNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key == null || !key.startsWith(statePrefix)) continue;
                session.removeAttribute(key);
            }
            state = null;
        }
        if (state == null) {
            state = new PortletState(window.getId().getStringId());
            PortletStateAccess.setPortletState(request, state);
        }
        window.setState(state);
        try {
            SakaiServletRequest req = new SakaiServletRequest(request, state);
            PortletContainer portletContainer = this.getPortletContainer(context);
            String editUrl = null;
            String helpUrl = null;
            RequiredContainerServices rs = portletContainer.getRequiredContainerServices();
            PortalCallbackService pcs = rs.getPortalCallbackService();
            PortletURLProvider pup = null;
            if (this.isPortletModeAllowed((Placement)toolConfiguration, "edit")) {
                pup = pcs.getPortletURLProvider(request, (PortletWindow)window);
                pup.setPortletMode(new PortletMode("edit"));
                editUrl = pup.toString();
            }
            if (this.isPortletModeAllowed((Placement)toolConfiguration, "help")) {
                pup = pcs.getPortletURLProvider(request, (PortletWindow)window);
                pup.setPortletMode(new PortletMode("help"));
                helpUrl = pup.toString();
            }
            return new Sakai168RenderResult((HttpServletRequest)req, response, portletContainer, window, helpUrl, editUrl);
        }
        catch (PortletContainerException e) {
            throw new ToolRenderException(e.getMessage(), (Throwable)e);
        }
    }

    private SakaiPortletWindow createPortletWindow(String windowId) {
        String contextPath = "/rsf";
        String portletName = "numberguess";
        return new SakaiPortletWindow(windowId, contextPath, portletName);
    }

    private PortletContainer getPortletContainer(ServletContext context) throws PortletContainerException {
        if (this.container == null) {
            this.container = this.createPortletContainer();
            this.container.init(context);
        }
        return this.container;
    }

    private PortletContainer createPortletContainer() throws PortletContainerException {
        SakaiPortletContainerServices services = new SakaiPortletContainerServices();
        SakaiOptionalPortletContainerServices optServices = new SakaiOptionalPortletContainerServices();
        services.setPortalCallbackService(new SakaiPortalCallbackService());
        services.setPortalContext(new SakaiPortalContext());
        return PortletContainerFactory.getInstance().createContainer("sakai", (RequiredContainerServices)services, (OptionalContainerServices)optServices);
    }

    private static boolean isIn168TestMode(HttpServletRequest request) {
        if (!"true".equals(ServerConfigurationService.getString((String)"portal.allow.test168", null))) {
            return false;
        }
        HttpSession session = request.getSession(true);
        if (session.getAttribute("test168") != null || request.getParameter("test168") != null) {
            request.getSession(true).setAttribute("test168", (Object)Boolean.TRUE.toString());
            return true;
        }
        return false;
    }

    private boolean isPortletApplication(ServletContext context, ToolConfiguration configuration) throws ToolRenderException, MalformedURLException {
        SakaiPortletWindow window = this.registry.getOrCreatePortletWindow((Placement)configuration);
        if (window == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking context for potential portlet ");
        }
        ServletContext crossContext = context.getContext(window.getContextPath());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got servlet context as  " + crossContext);
            LOG.debug("Getting Context for path " + window.getContextPath());
            LOG.debug("Base Path " + crossContext.getRealPath("/"));
            LOG.debug("Context Name " + crossContext.getServletContextName());
            LOG.debug("Server Info " + crossContext.getServerInfo());
            LOG.debug("      and it is a portlet ? :" + (crossContext.getResource("/WEB-INF/portlet.xml") != null));
        }
        return crossContext.getResource("/WEB-INF/portlet.xml") != null;
    }

    public boolean accept(Portal portal, ToolConfiguration configuration, HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        try {
            if (PortletToolRenderService.isIn168TestMode(request)) {
                LOG.warn("In portlet test mode");
                return true;
            }
            if (this.isPortletApplication(context, configuration)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Tool " + configuration.getToolId() + " is a portlet");
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tool " + configuration.getToolId() + " is not a portlet");
            }
            return false;
        }
        catch (MalformedURLException e) {
            LOG.error("Failed to render ", (Throwable)e);
            return false;
        }
        catch (ToolRenderException e) {
            LOG.error("Failed to render ", (Throwable)e);
            return false;
        }
    }

    public void reset(ToolConfiguration configuration) {
        this.registry.reset(configuration);
    }

    public PortletDD getPortletDD(Placement placement) {
        Properties configProperties;
        Properties toolProperties = placement.getPlacementConfig();
        String portletName = null;
        String appName = null;
        String fred = null;
        if (toolProperties != null) {
            portletName = toolProperties.getProperty("portlet-name");
            appName = toolProperties.getProperty("portlet-app-name");
            fred = toolProperties.getProperty("FRED");
        }
        if ((configProperties = placement.getConfig()) != null) {
            if (portletName == null) {
                portletName = configProperties.getProperty("portlet-name");
            }
            if (appName == null) {
                appName = configProperties.getProperty("portlet-app-name");
            }
        }
        PortletDD pdd = PortletContextManager.getManager().getPortletDescriptor(appName, portletName);
        return pdd;
    }

    public boolean isPortletModeAllowed(Placement placement, String mode) {
        if (placement == null || mode == null) {
            return false;
        }
        PortletDD pdd = this.getPortletDD(placement);
        if (pdd == null) {
            return true;
        }
        for (SupportsDD sup : pdd.getSupports()) {
            Iterator modes = sup.getPortletModes().iterator();
            while (modes.hasNext()) {
                if (!modes.next().toString().equalsIgnoreCase(mode.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public PortalService getPortalService() {
        return this.portalService;
    }

    public void setPortalService(PortalService portalService) {
        this.portalService = portalService;
    }

    private class Sakai168RenderResult
    implements RenderResult {
        private HttpServletRequest req = null;
        private HttpServletResponse response = null;
        private PortletContainer portletContainer = null;
        private String storedContent = null;
        private BufferedServletResponse bufferedResponse = null;
        private Exception bufferedException = null;
        private SakaiPortletWindow window = null;
        private String helpUrl = null;
        private String editUrl = null;

        public Sakai168RenderResult(HttpServletRequest req, HttpServletResponse response, PortletContainer pc, SakaiPortletWindow window, String helpUrl, String editUrl) {
            this.req = req;
            this.response = response;
            this.portletContainer = pc;
            this.window = window;
            this.helpUrl = helpUrl;
            this.editUrl = editUrl;
        }

        private void renderResponse() throws ToolRenderException {
            if (this.bufferedResponse == null) {
                this.bufferedResponse = new BufferedServletResponse(this.response);
                try {
                    this.portletContainer.doRender((PortletWindow)this.window, this.req, (HttpServletResponse)this.bufferedResponse);
                }
                catch (PortletException e) {
                    throw new ToolRenderException(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new ToolRenderException(e.getMessage(), (Throwable)e);
                }
                catch (PortletContainerException e) {
                    throw new ToolRenderException(e.getMessage(), (Throwable)e);
                }
            }
        }

        public String getContent() throws ToolRenderException {
            if (this.storedContent != null) {
                return this.storedContent;
            }
            if (this.bufferedException != null) {
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                this.bufferedException.printStackTrace(printWriter);
                String storedContent = "<div class=\"portlettraceback\">\n" + FormattedText.escapeHtml((String)((Object)result).toString(), (boolean)true) + "\n</pre>\n";
                return storedContent;
            }
            try {
                this.renderResponse();
                this.storedContent = this.bufferedResponse.getInternalBuffer().getBuffer().toString();
                if (!"true".equals(ServerConfigurationService.getString((String)"portal.portlet.tidy.warnings", (String)"false"))) {
                    return this.storedContent;
                }
                Tidy tidy = new Tidy();
                tidy.setIndentContent(true);
                tidy.setSmartIndent(true);
                tidy.setPrintBodyOnly(true);
                tidy.setTidyMark(false);
                tidy.setDocType("loose");
                StringReader is = new StringReader(this.storedContent);
                StringWriter os = new StringWriter();
                tidy.parse((Reader)is, (Writer)os);
                return this.storedContent;
            }
            catch (ToolRenderException e) {
                this.bufferedException = e;
                throw e;
            }
        }

        public void setContent(String content) {
            this.storedContent = content;
        }

        public String getTitle() throws ToolRenderException {
            if (this.bufferedException == null) {
                try {
                    this.renderResponse();
                    return Web.escapeHtml((String)PortletStateAccess.getPortletState(this.req, this.window.getId().getStringId()).getTitle());
                }
                catch (Exception e) {
                    this.bufferedException = e;
                }
            }
            return this.bufferedException.toString();
        }

        public String getJSR168EditUrl() {
            return this.editUrl;
        }

        public String getJSR168HelpUrl() {
            return this.helpUrl;
        }

        public String getHead() {
            return "";
        }
    }
}

