/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.portlet.services.state;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortletState
implements Serializable {
    private static final Log LOG = LogFactory.getLog(PortletState.class);
    private String id;
    private boolean action;
    private boolean secure;
    private Map parameters;
    private transient PortletMode portletMode;
    private transient WindowState windowState;
    private String title;
    private Map requestProperties;
    private Map responseProperties;

    public PortletState(String id) {
        this.id = id;
        this.portletMode = PortletMode.VIEW;
        this.windowState = WindowState.NORMAL;
        this.parameters = new HashMap();
    }

    public PortletState(PortletState currentState) {
        this(currentState.getId());
        this.setAction(currentState.isAction());
        this.setSecure(currentState.isSecure());
        this.getParameters().putAll(currentState.getParameters());
        this.setPortletMode(currentState.getPortletMode());
        this.setWindowState(currentState.getWindowState());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isAction() {
        return this.action;
    }

    public void setAction(boolean action) {
        this.action = action;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Map getParameters() {
        return new HashMap(this.parameters);
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void setPortletMode(PortletMode portletMode) {
        this.portletMode = portletMode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setWindowState(WindowState windowState) {
        this.windowState = windowState;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map getRequestProperties() {
        return this.requestProperties;
    }

    public void setRequestProperties(Map requestProperties) {
        this.requestProperties = requestProperties;
    }

    public Map getResponseProperties() {
        return this.responseProperties;
    }

    public void setResponseProperties(Map responseProperties) {
        this.responseProperties = responseProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortletState that = (PortletState)o;
        if (this.action != that.action) {
            return false;
        }
        if (this.secure != that.secure) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.parameters != null ? !((Object)this.parameters).equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.portletMode != null ? !this.portletMode.equals((Object)that.portletMode) : that.portletMode != null) {
            return false;
        }
        return !(this.windowState != null ? !this.windowState.equals((Object)that.windowState) : that.windowState != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.action ? 1 : 0);
        result = 31 * result + (this.secure ? 1 : 0);
        result = 31 * result + (this.parameters != null ? ((Object)this.parameters).hashCode() : 0);
        result = 31 * result + (this.portletMode != null ? this.portletMode.hashCode() : 0);
        result = 31 * result + (this.windowState != null ? this.windowState.hashCode() : 0);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Serializing PortletState [action=" + this.action + "]"));
        }
        out.writeObject(this.id);
        out.writeBoolean(this.action);
        out.writeBoolean(this.secure);
        out.writeObject(this.parameters);
        out.writeObject(this.portletMode.toString());
        out.writeObject(this.windowState.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.id = in.readObject().toString();
        this.action = in.readBoolean();
        this.secure = in.readBoolean();
        this.parameters = (Map)in.readObject();
        this.portletMode = new PortletMode(in.readObject().toString());
        this.windowState = new WindowState(in.readObject().toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deserializing PortletState [action=" + this.action + "]"));
        }
    }
}

