/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.portlet.servlet;

import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.portal.render.portlet.services.state.PortletState;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.cover.SessionManager;

public class SakaiServletUtil {
    public static boolean isUserInRole(String string, PortletState state) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("admin") && SecurityService.isSuperUser()) {
            return true;
        }
        if (string.equalsIgnoreCase("super") && SecurityService.isSuperUser()) {
            return true;
        }
        String placementId = state.getId();
        ToolConfiguration siteTool = SiteService.findTool((String)placementId);
        if (siteTool == null) {
            return false;
        }
        String siteId = siteTool.getSiteId();
        String siteReference = SiteService.siteReference((String)siteId);
        if (SecurityService.unlock((String)string, (String)siteReference)) {
            return true;
        }
        Session session = SessionManager.getCurrentSession();
        if (session == null) {
            return false;
        }
        String userId = session.getUserId();
        try {
            Site site = SiteService.getSite((String)siteId);
            Role role = site.getUserRole(userId);
            if (role == null) {
                return false;
            }
            if (string.equalsIgnoreCase(role.getId())) {
                return true;
            }
        }
        catch (IdUnusedException e) {
            return false;
        }
        if (string.equalsIgnoreCase("student") && SecurityService.unlock((String)SiteService.SITE_VISIT, (String)siteReference)) {
            return true;
        }
        return string.equalsIgnoreCase("instructor") && SecurityService.unlock((String)SiteService.SECURE_UPDATE_SITE, (String)siteReference);
    }
}

