/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.portlet.services.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.sakaiproject.portal.render.portlet.services.state.PortletState;
import org.sakaiproject.portal.render.portlet.services.state.PortletStateEncoder;
import org.sakaiproject.portal.render.portlet.services.state.WebRecoder;

public class SimplePortletStateEncoder
implements PortletStateEncoder {
    private WebRecoder urlSafeEncoder;

    public WebRecoder getUrlSafeEncoder() {
        return this.urlSafeEncoder;
    }

    public void setUrlSafeEncoder(WebRecoder urlSafeEncoder) {
        this.urlSafeEncoder = urlSafeEncoder;
    }

    public String encode(PortletState state) {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bao);
            out.writeObject(state);
            out.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Should never happen");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
        byte[] bits = bao.toByteArray();
        return this.urlSafeEncoder.encode(bits);
    }

    public PortletState decode(String encodedState) {
        byte[] decoded = this.urlSafeEncoder.decode(encodedState);
        ByteArrayInputStream bai = new ByteArrayInputStream(decoded);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bai);
            PortletState portletState = (PortletState)in.readObject();
            return portletState;
        }
        catch (IOException e) {
            throw new IllegalStateException("Should never happen");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Stale PortletState; Class not found.");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException io) {}
            }
        }
    }
}

