/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.portlet;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.sakaiproject.portal.render.api.ToolRenderException;
import org.sakaiproject.portal.render.portlet.SakaiPortletWindow;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.Placement;

public class PortletRegistry {
    private Map<String, SakaiPortletWindow> portletWindows = new HashMap<String, SakaiPortletWindow>();

    public SakaiPortletWindow getOrCreatePortletWindow(Placement placement) throws ToolRenderException {
        if (!this.portletWindows.containsKey(placement.getId())) {
            this.createPortletWindow(placement);
        }
        return this.getPortletWindow(placement.getId());
    }

    public SakaiPortletWindow getPortletWindow(String placementId) {
        return this.portletWindows.get(placementId);
    }

    private void createPortletWindow(Placement placement) throws ToolRenderException {
        SakaiPortletConfig pc = new SakaiPortletConfig(placement);
        if (!pc.isPortletConfig()) {
            return;
        }
        String windowId = placement.getId();
        SakaiPortletWindow window = new SakaiPortletWindow(windowId, pc.contextPath, pc.portletName);
        this.portletWindows.put(windowId, window);
    }

    public boolean isPortletApplication(Placement placement) {
        SakaiPortletConfig pc = new SakaiPortletConfig(placement);
        return pc.isPortletConfig();
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void reset(ToolConfiguration configuration) {
        this.portletWindows.remove(configuration.getId());
    }

    public class SakaiPortletConfig {
        private String portletName = null;
        private String contextPath = null;
        private boolean portlet = false;

        public SakaiPortletConfig(Placement placement) {
            Properties configProperties;
            if (placement == null) {
                return;
            }
            Properties toolProperties = placement.getPlacementConfig();
            if (toolProperties != null) {
                this.contextPath = toolProperties.getProperty("portlet-context");
                this.portletName = toolProperties.getProperty("portlet-name");
            }
            if ((configProperties = placement.getConfig()) != null) {
                if (PortletRegistry.isEmpty(this.contextPath)) {
                    this.contextPath = configProperties.getProperty("portlet-context");
                }
                if (PortletRegistry.isEmpty(this.portletName)) {
                    this.portletName = configProperties.getProperty("portlet-name");
                }
            }
            this.portlet = !PortletRegistry.isEmpty(this.contextPath) && !PortletRegistry.isEmpty(this.portletName);
        }

        public boolean isPortletConfig() {
            return this.portlet;
        }
    }
}

