/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.compat;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.portal.api.Portal;
import org.sakaiproject.portal.render.api.RenderResult;
import org.sakaiproject.portal.render.api.ToolRenderException;
import org.sakaiproject.portal.render.api.ToolRenderService;
import org.sakaiproject.site.api.ToolConfiguration;

public class CompatibilityToolRenderService
implements ToolRenderService {
    private static final Log LOG = LogFactory.getLog(CompatibilityToolRenderService.class);
    private List renderServices = null;

    public boolean preprocess(Portal portal, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException {
        boolean continueProcessing = true;
        for (ToolRenderService trs : this.renderServices) {
            LOG.debug((Object)("Preprocessing with " + trs));
            continueProcessing = continueProcessing && trs.preprocess(portal, request, response, context);
        }
        return continueProcessing;
    }

    public RenderResult render(Portal portal, ToolConfiguration configuration, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException {
        for (ToolRenderService trs : this.renderServices) {
            if (!trs.accept(portal, configuration, request, response, context)) continue;
            LOG.debug((Object)("Rendering with " + trs));
            return trs.render(portal, configuration, request, response, context);
        }
        throw new ToolRenderException("No available Tool Render Service for the tool " + configuration.getToolId());
    }

    public boolean accept(Portal portal, ToolConfiguration configuration, HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        for (ToolRenderService trs : this.renderServices) {
            if (!trs.accept(portal, configuration, request, response, context)) continue;
            return true;
        }
        return false;
    }

    public List getRenderServices() {
        return this.renderServices;
    }

    public void setRenderServices(List renderServices) {
        this.renderServices = renderServices;
    }

    public void reset(ToolConfiguration configuration) {
        for (ToolRenderService trs : this.renderServices) {
            trs.reset(configuration);
        }
    }
}

