/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.portlet.services;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.internal.InternalPortletPreference;
import org.apache.pluto.internal.impl.PortletPreferenceImpl;
import org.apache.pluto.spi.optional.PortalAdministrationService;
import org.apache.pluto.spi.optional.PortletEnvironmentService;
import org.apache.pluto.spi.optional.PortletInfoService;
import org.apache.pluto.spi.optional.PortletInvocationEvent;
import org.apache.pluto.spi.optional.PortletInvocationListener;
import org.apache.pluto.spi.optional.PortletInvokerService;
import org.apache.pluto.spi.optional.PortletPreferencesService;
import org.apache.pluto.spi.optional.PortletRegistryService;
import org.apache.pluto.spi.optional.RequestAttributeService;
import org.apache.pluto.spi.optional.UserInfoService;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;

public class SakaiOptionalPortletContainerServices
implements OptionalContainerServices {
    private static Log M_log = LogFactory.getLog(SakaiOptionalPortletContainerServices.class);
    protected static final String CURRENT_PLACEMENT = "sakai:ToolComponent:current.placement";
    private UserInfoService userInfoService = new SakaiUserInfoService();
    private PortalAdministrationService portalAdministrationService = new SakaiPortalAdministrationService();
    private PortletPreferencesService prefService = new SakaiPortletPreferencesService();
    private boolean prefLog = true;

    public PortletPreferencesService getPortletPreferencesService() {
        if (this.prefLog) {
            M_log.info((Object)("Sakai Optional Portal Services returning " + this.prefService));
        }
        this.prefLog = false;
        return this.prefService;
    }

    public PortletRegistryService getPortletRegistryService() {
        return null;
    }

    public PortletEnvironmentService getPortletEnvironmentService() {
        return null;
    }

    public PortletInvokerService getPortletInvokerService() {
        return null;
    }

    public PortletInfoService getPortletInfoService() {
        return null;
    }

    public RequestAttributeService getRequestAttributeService() {
        return null;
    }

    public PortalAdministrationService getPortalAdministrationService() {
        return this.portalAdministrationService;
    }

    public UserInfoService getUserInfoService() {
        return this.userInfoService;
    }

    private void setupThread(PortletRequest request, boolean doLog) {
        String placementId = (String)request.getAttribute("org.sakaiproject.portal.api.PortalService_placementid");
        if (placementId == null) {
            if (doLog) {
                M_log.info((Object)"No Placement found");
            }
            return;
        }
        Session session = SessionManager.getCurrentSession();
        if (session == null) {
            if (doLog) {
                M_log.info((Object)("No Session found placementId=" + placementId));
            }
            return;
        }
        Placement ppp = (Placement)ThreadLocalManager.get((String)CURRENT_PLACEMENT);
        if (ppp != null && placementId.equals(ppp.getId())) {
            return;
        }
        ToolConfiguration siteTool = SiteService.findTool((String)placementId);
        if (siteTool == null) {
            if (doLog) {
                M_log.info((Object)("No ToolConfiguration found, placementId=" + placementId + " session=" + session));
            }
            return;
        }
        ThreadLocalManager.set((String)CURRENT_PLACEMENT, (Object)siteTool);
    }

    public class SakaiPortletPreferencesService
    implements PortletPreferencesService {
        public InternalPortletPreference[] getStoredPreferences(PortletWindow portletWindow, PortletRequest request) throws PortletContainerException {
            boolean readOnly = true;
            SakaiOptionalPortletContainerServices.this.setupThread(request, true);
            String key = portletWindow.getId().getStringId();
            ToolConfiguration siteTool = SiteService.findTool((String)key);
            ArrayList<PortletPreferenceImpl> prefArray = new ArrayList<PortletPreferenceImpl>();
            if (siteTool != null) {
                String siteId = siteTool.getSiteId();
                String siteReference = SiteService.siteReference((String)siteId);
                readOnly = !SecurityService.unlock((String)SiteService.SECURE_UPDATE_SITE, (String)siteReference);
                Properties props = siteTool.getPlacementConfig();
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    PortletPreferenceImpl newPref;
                    String propertyValue;
                    String propertyName = (String)e.nextElement();
                    if (propertyName != null && propertyName.startsWith("javax.portlet:") && propertyName.length() > 14) {
                        propertyValue = props.getProperty(propertyName);
                        String[] propertyList = this.deSerializeStringArray(propertyValue);
                        String internalName = propertyName.substring(14);
                        newPref = new PortletPreferenceImpl(internalName, propertyList, readOnly);
                        prefArray.add(newPref);
                        continue;
                    }
                    if (propertyName == null) continue;
                    propertyValue = props.getProperty(propertyName);
                    String internalName = "sakai:" + propertyName;
                    String[] propertyList = new String[]{propertyValue};
                    newPref = new PortletPreferenceImpl(internalName, propertyList, readOnly);
                    prefArray.add(newPref);
                }
            }
            InternalPortletPreference[] preferences = new InternalPortletPreference[prefArray.size()];
            preferences = prefArray.toArray(preferences);
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("Got " + preferences.length + " stored preferences."));
            }
            return preferences;
        }

        public void store(PortletWindow portletWindow, PortletRequest request, InternalPortletPreference[] preferences) throws PortletContainerException {
            SakaiOptionalPortletContainerServices.this.setupThread(request, true);
            String key = portletWindow.getId().getStringId();
            ToolConfiguration siteTool = SiteService.findTool((String)key);
            if (siteTool == null) {
                return;
            }
            Properties props = siteTool.getPlacementConfig();
            if (props == null) {
                return;
            }
            String siteId = siteTool.getSiteId();
            String siteReference = SiteService.siteReference((String)siteId);
            if (!SecurityService.unlock((String)SiteService.SECURE_UPDATE_SITE, (String)siteReference)) {
                return;
            }
            boolean changed = false;
            if (props != null) {
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String propertyName = (String)e.nextElement();
                    if (propertyName != null && propertyName.startsWith("javax.portlet:") && propertyName.length() > 14) {
                        String internalName = propertyName.substring(14);
                        boolean found = false;
                        for (int i = 0; i < preferences.length; ++i) {
                            String propName;
                            if (preferences[i] == null || !internalName.equals(propName = preferences[i].getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        props.remove(propertyName);
                        changed = true;
                        continue;
                    }
                    boolean found = false;
                    for (int i = 0; i < preferences.length; ++i) {
                        String propName;
                        if (preferences[i] == null || !propertyName.equals(propName = "sakai:" + preferences[i].getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    props.remove(propertyName);
                    changed = true;
                }
            }
            for (int i = 0; i < preferences.length; ++i) {
                String propName;
                if (preferences[i] == null || props == null || (propName = preferences[i].getName()) == null || propName.length() < 1) continue;
                String propKey = "javax.portlet:" + propName;
                String storeString = this.serializeStringArray(preferences[i].getValues());
                if (propName.startsWith("sakai:") && propName.length() > 6) {
                    propKey = propName.substring(6);
                    storeString = preferences[i].getValues()[0];
                }
                String oldString = props.getProperty(propKey);
                if (storeString == null || storeString.equals(oldString)) continue;
                props.setProperty(propKey, storeString);
                changed = true;
            }
            if (changed && siteTool != null) {
                siteTool.save();
            }
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("Portlet preferences stored for: " + key));
            }
        }

        private String serializeStringArray(String[] input) {
            if (input == null || input.length < 1) {
                return null;
            }
            StringBuffer retval = new StringBuffer();
            for (int i = 0; i < input.length; ++i) {
                if (i > 0) {
                    retval.append("!");
                }
                if (input[i] == null) continue;
                retval.append(URLEncoder.encode(input[i]));
            }
            return retval.toString();
        }

        private String[] deSerializeStringArray(String input) {
            String[] retval = input.split("!");
            for (int i = 0; i < retval.length; ++i) {
                if (retval[i] == null) continue;
                retval[i] = URLDecoder.decode(retval[i]);
            }
            return retval;
        }
    }

    public class SakaiPortalAdministrationService
    implements PortalAdministrationService {
        private List administrativeRequestListeners = null;
        private List portletInvocationListeners = null;

        public List getAdministrativeRequestListeners() {
            if (this.administrativeRequestListeners == null) {
                this.administrativeRequestListeners = new ArrayList();
            }
            return this.administrativeRequestListeners;
        }

        public List getPortletInvocationListeners() {
            if (this.portletInvocationListeners == null) {
                this.portletInvocationListeners = new ArrayList(1);
                this.portletInvocationListeners.add(new SakaiPortletServletListener());
            }
            return this.portletInvocationListeners;
        }

        public class SakaiPortletServletListener
        implements PortletInvocationListener {
            public void onBegin(PortletInvocationEvent event) {
                SakaiOptionalPortletContainerServices.this.setupThread(event.getPortletRequest(), true);
            }

            public void onEnd(PortletInvocationEvent event) {
            }

            public void onError(PortletInvocationEvent event, Throwable error) {
            }
        }
    }

    public class SakaiUserInfoService
    implements UserInfoService {
        public Map getUserInfo(PortletRequest request, PortletWindow window) throws PortletContainerException {
            return this.getUserInfo(request);
        }

        public Map getUserInfo(PortletRequest request) throws PortletContainerException {
            HashMap<String, String> retval = null;
            SakaiOptionalPortletContainerServices.this.setupThread(request, true);
            User user = UserDirectoryService.getCurrentUser();
            if (user != null) {
                retval = new HashMap<String, String>();
                retval.put("user.home-info.online.email", user.getEmail());
                retval.put("user.business-info.online.email", user.getEmail());
                retval.put("user.name.given", user.getFirstName());
                retval.put("user.name.family", user.getLastName());
                retval.put("user.name.nickName", user.getDisplayName());
                retval.put("user.name", user.getEid());
                retval.put("user.id", user.getEid());
                retval.put("user.login.id", user.getEid());
                retval.put("user.name.full", user.getDisplayName());
                retval.put("user.name.first", user.getFirstName());
                retval.put("user.name.last", user.getLastName());
                retval.put("user.email", user.getEmail());
            }
            if (retval == null) {
                retval = new HashMap();
            }
            return retval;
        }
    }
}

