/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.portlet.services;

import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.spi.PortalCallbackService;
import org.apache.pluto.spi.PortletURLProvider;
import org.apache.pluto.spi.ResourceURLProvider;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.render.portlet.services.state.EnhancedPortletStateEncoder;
import org.sakaiproject.portal.render.portlet.services.state.PortletState;
import org.sakaiproject.portal.render.portlet.services.state.PortletStateAccess;
import org.sakaiproject.portal.render.portlet.services.state.PortletStateEncoder;

public class SakaiPortalCallbackService
implements PortalCallbackService {
    private static final Log LOG = LogFactory.getLog(SakaiPortalCallbackService.class);
    public static final String PORTLET_STATE_QUERY_PARAM = "org.sakaiproject.portal.pluto.PORTLET_STATE";
    private PortletStateEncoder portletStateEncoder = new EnhancedPortletStateEncoder();

    public PortletStateEncoder getPortletStateEncoder() {
        return this.portletStateEncoder;
    }

    public void setPortletStateEncoder(PortletStateEncoder portletStateEncoder) {
        this.portletStateEncoder = portletStateEncoder;
    }

    public void setTitle(HttpServletRequest request, PortletWindow window, String title) {
        LOG.debug((Object)("Setting portlet title for window '" + window.getId() + "' to '" + title + "'."));
        PortletStateAccess.getPortletState(request, window.getId().getStringId()).setTitle(title);
    }

    public PortletURLProvider getPortletURLProvider(HttpServletRequest request, PortletWindow window) {
        PortletState currentState = PortletStateAccess.getPortletState(request, window.getId().getStringId());
        PortletState state = null;
        state = currentState != null ? new PortletState(currentState) : new PortletState(window.getId().getStringId());
        String baseUrl = request.getRequestURI();
        return new SakaiPortletURLProvider(baseUrl, state);
    }

    public ResourceURLProvider getResourceURLProvider(HttpServletRequest request, PortletWindow window) {
        return new SakaiResourceURLProvider("");
    }

    public Map getRequestProperties(HttpServletRequest request, PortletWindow window) {
        PortletState currentState = PortletStateAccess.getPortletState(request, window.getId().getStringId());
        return currentState.getRequestProperties();
    }

    public void setResponseProperty(HttpServletRequest request, PortletWindow window, String key, String value) {
        PortletState currentState = PortletStateAccess.getPortletState(request, window.getId().getStringId());
        currentState.getResponseProperties().put(key, value);
    }

    public void addResponseProperty(HttpServletRequest request, PortletWindow window, String key, String value) {
        PortletState currentState = PortletStateAccess.getPortletState(request, window.getId().getStringId());
        currentState.getResponseProperties().put(key, value);
    }

    public class SakaiResourceURLProvider
    implements ResourceURLProvider {
        private String base;
        private String path;
        private String absolute;

        public SakaiResourceURLProvider(String serverUri) {
            this.base = serverUri;
        }

        public void setAbsoluteURL(String string) {
            this.absolute = string;
        }

        public void setFullPath(String string) {
            this.path = string;
        }

        public String toString() {
            if (this.absolute != null) {
                return this.absolute;
            }
            return this.base + this.path;
        }
    }

    class SakaiPortletURLProvider
    implements PortletURLProvider {
        private String baseUrl;
        private PortletState portletState;

        public SakaiPortletURLProvider(String baseUrl, PortletState portletState) {
            this.baseUrl = baseUrl;
            this.portletState = portletState;
        }

        public void setPortletMode(PortletMode portletMode) {
            this.portletState.setPortletMode(portletMode);
        }

        public void setWindowState(WindowState windowState) {
            this.portletState.setWindowState(windowState);
        }

        public void setAction(boolean b) {
            this.portletState.setAction(b);
        }

        public void setSecure() {
            this.portletState.setSecure(true);
        }

        public void clearParameters() {
            this.portletState.clearParameters();
        }

        public void setParameters(Map map) {
            this.portletState.setParameters(map);
        }

        public String toString() {
            return this.baseUrl + "?" + SakaiPortalCallbackService.PORTLET_STATE_QUERY_PARAM + "=" + SakaiPortalCallbackService.this.portletStateEncoder.encode(this.portletState);
        }

        public boolean isSecureSupported() {
            String portalUrl = ServerConfigurationService.getPortalUrl();
            if (portalUrl == null) {
                return false;
            }
            return portalUrl.startsWith("https:");
        }
    }
}

