/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.service;

import org.sakaiproject.authz.api.FunctionManager;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.portal.api.PortalChatPermittedHelper;
import org.sakaiproject.site.api.SiteService;

public class PortalChatPermittedHelperImpl
implements PortalChatPermittedHelper {
    private static final String PORTAL_CHAT_PERMITTED = "portal.chat.permitted";
    private SecurityService securityService;
    private SiteService siteService;
    private FunctionManager functionManager;
    private ServerConfigurationService serverConfigurationService;
    private boolean securedByUser = false;

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setFunctionManager(FunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void init() {
        this.functionManager.registerFunction(PORTAL_CHAT_PERMITTED);
        this.securedByUser = this.serverConfigurationService.getBoolean("portal.chat.securedByUser", false);
    }

    public boolean checkChatPermitted(String userId) {
        if (this.securedByUser) {
            if (userId != null && !userId.equals("")) {
                String userSiteId = this.siteService.getUserSiteId(userId);
                return this.securityService.unlock(userId, PORTAL_CHAT_PERMITTED, "/site/" + userSiteId);
            }
            return false;
        }
        return true;
    }
}

