/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.alias.api.Alias;
import org.sakaiproject.alias.api.AliasService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.portal.api.SiteNeighbourhoodService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.user.api.Preferences;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

public class SiteNeighbourhoodServiceImpl
implements SiteNeighbourhoodService {
    private static final String SITE_ALIAS = "/sitealias/";
    private static final Log log = LogFactory.getLog(SiteNeighbourhoodServiceImpl.class);
    private SiteService siteService;
    private PreferencesService preferencesService;
    private UserDirectoryService userDirectoryService;
    private ServerConfigurationService serverConfigurationService;
    private AliasService aliasService;
    private boolean useAliasPrefix = false;
    private boolean useSiteAliases = false;

    public void init() {
        this.useSiteAliases = this.serverConfigurationService.getBoolean("portal.use.site.aliases", false);
    }

    public void destroy() {
    }

    public List<Site> getSitesAtNode(HttpServletRequest request, Session session, boolean includeMyWorkspace) {
        return this.getAllSites(request, session, includeMyWorkspace);
    }

    public List<Site> getAllSites(HttpServletRequest req, Session session, boolean includeMyWorkspace) {
        Site s;
        Site s2;
        boolean loggedIn;
        boolean bl = loggedIn = session.getUserId() != null;
        if (!loggedIn) {
            List<Site> mySites = this.getGatewaySites();
            return mySites;
        }
        ArrayList<Site> mySites = this.siteService.getUserSites(false);
        List prefExclude = new ArrayList();
        List prefOrder = new ArrayList();
        if (session.getUserId() != null) {
            Preferences prefs = this.preferencesService.getPreferences(session.getUserId());
            ResourceProperties props = prefs.getProperties("sakai:portal:sitenav");
            List l = props.getPropertyList("exclude");
            if (l != null) {
                prefExclude = l;
            }
            if ((l = props.getPropertyList("order")) != null) {
                prefOrder = l;
            }
        }
        ArrayList<Site> visibleSites = new ArrayList<Site>();
        for (Site site : mySites) {
            if (prefExclude.contains(site.getId())) continue;
            visibleSites.add(site);
        }
        mySites = visibleSites;
        Vector<Site> ordered = new Vector<Site>();
        HashSet<String> added = new HashSet<String>();
        Site myWorkspace = this.getMyWorkspace(session);
        if (myWorkspace != null) {
            if (includeMyWorkspace) {
                ordered.add(myWorkspace);
                added.add(myWorkspace.getId());
            } else {
                int pos = this.listIndexOf(myWorkspace.getId(), mySites);
                if (pos != -1) {
                    mySites.remove(pos);
                }
            }
        }
        for (String id : prefOrder) {
            int pos = this.listIndexOf(id, mySites);
            if (pos == -1 || added.contains((s2 = (Site)mySites.get(pos)).getId())) continue;
            ordered.add(s2);
            added.add(s2.getId());
        }
        boolean haveChildren = false;
        int siteCount = mySites.size();
        for (int i = 0; i < mySites.size(); ++i) {
            s2 = (Site)mySites.get(i);
            if (added.contains(s2.getId())) continue;
            String ourParent = null;
            if (prefOrder.size() == 0) {
                ResourceProperties rp = s2.getProperties();
                ourParent = rp.getProperty("sakai:parent-id");
            }
            if (siteCount > 200 || ourParent == null) {
                ordered.add(s2);
                added.add(s2.getId());
                continue;
            }
            haveChildren = true;
        }
        boolean addedSites = true;
        int depth = 0;
        while (depth < 20 && addedSites && haveChildren) {
            ++depth;
            addedSites = false;
            haveChildren = false;
            for (int i = mySites.size() - 1; i >= 0; --i) {
                ResourceProperties rp;
                String ourParent;
                s = (Site)mySites.get(i);
                if (added.contains(s.getId()) || (ourParent = (rp = s.getProperties()).getProperty("sakai:parent-id")) == null) continue;
                haveChildren = true;
                boolean found = false;
                int j = -1;
                for (j = ordered.size() - 1; j >= 0; --j) {
                    Site ps = (Site)ordered.get(j);
                    if (ourParent.equals(ps.getId())) {
                        found = true;
                        break;
                    }
                    rp = ps.getProperties();
                    String peerParent = rp.getProperty("sakai:parent-id");
                    if (!ourParent.equals(peerParent)) continue;
                    found = true;
                    break;
                }
                if (!found || ++j < 0 || j >= ordered.size()) continue;
                ordered.insertElementAt(s, j);
                added.add(s.getId());
                addedSites = true;
            }
        }
        if (haveChildren) {
            for (int i = 0; i < mySites.size(); ++i) {
                s = (Site)mySites.get(i);
                if (added.contains(s.getId())) continue;
                ordered.add(s);
            }
        }
        mySites = ordered;
        return mySites;
    }

    private List<Site> getGatewaySites() {
        ArrayList<Site> mySites = new ArrayList<Site>();
        String[] gatewaySiteIds = this.getGatewaySiteList();
        if (gatewaySiteIds == null) {
            return mySites;
        }
        for (int i = 0; i < gatewaySiteIds.length; ++i) {
            String siteId = gatewaySiteIds[i];
            Site site = null;
            try {
                site = this.getSiteVisit(siteId);
            }
            catch (IdUnusedException e) {
                continue;
            }
            catch (PermissionException e) {
                continue;
            }
            if (site == null) continue;
            mySites.add(site);
        }
        if (mySites.size() < 1) {
            log.warn((Object)("No suitable gateway sites found, gatewaySiteList preference had " + gatewaySiteIds.length + " sites."));
        }
        return mySites;
    }

    private Site getMyWorkspace(Session session) {
        String siteId = this.siteService.getUserSiteId(session.getUserId());
        Site site = null;
        try {
            site = this.getSiteVisit(siteId);
        }
        catch (IdUnusedException e) {
            site = null;
        }
        catch (PermissionException e) {
            site = null;
        }
        return site;
    }

    private int listIndexOf(String value, List siteList) {
        for (int i = 0; i < siteList.size(); ++i) {
            Site site = (Site)siteList.get(i);
            if (!site.getId().equals(value)) continue;
            return i;
        }
        return -1;
    }

    private String[] getGatewaySiteList() {
        String gatewaySiteListPref = this.serverConfigurationService.getString("gatewaySiteList");
        if (gatewaySiteListPref == null || gatewaySiteListPref.trim().length() < 1) {
            gatewaySiteListPref = this.serverConfigurationService.getGatewaySiteId();
        }
        if (gatewaySiteListPref == null || gatewaySiteListPref.trim().length() < 1) {
            return null;
        }
        String[] gatewaySites = gatewaySiteListPref.split(",");
        if (gatewaySites.length < 1) {
            return null;
        }
        return gatewaySites;
    }

    public Site getSiteVisit(String siteId) throws PermissionException, IdUnusedException {
        try {
            return this.siteService.getSiteVisit(siteId);
        }
        catch (IdUnusedException e) {
            if (this.siteService.isUserSite(siteId)) {
                try {
                    String userEid = this.siteService.getSiteUserId(siteId);
                    String userId = this.userDirectoryService.getUserId(userEid);
                    String alternateSiteId = this.siteService.getUserSiteId(userId);
                    return this.siteService.getSiteVisit(alternateSiteId);
                }
                catch (UserNotDefinedException userNotDefinedException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public PreferencesService getPreferencesService() {
        return this.preferencesService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public String lookupSiteAlias(String id, String context) {
        if (!this.useSiteAliases) {
            return null;
        }
        List aliases = this.aliasService.getAliases(id);
        if (aliases.size() > 0) {
            if (aliases.size() > 1 && log.isInfoEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("More than one alias for " + id + " sorting."));
                }
                Collections.sort(aliases, new Comparator<Alias>(){

                    @Override
                    public int compare(Alias o1, Alias o2) {
                        return o1.getId().compareTo(o2.getId());
                    }
                });
            }
            for (Alias alias : aliases) {
                String aliasId = alias.getId();
                boolean startsWithPrefix = aliasId.startsWith(SITE_ALIAS);
                if (startsWithPrefix) {
                    if (!this.useAliasPrefix) continue;
                    return aliasId.substring(SITE_ALIAS.length());
                }
                if (this.useAliasPrefix) continue;
                return aliasId;
            }
        }
        return null;
    }

    public String parseSiteAlias(String alias) {
        if (alias == null) {
            return null;
        }
        String id = (this.useAliasPrefix ? SITE_ALIAS : "") + alias;
        try {
            String reference = this.aliasService.getTarget(id);
            return reference;
        }
        catch (IdUnusedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No alias found for " + id));
            }
            return null;
        }
    }

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    public boolean isUseAliasPrefix() {
        return this.useAliasPrefix;
    }

    public void setUseAliasPrefix(boolean useAliasPrefix) {
        this.useAliasPrefix = useAliasPrefix;
    }
}

