/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.core.PortletContextManager;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.internal.InternalPortletContext;
import org.exolab.castor.util.LocalConfiguration;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.portal.api.BaseEditor;
import org.sakaiproject.portal.api.Editor;
import org.sakaiproject.portal.api.EditorRegistry;
import org.sakaiproject.portal.api.Portal;
import org.sakaiproject.portal.api.PortalHandler;
import org.sakaiproject.portal.api.PortalRenderEngine;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.api.PortletApplicationDescriptor;
import org.sakaiproject.portal.api.PortletDescriptor;
import org.sakaiproject.portal.api.SiteNeighbourhoodService;
import org.sakaiproject.portal.api.StoredState;
import org.sakaiproject.portal.api.StyleAbleProvider;
import org.sakaiproject.portal.service.StoredStateImpl;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.cover.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalServiceImpl
implements PortalService {
    private static final Logger log = LoggerFactory.getLogger(PortalServiceImpl.class);
    public static final String PARM_STATE_RESET = "sakai.state.reset";
    private Map<String, PortalRenderEngine> renderEngines = new ConcurrentHashMap<String, PortalRenderEngine>();
    private Map<String, Map<String, PortalHandler>> handlerMaps = new ConcurrentHashMap<String, Map<String, PortalHandler>>();
    private Map<String, Portal> portals = new ConcurrentHashMap<String, Portal>();
    private ServerConfigurationService serverConfigurationService;
    private StyleAbleProvider stylableServiceProvider;
    private SiteNeighbourhoodService siteNeighbourhoodService;
    private String m_portalLinks;
    private ContentHostingService contentHostingService;
    private EditorRegistry editorRegistry;
    private Editor noopEditor = new BaseEditor("noop", "noop", "", "");
    private static final String TOOLSTATE_PARAM_PREFIX = "toolstate-";

    public void init() {
        try {
            this.stylableServiceProvider = (StyleAbleProvider)ComponentManager.get((String)StyleAbleProvider.class.getName());
            this.serverConfigurationService = (ServerConfigurationService)ComponentManager.get((String)ServerConfigurationService.class.getName());
            try {
                Properties castorProperties = LocalConfiguration.getDefault();
                String parser = this.serverConfigurationService.getString("sakai.xml.sax.parser", "com.sun.org.apache.xerces.internal.parsers.SAXParser");
                log.info("Configured Castor to use SAX Parser " + parser);
                castorProperties.put("org.exolab.castor.parser", parser);
            }
            catch (Exception ex) {
                log.error("Failed to configure Castor", (Throwable)ex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.stylableServiceProvider == null) {
            log.info("No Styleable Provider found, the portal will not be stylable");
        }
    }

    public StoredState getStoredState() {
        Session s = SessionManager.getCurrentSession();
        StoredState ss = (StoredState)s.getAttribute("direct-stored-state");
        log.debug("Got Stored State as [" + ss + "]");
        return ss;
    }

    public void setStoredState(StoredState ss) {
        Session s = SessionManager.getCurrentSession();
        if (s.getAttribute("direct-stored-state") == null || ss == null) {
            StoredState ssx = (StoredState)s.getAttribute("direct-stored-state");
            log.debug("Removing Stored state " + ssx);
            if (ssx != null) {
                Exception ex = new Exception("traceback");
                log.debug("Removing active Stored State Traceback gives location ", (Throwable)ex);
            }
            s.setAttribute("direct-stored-state", (Object)ss);
            log.debug(" Set StoredState as [" + ss + "]");
        }
    }

    private static String computeToolStateParameterName(String placementId) {
        return TOOLSTATE_PARAM_PREFIX + placementId;
    }

    public String decodeToolState(Map<String, String[]> params, String placementId) {
        String attrname = PortalServiceImpl.computeToolStateParameterName(placementId);
        String[] attrval = params.get(attrname);
        return attrval == null ? null : attrval[0];
    }

    public Map<String, String[]> encodeToolState(String placementId, String URLstub) {
        String attrname = PortalServiceImpl.computeToolStateParameterName(placementId);
        HashMap<String, String[]> togo = new HashMap<String, String[]>();
        togo.put(attrname, new String[]{URLstub});
        return togo;
    }

    public String getResetState() {
        Session s = SessionManager.getCurrentSession();
        String ss = (String)s.getAttribute("reset-stored-state");
        return ss;
    }

    public void setResetState(String ss) {
        Session s = SessionManager.getCurrentSession();
        if (s.getAttribute("reset-stored-state") == null || ss == null) {
            s.setAttribute("reset-stored-state", (Object)ss);
        }
    }

    public boolean isEnableDirect() {
        boolean directEnable = "true".equals(this.serverConfigurationService.getString("charon.directurl", "true"));
        log.debug("Direct Enable is " + directEnable);
        return directEnable;
    }

    public boolean isResetRequested(HttpServletRequest req) {
        return "true".equals(req.getParameter(PARM_STATE_RESET)) || "true".equals(this.getResetState());
    }

    public String getResetStateParam() {
        return PARM_STATE_RESET;
    }

    public StoredState newStoredState(String marker, String replacement) {
        log.debug("Storing State for Marker=[" + marker + "] replacement=[" + replacement + "]");
        return new StoredStateImpl(marker, replacement);
    }

    public Iterator<PortletApplicationDescriptor> getRegisteredApplications() {
        PortletContextManager registry = PortletContextManager.getManager();
        final Iterator apps = registry.getRegisteredPortletApplications();
        return new Iterator<PortletApplicationDescriptor>(){

            @Override
            public boolean hasNext() {
                return apps.hasNext();
            }

            @Override
            public PortletApplicationDescriptor next() {
                final InternalPortletContext pc = (InternalPortletContext)apps.next();
                final PortletAppDD appDD = pc.getPortletApplicationDefinition();
                return new PortletApplicationDescriptor(){

                    public String getApplicationContext() {
                        return pc.getPortletContextName();
                    }

                    public String getApplicationId() {
                        return pc.getApplicationId();
                    }

                    public String getApplicationName() {
                        return pc.getApplicationId();
                    }

                    public Iterator<PortletDescriptor> getPortlets() {
                        if (appDD != null) {
                            List portlets = appDD.getPortlets();
                            final Iterator portletsI = portlets.iterator();
                            return new Iterator<PortletDescriptor>(){

                                @Override
                                public boolean hasNext() {
                                    return portletsI.hasNext();
                                }

                                @Override
                                public PortletDescriptor next() {
                                    final PortletDD pdd = (PortletDD)portletsI.next();
                                    return new PortletDescriptor(){

                                        public String getPortletId() {
                                            return pdd.getPortletName();
                                        }

                                        public String getPortletName() {
                                            return pdd.getPortletName();
                                        }
                                    };
                                }

                                @Override
                                public void remove() {
                                }
                            };
                        }
                        log.warn(" Portlet Application has no portlets " + pc.getPortletContextName());
                        return new Iterator<PortletDescriptor>(){

                            @Override
                            public boolean hasNext() {
                                return false;
                            }

                            @Override
                            public PortletDescriptor next() {
                                return null;
                            }

                            @Override
                            public void remove() {
                            }
                        };
                    }
                };
            }

            @Override
            public void remove() {
            }
        };
    }

    public PortalRenderEngine getRenderEngine(String context, HttpServletRequest request) {
        if (context == null || context.length() == 0) {
            context = "charon";
        }
        return this.renderEngines.get(context);
    }

    public void addRenderEngine(String context, PortalRenderEngine vengine) {
        this.renderEngines.put(context, vengine);
    }

    public void removeRenderEngine(String context, PortalRenderEngine vengine) {
        this.renderEngines.remove(context);
    }

    public void addHandler(Portal portal, PortalHandler handler) {
        String urlFragment;
        String portalContext = portal.getPortalContext();
        Map<String, PortalHandler> handlerMap = this.getHandlerMap(portal);
        PortalHandler ph = handlerMap.get(urlFragment = handler.getUrlFragment());
        if (ph != null) {
            handler.deregister(portal);
            log.warn("Handler Present on  " + urlFragment + " will replace " + ph + " with " + handler);
        }
        handler.register(portal, (PortalService)this, portal.getServletContext());
        handlerMap.put(urlFragment, handler);
        log.info("URL " + portalContext + ":/" + urlFragment + " will be handled by " + handler);
    }

    public void addHandler(String portalContext, PortalHandler handler) {
        Portal portal = this.portals.get(portalContext);
        if (portal == null) {
            Map<String, PortalHandler> handlerMap = this.getHandlerMap(portalContext, true);
            handlerMap.put(handler.getUrlFragment(), handler);
            log.debug("Registered handler (" + handler + ") for portal (" + portalContext + ") that doesn't yet exist.");
        } else {
            this.addHandler(portal, handler);
        }
    }

    public Map<String, PortalHandler> getHandlerMap(Portal portal) {
        return this.getHandlerMap(portal.getPortalContext(), true);
    }

    private Map<String, PortalHandler> getHandlerMap(String portalContext, boolean create) {
        Map<String, PortalHandler> handlerMap = this.handlerMaps.get(portalContext);
        if (create && handlerMap == null) {
            handlerMap = new ConcurrentHashMap<String, PortalHandler>();
            this.handlerMaps.put(portalContext, handlerMap);
        }
        return handlerMap;
    }

    public void removeHandler(Portal portal, String urlFragment) {
        PortalHandler ph;
        Map<String, PortalHandler> handlerMap = this.getHandlerMap(portal.getPortalContext(), false);
        if (handlerMap != null && (ph = handlerMap.get(urlFragment)) != null) {
            ph.deregister(portal);
            handlerMap.remove(urlFragment);
            log.warn("Handler Present on  " + urlFragment + " " + ph + " will be removed ");
        }
    }

    public void removeHandler(String portalContext, String urlFragment) {
        Portal portal = this.portals.get(portalContext);
        if (portal == null) {
            log.warn("Attempted to remove handler(" + urlFragment + ") from non existent portal (" + portalContext + ")");
        } else {
            this.removeHandler(portal, urlFragment);
        }
    }

    public void addPortal(Portal portal) {
        String portalContext = portal.getPortalContext();
        this.portals.put(portalContext, portal);
        Map<String, PortalHandler> phm = this.getHandlerMap(portal);
        for (PortalHandler ph : phm.values()) {
            ph.register(portal, (PortalService)this, portal.getServletContext());
        }
    }

    public void removePortal(Portal portal) {
        String portalContext = portal.getPortalContext();
        this.portals.remove(portalContext);
    }

    public StyleAbleProvider getStylableService() {
        return this.stylableServiceProvider;
    }

    public SiteNeighbourhoodService getSiteNeighbourhoodService() {
        return this.siteNeighbourhoodService;
    }

    public void setSiteNeighbourhoodService(SiteNeighbourhoodService siteNeighbourhoodService) {
        this.siteNeighbourhoodService = siteNeighbourhoodService;
    }

    public String getPortalLinks() {
        return this.m_portalLinks;
    }

    public ContentHostingService getContentHostingService() {
        return this.contentHostingService;
    }

    public void setPortalLinks(String portalLinks) {
        this.m_portalLinks = portalLinks;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public String getBrowserCollectionId(Placement placement) {
        String collectionId = null;
        if (placement != null) {
            collectionId = this.getContentHostingService().getSiteCollection(placement.getContext());
        }
        if (collectionId == null) {
            collectionId = this.getContentHostingService().getSiteCollection("~" + SessionManager.getCurrentSessionUserId());
        }
        return collectionId;
    }

    public Editor getActiveEditor() {
        return this.getActiveEditor(null);
    }

    public Editor getActiveEditor(Placement placement) {
        Editor editor;
        String activeEditor;
        block6: {
            String systemEditor;
            activeEditor = systemEditor = this.serverConfigurationService.getString("wysiwyg.editor", "ckeditor");
            if (placement != null) {
                try {
                    Site site = SiteService.getSite((String)placement.getContext());
                    Object o = site.getProperties().get("wysiwyg.editor");
                    if (o != null) {
                        activeEditor = o.toString();
                    }
                }
                catch (IdUnusedException ex) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug(ex.getMessage());
                }
            }
        }
        if ((editor = this.getEditorRegistry().getEditor(activeEditor)) == null) {
            editor = this.getEditorRegistry().getEditor("textarea");
        }
        if (editor == null) {
            editor = this.noopEditor;
        }
        return editor;
    }

    public EditorRegistry getEditorRegistry() {
        return this.editorRegistry;
    }

    public void setEditorRegistry(EditorRegistry editorRegistry) {
        this.editorRegistry = editorRegistry;
    }

    public String getSkinPrefix() {
        return "";
    }
}

