/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.service;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.core.PortletContextManager;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.internal.InternalPortletContext;
import org.apache.pluto.spi.optional.PortletRegistryEvent;
import org.apache.pluto.spi.optional.PortletRegistryListener;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.service.PortletTool;
import org.sakaiproject.tool.api.ActiveToolManager;
import org.sakaiproject.tool.api.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SakaiPortletRegistryListener
implements PortletRegistryListener {
    private static final Logger log = LoggerFactory.getLogger(SakaiPortletRegistryListener.class);
    private PortletContextManager registry;
    private ActiveToolManager activeToolManager;

    public void portletApplicationRegistered(PortletRegistryEvent evt) {
        try {
            PortletAppDD appDD = evt.getPortletApplicationDescriptor();
            String applicationID = evt.getApplicationId();
            ServletContext portalContext = null;
            InternalPortletContext iPortlet = null;
            Iterator iapps = this.registry.getRegisteredPortletApplications();
            while (iapps.hasNext()) {
                InternalPortletContext ipc = (InternalPortletContext)iapps.next();
                if (!applicationID.equals(ipc.getApplicationId())) continue;
                portalContext = ipc.getServletContext();
                iPortlet = ipc;
            }
            for (PortletDD pdd : appDD.getPortlets()) {
                List<Tool> toolRegs = this.getRegistrationsForPortlet(pdd, iPortlet, portalContext);
                if (toolRegs == null) {
                    PortletTool tool = new PortletTool(pdd, iPortlet, portalContext, null);
                    this.activeToolManager.register((Tool)tool, portalContext);
                    continue;
                }
                for (Tool t : toolRegs) {
                    PortletTool tool = new PortletTool(pdd, iPortlet, portalContext, t);
                    this.activeToolManager.register((Tool)tool, portalContext);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to register portlets as tools ", (Throwable)e);
        }
    }

    public List<Tool> getRegistrationsForPortlet(PortletDD pdd, InternalPortletContext portlet, ServletContext portalContext) {
        String webappRegPath;
        InputStream is;
        String portletName = pdd.getPortletName();
        String appName = portlet.getApplicationId();
        List toolRegs = null;
        String homePath = ServerConfigurationService.getSakaiHomePath() + "/portlets/";
        String portletReg = homePath + appName + "/" + portletName + ".xml";
        File toolRegFile = new File(portletReg);
        if (!toolRegFile.canRead()) {
            portletReg = homePath + portletName + ".xml";
        }
        if ((toolRegs = this.activeToolManager.parseTools(new File(portletReg))) != null) {
            log.info("Found " + toolRegs.size() + " Tool(s) to register from=" + portletReg);
        }
        if (toolRegs == null && (is = portalContext.getResourceAsStream(webappRegPath = "/WEB-INF/sakai/" + portletName + ".xml")) != null && (toolRegs = this.activeToolManager.parseTools(is)) != null) {
            log.info("Found " + toolRegs.size() + " Tool(s) to register from=" + webappRegPath);
        }
        return toolRegs;
    }

    public void portletApplicationRemoved(PortletRegistryEvent arg0) {
    }

    public void init() {
        this.registry = PortletContextManager.getManager();
        Iterator ids = this.registry.getRegisteredPortletApplicationIds();
        while (ids.hasNext()) {
            String id = (String)ids.next();
            try {
                PortletAppDD appDD = this.registry.getPortletApplicationDescriptor(id);
                PortletRegistryEvent event = new PortletRegistryEvent();
                event.setApplicationId(id);
                event.setPortletApplicationDescriptor(appDD);
                this.portletApplicationRegistered(event);
                log.info("Re-registered early portlet: " + id);
            }
            catch (PortletContainerException e) {
                log.error("Failed to re-register portlet: " + id, (Throwable)e);
            }
        }
        this.registry.addPortletRegistryListener((PortletRegistryListener)this);
    }

    public void destroy() {
        this.registry.removePortletRegistryListener((PortletRegistryListener)this);
    }

    public ActiveToolManager getActiveToolManager() {
        return this.activeToolManager;
    }

    public void setActiveToolManager(ActiveToolManager activeToolManager) {
        this.activeToolManager = activeToolManager;
    }
}

