/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sakaiproject.portal.api.BaseEditor;
import org.sakaiproject.portal.api.Editor;
import org.sakaiproject.portal.api.EditorRegistry;

public class EditorRegistryImpl
implements EditorRegistry {
    private HashMap<String, Editor> editors = new HashMap();

    public void init() {
        this.register("textarea", "textarea", "/library/editor/textarea/textarea.js", "/library/editor/textarea.launch.js", "");
        this.register("fckeditor", "FCKeditor", "/library/editor/FCKeditor/fckeditor.js", "/library/editor/fckeditor.launch.js", "");
        this.register("ckeditor", "CKEditor", "/library/webjars/ckeditor/4.5.7/full/ckeditor.js", "/library/editor/ckeditor.launch.js", "var CKEDITOR_BASEPATH='/library/webjars/ckeditor/4.5.7/full/';\n");
    }

    public void destroy() {
        this.editors.clear();
    }

    public void register(Editor editor) {
        this.editors.put(editor.getId().toLowerCase(), editor);
    }

    public void register(String id, String name, String editorUrl, String launchUrl, String preloadScript) {
        BaseEditor editor = new BaseEditor(id.toLowerCase(), name, editorUrl, launchUrl, preloadScript);
        this.register((Editor)editor);
    }

    public boolean unregister(Editor editor) {
        return this.unregister(editor.getId());
    }

    public boolean unregister(String id) {
        if (id != null) {
            id = id.toLowerCase();
        }
        if (this.editors.containsKey(id)) {
            this.editors.remove(id);
            return true;
        }
        return false;
    }

    public Editor getEditor(String id) {
        if (id == null) {
            return null;
        }
        return this.editors.get(id.toLowerCase());
    }

    public List<Editor> getEditors() {
        ArrayList<Editor> list = new ArrayList<Editor>();
        for (Editor e : this.editors.values()) {
            BaseEditor be = new BaseEditor(e.getId(), e.getName(), e.getEditorUrl(), e.getLaunchUrl());
            list.add((Editor)be);
        }
        return list;
    }
}

