/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.PortletInfoDD;
import org.apache.pluto.internal.InternalPortletContext;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.api.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletTool
implements Tool,
Comparable {
    private static Logger M_log = LoggerFactory.getLogger(PortletTool.class);
    protected Tool.AccessSecurity m_accessSecurity = Tool.AccessSecurity.PORTAL;
    protected Set m_categories = new HashSet();
    protected String m_description = null;
    protected Properties m_finalConfig = new Properties();
    protected String m_home = null;
    protected String m_id = null;
    protected Set m_keywords = new HashSet();
    protected Properties m_mutableConfig = new Properties();
    protected String m_title = null;
    protected Tool m_tool = null;

    public PortletTool(PortletDD pdd, InternalPortletContext portlet, ServletContext portalContext, Tool t) {
        String portletSupport = ServerConfigurationService.getString((String)"portlet.support");
        String portletName = pdd.getPortletName();
        String appName = portlet.getApplicationId();
        if (t != null) {
            this.m_id = t.getId();
            this.m_title = t.getTitle();
            this.m_description = t.getDescription();
            this.m_categories = t.getCategories();
            Properties rv = t.getFinalConfig();
            this.m_finalConfig.putAll((Map<?, ?>)rv);
            this.m_keywords = t.getKeywords();
            this.m_mutableConfig = t.getMutableConfig();
            M_log.info("Portlet registered from tool registration with Sakai toolId=" + this.m_id);
        } else {
            this.m_id = "portlet." + portlet.getApplicationId() + "." + portletName;
            PortletInfoDD pidd = pdd.getPortletInfo();
            if (pidd != null) {
                this.m_title = pidd.getShortTitle();
                this.m_description = pidd.getTitle();
            }
            if (this.m_title == null) {
                this.m_title = portletName;
            }
            if (this.m_description == null) {
                this.m_description = portletName;
            }
            if ("stealth".equals(portletSupport)) {
                M_log.info("Portlet stealth-registered with Sakai toolId=" + this.m_id);
            } else {
                this.m_categories.add("myworkspace");
                this.m_categories.add("project");
                this.m_categories.add("course");
                M_log.info("Portlet auto-registered with Sakai toolId=" + this.m_id);
            }
        }
        this.m_finalConfig.setProperty("portlet-context", appName);
        this.m_finalConfig.setProperty("portlet-name", portletName);
        this.m_finalConfig.setProperty("portlet-app-name", appName);
    }

    public int compareTo(Object obj) {
        Tool tool = (Tool)obj;
        return this.getId().compareTo(tool.getId());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PortletTool)) {
            return false;
        }
        return ((PortletTool)obj).getId().equals(this.getId());
    }

    public Tool.AccessSecurity getAccessSecurity() {
        return this.m_accessSecurity;
    }

    public Set getCategories() {
        return Collections.unmodifiableSet(this.m_categories);
    }

    public String getDescription() {
        return this.m_description;
    }

    public Properties getFinalConfig() {
        Properties rv = new Properties();
        rv.putAll((Map<?, ?>)this.m_finalConfig);
        return rv;
    }

    public String getHome() {
        return this.m_home;
    }

    public String getId() {
        return this.m_id;
    }

    public Set getKeywords() {
        return Collections.unmodifiableSet(this.m_keywords);
    }

    public Properties getMutableConfig() {
        Properties rv = new Properties();
        rv.putAll((Map<?, ?>)this.m_mutableConfig);
        return rv;
    }

    public Properties getRegisteredConfig() {
        Properties rv = new Properties();
        rv.putAll((Map<?, ?>)this.m_finalConfig);
        rv.putAll((Map<?, ?>)this.m_mutableConfig);
        return rv;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void setAccessSecurity(Tool.AccessSecurity access) {
        this.m_accessSecurity = access;
    }

    public void setCategories(Set categories) {
        this.m_categories = categories;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setHome(String home) {
        this.m_home = home;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setKeywords(Set keywords) {
        this.m_keywords = keywords;
    }

    public void setRegisteredConfig(Properties finalConfig, Properties mutableConfig) {
        this.m_finalConfig = finalConfig;
        if (this.m_finalConfig == null) {
            this.m_finalConfig = new Properties();
        }
        this.m_mutableConfig = mutableConfig;
        if (this.m_mutableConfig == null) {
            this.m_mutableConfig = new Properties();
        }
    }

    public void setTitle(String title) {
        this.m_title = title;
    }
}

