/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.service;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.alias.api.Alias;
import org.sakaiproject.alias.api.AliasService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;

public class AliasingSiteAdvisor
implements Observer {
    private static final String PORTAL_USE_PAGE_ALIASES = "portal.use.page.aliases";
    private static Log log = LogFactory.getLog(AliasingSiteAdvisor.class);
    private static String PAGE_ALIAS = "/pagealias/";
    private AliasService aliasService;
    private SiteService siteService;
    private ServerConfigurationService serverConfigurationService;
    private EntityManager entityManager;
    private EventTrackingService eventTrackingService;
    private int maxLength;

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void init() {
        if (this.serverConfigurationService.getBoolean(PORTAL_USE_PAGE_ALIASES, false)) {
            log.info((Object)"Page aliases will be generated.");
            this.getEventTrackingService().addLocalObserver((Observer)this);
        }
    }

    public void update(Observable o, Object arg) {
        Event event;
        if (arg instanceof Event && ("site.upd".equals((event = (Event)arg).getEvent()) || "site.add".equals(event.getEvent()))) {
            Reference ref = this.entityManager.newReference(event.getResource());
            Entity entity = ref.getEntity();
            if (entity instanceof Site) {
                this.update((Site)entity);
            } else {
                log.warn((Object)("Couldn't find site that has just been updated: " + entity));
            }
        }
    }

    public void update(Site site) {
        for (SitePage page : site.getPages()) {
            List aliases = this.aliasService.getAliases(page.getReference());
            String shortName = this.resolvePageName(site, page, page.getTitle());
            if (shortName == null || shortName.length() == 0) continue;
            String possibleAlias = PAGE_ALIAS + page.getSiteId() + "/" + shortName;
            boolean exists = false;
            if (!aliases.isEmpty()) {
                for (Alias alias : aliases) {
                    if (!possibleAlias.equals(alias.getId())) continue;
                    exists = true;
                }
            }
            if (exists) continue;
            try {
                this.aliasService.setAlias(possibleAlias, page.getReference());
            }
            catch (IdUsedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Alias already exists for: " + possibleAlias));
            }
            catch (IdInvalidException e) {
                log.warn((Object)("Failed to generate a sensible alias: " + possibleAlias));
            }
            catch (PermissionException e) {
                log.warn((Object)("Lack of permission to create alias: " + e.getMessage()));
                break;
            }
        }
    }

    private String resolvePageName(Site site, SitePage page, String title) {
        String alias = title.toLowerCase();
        alias = alias.replaceAll("[^a-z,0-9,_ ]", "");
        alias = alias.replaceAll(" ", "_");
        if ((alias = alias.replaceAll("_+", "_")).length() > this.maxLength) {
            alias = alias.substring(0, this.maxLength);
        }
        if (alias.endsWith("_")) {
            alias = alias.substring(0, alias.length() - 1);
        }
        return alias;
    }

    public AliasService getAliasService() {
        return this.aliasService;
    }

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }
}

