/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.portal.service.PortalStringUtil;

public class SessionRequestHolder {
    private Map<String, List> headers = new HashMap<String, List>();
    private String contextPath;
    private String method;
    private String queryString;
    private Map parameterMap;

    public SessionRequestHolder(HttpServletRequest request, String marker, String replacement) {
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            ArrayList v = new ArrayList();
            Enumeration e1 = request.getHeaders(s);
            while (e1.hasMoreElements()) {
                v.add(e1.nextElement());
            }
            this.headers.put(s, v);
        }
        Map m = request.getParameterMap();
        this.parameterMap = new HashMap();
        for (Map.Entry entry : m.entrySet()) {
            this.parameterMap.put(entry.getKey(), entry.getValue());
        }
        this.contextPath = PortalStringUtil.replaceFirst(request.getContextPath(), marker, replacement);
        this.method = request.getMethod();
        this.queryString = request.getQueryString();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public long getDateHeader(String arg0) {
        try {
            SimpleDateFormat f = new SimpleDateFormat();
            Date d = f.parse(this.getHeader(arg0));
            return d.getTime();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public String getHeader(String arg0) {
        try {
            List v = this.headers.get(arg0);
            return (String)v.get(0);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Enumeration getHeaderNames() {
        final Iterator<String> i = this.headers.keySet().iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return i.hasNext();
            }

            public Object nextElement() {
                return i.next();
            }
        };
    }

    public Enumeration getHeaders(String arg0) {
        try {
            final Iterator i = this.headers.get(arg0).iterator();
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return i.hasNext();
                }

                public Object nextElement() {
                    return i.next();
                }
            };
        }
        catch (Throwable t) {
            return null;
        }
    }

    public int getIntHeader(String arg0) {
        try {
            return Integer.parseInt(this.getHeader(arg0));
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getParameter(String arg0) {
        Object o = this.parameterMap.get(arg0);
        if (o instanceof String[]) {
            String[] s = (String[])o;
            return s[0];
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        final Iterator i = this.parameterMap.keySet().iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return i.hasNext();
            }

            public Object nextElement() {
                return i.next();
            }
        };
    }

    public String[] getParameterValues(String arg0) {
        Object o = this.parameterMap.get(arg0);
        if (o instanceof String[]) {
            String[] s = (String[])o;
            return s;
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o != null) {
            return new String[]{o.toString()};
        }
        return null;
    }
}

