/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.util;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.util.URLUtils;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.Web;

public class ToolUtils {
    public static final String PORTAL_INLINE_EXPERIMENTAL = "portal.inline.experimental";

    public static boolean isInlineRequest(HttpServletRequest req) {
        String option = URLUtils.getSafePathInfo(req);
        String[] parts = option.split("/");
        if (parts.length >= 5) {
            return parts[3].equals("tool");
        }
        return false;
    }

    public static String getPageUrl(HttpServletRequest req, Site site, SitePage page) {
        String control;
        String portalPrefix = "site";
        Session s = SessionManager.getCurrentSession();
        if (s != null && (control = (String)s.getAttribute("sakai-controlling-portal")) != null) {
            portalPrefix = control;
        }
        return ToolUtils.getPageUrl(req, site, page, portalPrefix, true, null, null);
    }

    public static String getPageUrl(HttpServletRequest req, Site site, SitePage page, String portalPrefix) {
        return ToolUtils.getPageUrl(req, site, page, portalPrefix, true, null, null);
    }

    public static String getPageUrl(HttpServletRequest req, Site site, SitePage page, String portalPrefix, boolean reset, String effectiveSiteId, String pageAlias) {
        if (effectiveSiteId == null) {
            effectiveSiteId = site.getId();
        }
        if (pageAlias == null) {
            pageAlias = page.getId();
        }
        String pageUrl = Web.returnUrl((HttpServletRequest)req, (String)("/" + portalPrefix + "/" + Web.escapeUrl((String)effectiveSiteId) + "/page/"));
        pageUrl = pageUrl + Web.escapeUrl((String)pageAlias);
        List pTools = page.getTools();
        Iterator toolz = pTools.iterator();
        int count = 0;
        ToolConfiguration pageTool = null;
        while (toolz.hasNext()) {
            ++count;
            pageTool = (ToolConfiguration)toolz.next();
        }
        if (count != 1) {
            return pageUrl;
        }
        if (ToolUtils.isPortletPlacement((Placement)pageTool)) {
            return pageUrl;
        }
        String trinity = ServerConfigurationService.getString((String)PORTAL_INLINE_EXPERIMENTAL, (String)"false");
        if (!"true".equals(trinity)) {
            return pageUrl;
        }
        pageUrl = Web.returnUrl((HttpServletRequest)req, (String)("/" + portalPrefix + "/" + Web.escapeUrl((String)effectiveSiteId)));
        pageUrl = reset ? pageUrl + "/tool-reset/" : pageUrl + "/tool/";
        pageUrl = pageUrl + Web.escapeUrl((String)pageTool.getId());
        return pageUrl;
    }

    public static String getToolPopupUrl(ToolConfiguration pageTool) {
        Properties pro = pageTool.getConfig();
        String source = null;
        if ("sakai.web.168".equals(pageTool.getToolId()) && "true".equals(pro.getProperty("popup"))) {
            source = pro.getProperty("source");
        } else if ("sakai.iframe".equals(pageTool.getToolId()) && "true".equals(pro.getProperty("popup"))) {
            source = pro.getProperty("source");
        } else if ("sakai.basiclti".equals(pageTool.getToolId()) && "on".equals(pro.getProperty("imsti.newpage"))) {
            source = "/access/basiclti/site/" + pageTool.getContext() + "/" + pageTool.getId();
        }
        return source;
    }

    public static SitePage getPageForTool(Site site, String toolId) {
        if (site == null || toolId == null) {
            return null;
        }
        List pages = site.getOrderedPages();
        for (SitePage p : pages) {
            List pTools = p.getTools();
            for (ToolConfiguration tc : pTools) {
                Tool to = tc.getTool();
                if (!toolId.equals(tc.getId())) continue;
                return p;
            }
        }
        return null;
    }

    public static String getPageUrlForTool(HttpServletRequest req, Site site, ToolConfiguration pageTool) {
        SitePage thePage = ToolUtils.getPageForTool(site, pageTool.getId());
        if (thePage == null) {
            return null;
        }
        return ToolUtils.getPageUrl(req, site, thePage);
    }

    public static boolean isPortletPlacement(Placement placement) {
        if (placement == null) {
            return false;
        }
        Tool t = placement.getTool();
        if (t == null) {
            return false;
        }
        Properties toolProps = t.getFinalConfig();
        if (toolProps == null) {
            return false;
        }
        String portletContext = toolProps.getProperty("portlet-context");
        return portletContext != null;
    }
}

