/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.util;

import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.site.api.Site;

public class CSSUtils {
    private static final String PORTAL_SKIN_NEOPREFIX_PROPERTY = "portal.neoprefix";
    private static final String PORTAL_SKIN_NEOPREFIX_DEFAULT = "neo-";

    public static String getCssToolBase() {
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        String cssToolBase = skinRepo + "/tool_base.css";
        return cssToolBase;
    }

    public static String adjustCssSkinFolder(String skinFolder) {
        String templates;
        String prefix;
        if (skinFolder == null && (skinFolder = ServerConfigurationService.getString((String)"skin.default")) == null) {
            skinFolder = "";
        }
        if ((prefix = ServerConfigurationService.getString((String)PORTAL_SKIN_NEOPREFIX_PROPERTY, (String)PORTAL_SKIN_NEOPREFIX_DEFAULT)) == null) {
            prefix = "";
        }
        if ("neoskin".equals(templates = ServerConfigurationService.getString((String)"portal.templates", (String)"neoskin")) && !skinFolder.startsWith(prefix)) {
            skinFolder = prefix + skinFolder;
        }
        return skinFolder;
    }

    public static String getCssToolSkin(String skinFolder) {
        skinFolder = CSSUtils.adjustCssSkinFolder(skinFolder);
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        String cssToolSkin = skinRepo + "/" + skinFolder + "/tool.css";
        return cssToolSkin;
    }

    public static String getCssToolSkin(Site site) {
        String skinFolder = site.getSkin();
        return CSSUtils.getCssToolSkin(skinFolder);
    }
}

