/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLUtils {
    private static Log M_log = LogFactory.getLog(URLUtils.class);
    public static String BAD_PATH_URL_CHARS = "\"'<>";

    public static String addParameter(String URL2, String name, String value) {
        int qpos = URL2.indexOf(63);
        int hpos = URL2.indexOf(35);
        char sep = qpos == -1 ? (char)'?' : '&';
        String seg = sep + URLUtils.encodeUrl(name) + '=' + URLUtils.encodeUrl(value);
        return hpos == -1 ? URL2 + seg : URL2.substring(0, hpos) + seg + URL2.substring(hpos);
    }

    public static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee);
        }
    }

    public static String getSafePathInfo(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        String newPathInfo = pathInfo;
        for (int i = 0; i < pathInfo.length() - 1; ++i) {
            if (BAD_PATH_URL_CHARS.indexOf(pathInfo.charAt(i)) < 0) continue;
            newPathInfo = pathInfo.substring(0, i);
            break;
        }
        if (!newPathInfo.equals(pathInfo)) {
            String ipAddress = req.getRemoteAddr();
            M_log.warn((Object)("Truncated pathInfo IP=" + ipAddress + " from " + pathInfo + " to " + newPathInfo));
        }
        return newPathInfo;
    }
}

