/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.sakaiproject.portal.util.ServletByteOutputStream;

public class ByteArrayServletResponse
extends HttpServletResponseWrapper {
    private PrintWriter writer = null;
    private String contentType = null;
    private boolean isCommitted = false;
    private long contentLength = -1L;
    private String redirect = null;
    private ServletByteOutputStream outStream = null;

    public ByteArrayServletResponse(HttpServletResponse response) {
        super(response);
        this.reset();
    }

    public boolean isCommitted() {
        boolean retval = this.isCommitted || super.isCommitted();
        return retval;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String newType) {
        super.setContentType(newType);
        this.contentType = newType;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void sendRedirect(String redirectUrl) throws IOException {
        this.isCommitted = true;
        this.redirect = redirectUrl;
    }

    public PrintWriter getWriter() {
        this.isCommitted = true;
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.isCommitted = true;
        return this.outStream;
    }

    public void setContentLength(int i) {
        this.contentLength = i;
    }

    public void setContentLengthLong(long i) {
        this.contentLength = i;
    }

    public void flushBuffer() {
    }

    public void reset() {
        this.outStream = new ServletByteOutputStream();
        this.writer = new PrintWriter((OutputStream)((Object)this.outStream));
    }

    public void forwardResponse() throws IOException {
        if (this.contentType != null) {
            super.setContentType(this.contentType);
        }
        if (this.contentLength > 0L) {
            super.setHeader("Content-Length", Long.toString(this.contentLength));
        }
        ServletOutputStream output = super.getOutputStream();
        if (this.redirect != null) {
            super.sendRedirect(this.redirect);
        }
        this.outStream.getContent().writeTo((OutputStream)output);
    }

    public String getInternalBuffer() {
        try {
            return this.outStream.getContent().toString("UTF-8");
        }
        catch (Exception e) {
            return this.outStream.getContent().toString();
        }
    }
}

