/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.util;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.Web;

public class ToolUtils {
    public static final String PORTAL_INLINE_EXPERIMENTAL = "portal.inline.experimental";
    public static final boolean PORTAL_INLINE_EXPERIMENTAL_DEFAULT = true;

    public static boolean isInlineRequest() {
        return ToolUtils.isInlineRequest();
    }

    public static boolean isInlineRequest(HttpServletRequest req) {
        String uri;
        if (req == null) {
            req = ToolUtils.getRequestFromThreadLocal();
        }
        if ((uri = req.getRequestURI()) != null) {
            String[] parts = uri.split("/");
            if (parts.length >= 6) {
                return parts[4].equals("tool");
            }
            return false;
        }
        return ServerConfigurationService.getBoolean((String)PORTAL_INLINE_EXPERIMENTAL, (boolean)true);
    }

    public static String getPageUrl(Site site, SitePage page) {
        return ToolUtils.getPageUrl(null, site, page);
    }

    public static String getPageUrl(HttpServletRequest req, Site site, SitePage page) {
        String control;
        if (req == null) {
            req = ToolUtils.getRequestFromThreadLocal();
        }
        String portalPrefix = "site";
        Session s = SessionManager.getCurrentSession();
        if (s != null && (control = (String)s.getAttribute("sakai-controlling-portal")) != null) {
            portalPrefix = control;
        }
        return ToolUtils.getPageUrl(req, site, page, portalPrefix, true, null, null);
    }

    public static String getPageUrl(HttpServletRequest req, Site site, SitePage page, String portalPrefix) {
        return ToolUtils.getPageUrl(req, site, page, portalPrefix, true, null, null);
    }

    public static String getPageUrl(HttpServletRequest req, Site site, SitePage page, String portalPrefix, boolean reset, String effectiveSiteId, String pageAlias) {
        if (page == null) {
            return "";
        }
        if (req == null) {
            req = ToolUtils.getRequestFromThreadLocal();
        }
        if (effectiveSiteId == null) {
            effectiveSiteId = site.getId();
        }
        if (pageAlias == null) {
            pageAlias = page.getId();
        }
        String pageUrl = Web.returnUrl((HttpServletRequest)req, (String)("/" + portalPrefix + "/" + Web.escapeUrl((String)effectiveSiteId) + "/page/"));
        pageUrl = pageUrl + Web.escapeUrl((String)pageAlias);
        List pTools = page.getTools();
        Iterator toolz = pTools.iterator();
        int count = 0;
        ToolConfiguration pageTool = null;
        while (toolz.hasNext()) {
            ++count;
            pageTool = (ToolConfiguration)toolz.next();
        }
        if (count != 1) {
            return pageUrl;
        }
        if (ToolUtils.isPortletPlacement((Placement)pageTool)) {
            return pageUrl;
        }
        boolean trinity = ServerConfigurationService.getBoolean((String)PORTAL_INLINE_EXPERIMENTAL, (boolean)true);
        if (!trinity) {
            return pageUrl;
        }
        pageUrl = Web.returnUrl((HttpServletRequest)req, (String)("/" + portalPrefix + "/" + Web.escapeUrl((String)effectiveSiteId)));
        pageUrl = reset ? pageUrl + "/tool-reset/" : pageUrl + "/tool/";
        return pageUrl + pageTool.getId();
    }

    public static String getToolPopupUrl(ToolConfiguration pageTool) {
        Properties pro = pageTool.getConfig();
        String source = null;
        if ("sakai.web.168".equals(pageTool.getToolId()) && "true".equals(pro.getProperty("popup"))) {
            source = pro.getProperty("source");
        } else if ("sakai.iframe".equals(pageTool.getToolId()) && "true".equals(pro.getProperty("popup"))) {
            source = pro.getProperty("source");
        } else if ("sakai.basiclti".equals(pageTool.getToolId()) && "on".equals(pro.getProperty("imsti.newpage"))) {
            source = "/access/basiclti/site/" + pageTool.getContext() + "/" + pageTool.getId();
        }
        return source;
    }

    public static SitePage getPageForTool(Site site, String toolId) {
        if (site == null || toolId == null) {
            return null;
        }
        List pages = site.getOrderedPages();
        for (SitePage p : pages) {
            List pTools = p.getTools();
            for (ToolConfiguration tc : pTools) {
                Tool to = tc.getTool();
                if (!toolId.equals(tc.getId())) continue;
                return p;
            }
        }
        return null;
    }

    public static String getPageUrlForTool(HttpServletRequest req, Site site, ToolConfiguration pageTool) {
        SitePage thePage;
        if (req == null) {
            req = ToolUtils.getRequestFromThreadLocal();
        }
        if ((thePage = ToolUtils.getPageForTool(site, pageTool.getId())) == null) {
            return null;
        }
        return ToolUtils.getPageUrl(req, site, thePage);
    }

    public static boolean isPortletPlacement(Placement placement) {
        if (placement == null) {
            return false;
        }
        Tool t = placement.getTool();
        if (t == null) {
            return false;
        }
        Properties toolProps = t.getFinalConfig();
        if (toolProps == null) {
            return false;
        }
        String portletContext = toolProps.getProperty("portlet-context");
        return portletContext != null;
    }

    public static String getToolBorderlessBaseUrl() {
        return ServerConfigurationService.getToolUrl();
    }

    public static String getToolBaseUrl() {
        return ToolUtils.getToolBaseUrl(null);
    }

    public static String getToolBaseUrl(HttpServletRequest req) {
        if (req == null) {
            req = ToolUtils.getRequestFromThreadLocal();
        }
        String retval = ServerConfigurationService.getToolUrl();
        if (ToolUtils.isInlineRequest(req)) {
            String currentSiteId = ToolManager.getCurrentPlacement().getContext();
            retval = retval.replaceAll("tool$", "site/" + currentSiteId + "/tool");
        }
        return retval;
    }

    public static HttpServletRequest getRequestFromThreadLocal() {
        try {
            HttpServletRequest req = (HttpServletRequest)ThreadLocalManager.get((String)"org.sakaiproject.util.RequestFilter.http_request");
            return req;
        }
        catch (Exception e) {
            throw new RuntimeException("This utility must be called after RequestFilter has run", e);
        }
    }

    public static String getRequestParameter(String key) {
        return ToolUtils.getRequestFromThreadLocal().getParameter(key);
    }
}

