/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.util;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.coursemanagement.api.AcademicSession;
import org.sakaiproject.coursemanagement.api.CourseManagementService;

public class PortalUtils {
    private static CourseManagementService courseManagementService = (CourseManagementService)ComponentManager.get(CourseManagementService.class);

    public static String getLibraryPath() {
        return PortalUtils.getCDNPath() + "/library/";
    }

    public static String getWebjarsPath() {
        return PortalUtils.getLibraryPath() + "webjars/";
    }

    public static String getScriptPath() {
        return PortalUtils.getLibraryPath() + "js/";
    }

    public static String getCDNPath() {
        return ServerConfigurationService.getString((String)"portal.cdn.path", (String)"");
    }

    public static String getCDNQuery() {
        long expire = ServerConfigurationService.getInt((String)"portal.cdn.expire", (int)0);
        String version = ServerConfigurationService.getString((String)"portal.cdn.version", (String)ServerConfigurationService.getString((String)"version.service", (String)"0"));
        StringBuilder cdnQuery = new StringBuilder();
        cdnQuery.append("?version=").append(version);
        if (expire > 0L) {
            Instant instant = Instant.now();
            expire = instant.getEpochSecond() / expire;
            cdnQuery.append("&expire=").append(expire);
        }
        return cdnQuery.toString();
    }

    public static String includeLatestJQuery(String where) {
        String retval = "<script type=\"text/javascript\">\nvar needJQuery = true;\nif ( window.jQuery ) {\n       tver = jQuery.fn.jquery;\n       if ( tver.indexOf('1.12.') == 0 ) {\n               window.console && console.log('" + where + " PortalUtils.includeLatestJquery() detected jQuery '+tver);\n               needJQuery = false;\n       } else {\n               var overrideJQuery = true;\n               window.console && console.log('" + where + " PortalUtils.includeLatestJquery() found jQuery '+tver);\n       }\n}\nif ( needJQuery ) {\n   document.write('\\x3Cscript type=\"text/javascript\" src=\"" + PortalUtils.getLatestJQueryPath() + PortalUtils.getCDNQuery() + "\">'+'\\x3C/script>')\n   document.write('\\x3Cscript type=\"text/javascript\" src=\"" + PortalUtils.getWebjarsPath() + "jquery-migrate/1.4.1/jquery-migrate.min.js" + PortalUtils.getCDNQuery() + "\">'+'\\x3C/script>')\n   document.write('\\x3Cscript type=\"text/javascript\" src=\"" + PortalUtils.getWebjarsPath() + "bootstrap/3.3.7/js/bootstrap.min.js" + PortalUtils.getCDNQuery() + "\">'+'\\x3C/script>')\n   document.write('\\x3Cscript type=\"text/javascript\" src=\"" + PortalUtils.getWebjarsPath() + "jquery-ui/1.12.1/jquery-ui.min.js" + PortalUtils.getCDNQuery() + "\">'+'\\x3C/script>')\n   document.write('\\x3Clink rel=\"stylesheet\" href=\"" + PortalUtils.getWebjarsPath() + "jquery-ui/1.12.1/jquery-ui.min.css" + PortalUtils.getCDNQuery() + "\"/>')\n} else { \n   window.console && console.log('jQuery already loaded '+jQuery.fn.jquery+' in '+'" + where + "');\n   if (typeof jQuery.migrateWarnings == 'undefined') {\n           document.write('\\x3Cscript type=\"text/javascript\" src=\"" + PortalUtils.getWebjarsPath() + "jquery/jquery-migrate-1.4.1.min.js" + PortalUtils.getCDNQuery() + "\">'+'\\x3C/script>')\n           window.console && console.log('Adding jQuery migrate');\n   }\n   if ( typeof jQuery.fn.popover == 'undefined') {\n           document.write('\\x3Cscript type=\"text/javascript\" src=\"" + PortalUtils.getWebjarsPath() + "bootstrap/3.3.7/js/bootstrap.min.js" + PortalUtils.getCDNQuery() + "\">'+'\\x3C/script>')\n           window.console && console.log('Adding Bootstrap');\n   }\n   if (typeof jQuery.ui == 'undefined') {\n           document.write('\\x3Cscript type=\"text/javascript\" src=\"" + PortalUtils.getWebjarsPath() + "jquery-ui/1.12.1/jquery-ui.min.js" + PortalUtils.getCDNQuery() + "\">'+'\\x3C/script>')\n           document.write('\\x3Clink rel=\"stylesheet\" href=\"" + PortalUtils.getWebjarsPath() + "jquery-ui/1.12.1/jquery-ui.min.css" + PortalUtils.getCDNQuery() + "\"/>')\n           window.console && console.log('Adding jQuery UI');\n   }\n}\n</script>\n<script type=\"text/javascript\">\nif ( needJQuery ) {\n       window.console && console.log('" + where + " PortalUtils.includeLatestJquery() loaded jQuery+migrate+Bootstrap+UI '+$.fn.jquery);\n}\n$PBJQ = jQuery;\n</script>\n";
        return retval;
    }

    public static String getLatestJQueryPath() {
        return PortalUtils.getWebjarsPath() + "jquery/1.12.4/jquery.min.js";
    }

    public static List<String> getPortalTermOrder(Set<String> tabsMoreTerms) {
        String[] termOrder = ServerConfigurationService.getStrings((String)"portal.term.order");
        ArrayList<String> tabsMoreSortedTermList = new ArrayList<String>();
        if (termOrder != null && tabsMoreTerms != null) {
            for (int i = 0; i < termOrder.length; ++i) {
                if (!tabsMoreTerms.contains(termOrder[i])) continue;
                tabsMoreSortedTermList.add(termOrder[i]);
            }
        }
        if (courseManagementService != null) {
            List sessions = courseManagementService.getAcademicSessions();
            for (AcademicSession s : sessions) {
                String title = s.getTitle();
                if (tabsMoreTerms == null) {
                    tabsMoreSortedTermList.add(title);
                    continue;
                }
                if (!tabsMoreTerms.contains(title) || tabsMoreSortedTermList.contains(title)) continue;
                tabsMoreSortedTermList.add(title);
            }
        }
        if (tabsMoreTerms != null) {
            for (String term : tabsMoreTerms) {
                if (tabsMoreSortedTermList.contains(term)) continue;
                tabsMoreSortedTermList.add(term);
            }
        }
        return tabsMoreSortedTermList;
    }
}

