/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLUtils {
    private static final Logger log = LoggerFactory.getLogger(URLUtils.class);
    public static String BAD_PATH_URL_CHARS = "\"'<>";

    public static String addParameter(String URL, String name, String value) {
        int qpos = URL.indexOf(63);
        int hpos = URL.indexOf(35);
        char sep = qpos == -1 ? (char)'?' : '&';
        String seg = sep + URLUtils.encodeUrl(name) + '=' + URLUtils.encodeUrl(value);
        return hpos == -1 ? URL + seg : URL.substring(0, hpos) + seg + URL.substring(hpos);
    }

    public static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee);
        }
    }

    public static String getSafePathInfo(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        String newPathInfo = pathInfo;
        for (int i = 0; i < pathInfo.length() - 1; ++i) {
            if (BAD_PATH_URL_CHARS.indexOf(pathInfo.charAt(i)) < 0) continue;
            newPathInfo = pathInfo.substring(0, i);
            break;
        }
        if (!newPathInfo.equals(pathInfo)) {
            String ipAddress = req.getRemoteAddr();
            log.warn("Truncated pathInfo IP=" + ipAddress + " from " + pathInfo + " to " + newPathInfo);
        }
        return newPathInfo;
    }
}

