/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.util;

import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.util.PortalUtils;
import org.sakaiproject.site.api.Site;

public class CSSUtils {
    public static String getCssToolBase() {
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        String cssToolBase = skinRepo + "/tool_base.css";
        return cssToolBase;
    }

    public static String getCssToolBaseCDN() {
        String cssToolBaseCDN = PortalUtils.getCDNPath() + CSSUtils.getCssToolBase() + PortalUtils.getCDNQuery();
        return cssToolBaseCDN;
    }

    public static String adjustCssSkinFolder(String skinFolder) {
        if (skinFolder == null && (skinFolder = ServerConfigurationService.getString((String)"skin.default")) == null) {
            skinFolder = "";
        }
        return skinFolder;
    }

    public static String getCssToolSkin(String skinFolder) {
        skinFolder = CSSUtils.adjustCssSkinFolder(skinFolder);
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        String cssToolSkin = skinRepo + "/" + skinFolder + "/tool.css";
        return cssToolSkin;
    }

    public static String getCssPrintSkin(String skinFolder) {
        skinFolder = CSSUtils.adjustCssSkinFolder(skinFolder);
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        String cssPrintSkin = skinRepo + "/" + skinFolder + "/print.css";
        return cssPrintSkin;
    }

    public static String getCssPropertiesSkin(String skinFolder) {
        skinFolder = CSSUtils.adjustCssSkinFolder(skinFolder);
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        String cssPropertiesSkin = skinRepo + "/" + skinFolder + "/properties.css";
        return cssPropertiesSkin;
    }

    public static String getCssPortalSkin(String skinFolder) {
        skinFolder = CSSUtils.adjustCssSkinFolder(skinFolder);
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        String cssPortalSkin = skinRepo + "/" + skinFolder + "/portal.css";
        return cssPortalSkin;
    }

    public static String getCssPortalSkinCDN(String skinFolder) {
        String cssPortalSkin = PortalUtils.getCDNPath() + CSSUtils.getCssPortalSkin(skinFolder) + PortalUtils.getCDNQuery();
        return cssPortalSkin;
    }

    public static String getCssToolSkinCDN(String skinFolder) {
        String cssToolSkin = CSSUtils.getCssToolSkin(skinFolder);
        if (cssToolSkin.startsWith("/")) {
            cssToolSkin = PortalUtils.getCDNPath() + cssToolSkin + PortalUtils.getCDNQuery();
        }
        return cssToolSkin;
    }

    public static String getCssPrintSkinCDN(String skinFolder) {
        String cssPrintSkin = CSSUtils.getCssPrintSkin(skinFolder);
        if (cssPrintSkin.startsWith("/")) {
            cssPrintSkin = PortalUtils.getCDNPath() + cssPrintSkin + PortalUtils.getCDNQuery();
        }
        return cssPrintSkin;
    }

    public static String getCssPropertiesSkinCDN(String skinFolder) {
        String cssPropertiesSkin = CSSUtils.getCssPropertiesSkin(skinFolder);
        if (cssPropertiesSkin.startsWith("/")) {
            cssPropertiesSkin = PortalUtils.getCDNPath() + cssPropertiesSkin + PortalUtils.getCDNQuery();
        }
        return cssPropertiesSkin;
    }

    public static String getSkinFromSite(Site site) {
        String skinFolder = null;
        if (site != null) {
            skinFolder = site.getSkin();
        }
        return skinFolder;
    }

    public static String getPortalSkinLink(String skin) {
        String headCssPortalSkin = "<link href=\"" + CSSUtils.getCssPortalSkinCDN(skin) + "\" type=\"text/css\" rel=\"stylesheet\" media=\"screen, tty, tv, handheld, projection\" />\n";
        return headCssPortalSkin;
    }

    public static String getCssToolBaseLink(String skin, boolean isInlineRequest) {
        String headCssToolBase = "<link href=\"" + CSSUtils.getCssToolBaseCDN() + "\" type=\"text/css\" rel=\"stylesheet\" media=\"screen, tty, tv, handheld, projection\" />\n";
        if (!isInlineRequest) {
            String headCssPortalSkin = "<link href=\"" + CSSUtils.getCssPortalSkinCDN(skin) + "\" type=\"text/css\" rel=\"stylesheet\" media=\"screen, tty, tv, handheld, projection\" />\n";
            headCssToolBase = headCssPortalSkin + headCssToolBase;
        }
        return headCssToolBase;
    }

    public static String getCssToolSkinLink(String skin, boolean isInlineRequest) {
        if (isInlineRequest) {
            return "";
        }
        String headCssToolSkin = "<link href=\"" + CSSUtils.getCssToolSkinCDN(skin) + "\" type=\"text/css\" rel=\"stylesheet\" media=\"screen, tty, tv, handheld, projection\" />\n";
        String headCssPrintSkin = "<link href=\"" + CSSUtils.getCssPrintSkinCDN(skin) + "\" type=\"text/css\" rel=\"stylesheet\" media=\"print\" />\n";
        String headCssPropertiesSkin = "<link href=\"" + CSSUtils.getCssPropertiesSkinCDN(skin) + "\" type=\"text/css\" rel=\"stylesheet\" media=\"screen, tty, tv, handheld, projection\" />\n";
        return headCssToolSkin + headCssPrintSkin + headCssPropertiesSkin;
    }

    public static String getCssHead(String skin, boolean isInlineRequest) {
        String headCss = CSSUtils.getCssToolBaseLink(skin, isInlineRequest);
        if (!isInlineRequest) {
            headCss = headCss + CSSUtils.getCssToolSkinLink(skin, isInlineRequest);
        }
        return headCss;
    }
}

