/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.portlet;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.api.PortletApplicationDescriptor;
import org.sakaiproject.portal.api.PortletDescriptor;
import org.sakaiproject.portal.portlet.PortletRenderContext;
import org.sakaiproject.portal.portlet.PortletRenderEngine;
import org.sakaiproject.portal.render.cover.ToolRenderService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;

public class PlacementPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog(PlacementPortlet.class);
    private PortletRenderEngine rengine;
    private PortalService portalService;

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String portletContext = request.getParameter("context");
        String portletName = request.getParameter("portlet");
        String placementId = (String)request.getAttribute(PortalService.PLACEMENT_ATTRIBUTE);
        String setportlet = request.getParameter("setportlet");
        log.debug((Object)("Got, PortletContext:" + portletContext + "; PortletName:" + portletName + " Placement Id " + placementId));
        if ("true".equals(setportlet)) {
            try {
                ToolConfiguration config = SiteService.findTool((String)placementId);
                Site siteEdit = SiteService.getSite((String)config.getSiteId());
                config = siteEdit.getTool(placementId);
                Properties p = config.getPlacementConfig();
                log.debug((Object)("Changing portlet-context from " + p.getProperty("portlet-context") + " to " + portletContext));
                log.debug((Object)("Changing portlet-name from " + p.getProperty("portlet-name") + " to " + portletName));
                p.setProperty("portlet-context", portletContext);
                p.setProperty("portlet-name", portletName);
                config.save();
                SiteService.save((Site)siteEdit);
                ToolRenderService.getInstance().reset(config);
                log.debug((Object)"Save Complete ================================");
            }
            catch (IdUnusedException e) {
                throw new PortletException("Tool has no site to save configuration with ", (Throwable)e);
            }
            catch (PermissionException e) {
                throw new PortletSecurityException("Permission denied ", (Throwable)e);
            }
        }
    }

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        String renderEngineClass = config.getInitParameter("renderEngineImpl");
        if (renderEngineClass == null || renderEngineClass.trim().length() == 0) {
            renderEngineClass = PortletRenderEngine.DEFAULT_RENDER_ENGINE;
        }
        try {
            Class<?> c = Class.forName(renderEngineClass);
            this.rengine = (PortletRenderEngine)c.newInstance();
            this.rengine.init();
        }
        catch (Exception e) {
            throw new PortletException("Failed to start velocity ", (Throwable)e);
        }
        this.portalService = org.sakaiproject.portal.api.cover.PortalService.getInstance();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRenderContext rcontext = this.rengine.newRenderContext(request);
        rcontext.put("test", (Object)"testing");
        rcontext.put("portletapplications", (Object)this.getPortletApplications(response));
        try {
            response.setContentType("text/html");
            this.rengine.render("view", rcontext, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new PortletException("Failed to render view template ", (Throwable)e);
        }
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRenderContext rcontext = this.rengine.newRenderContext(request);
        rcontext.put("test", (Object)"testing");
        rcontext.put("portletapplications", (Object)this.getPortletApplications(response));
        try {
            response.setContentType("text/html");
            this.rengine.render("edit", rcontext, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new PortletException("Failed to render edit template ", (Throwable)e);
        }
    }

    private List<Map> getPortletApplications(RenderResponse response) throws PortletModeException {
        ArrayList<Map> portletApps = new ArrayList<Map>();
        Iterator i = this.portalService.getRegisteredApplications();
        while (i.hasNext()) {
            PortletApplicationDescriptor portletApplication = (PortletApplicationDescriptor)i.next();
            HashMap<String, Object> portletApp = new HashMap<String, Object>();
            portletApp.put("name", portletApplication.getApplicationContext());
            ArrayList portlets = new ArrayList();
            Iterator pai = portletApplication.getPortlets();
            while (pai.hasNext()) {
                PortletDescriptor pd = (PortletDescriptor)pai.next();
                HashMap<String, String> portletDesc = new HashMap<String, String>();
                portletDesc.put("name", pd.getPortletName());
                PortletURL purl = response.createActionURL();
                purl.setParameter("context", portletApplication.getApplicationId());
                purl.setParameter("portlet", pd.getPortletId());
                purl.setParameter("setportlet", "true");
                purl.setPortletMode(PortletMode.VIEW);
                portletDesc.put("url", purl.toString());
                portlets.add(portletDesc);
            }
            portletApp.put("portlets", portlets);
            portletApps.add(portletApp);
        }
        return portletApps;
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRenderContext rcontext = this.rengine.newRenderContext(request);
        rcontext.put("test", (Object)"testing");
        try {
            response.setContentType("text/html");
            this.rengine.render("help", rcontext, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new PortletException("Failed to render help template ", (Throwable)e);
        }
    }
}

