/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.tool;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.portal.util.ErrorReporter;
import org.sakaiproject.portal.util.ToolURLManagerImpl;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.ActiveToolManager;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.StringUtil;
import org.sakaiproject.util.Web;

public class ToolPortal
extends HttpServlet {
    private static Log M_log = LogFactory.getLog(ToolPortal.class);

    public String getServletInfo() {
        return "Sakai Tool Portal";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        M_log.info((Object)"init()");
    }

    public void destroy() {
        M_log.info((Object)"destroy()");
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            Session session = SessionManager.getCurrentSession();
            String path = req.getPathInfo();
            if (path == null || path.length() <= 1) {
                res.sendError(404);
                return;
            }
            String[] parts = StringUtil.splitFirst((String)path.substring(1), (String)"/");
            String placementId = parts[0];
            String toolPath = null;
            if (parts.length == 2) {
                toolPath = "/" + parts[1];
            }
            boolean success = this.doTool(req, res, session, placementId, req.getContextPath() + req.getServletPath() + "/" + placementId, toolPath);
        }
        catch (Exception t) {
            this.doError(req, res, (Throwable)t);
        }
    }

    protected boolean doTool(HttpServletRequest req, HttpServletResponse res, Session session, String placementId, String toolContextPath, String toolPathInfo) throws ToolException, IOException {
        ToolSession toolSession;
        ToolConfiguration siteTool = SiteService.findTool((String)placementId);
        if (siteTool == null) {
            return false;
        }
        ActiveTool tool = ActiveToolManager.getActiveTool((String)siteTool.getToolId());
        if (tool == null) {
            return false;
        }
        if (tool.getAccessSecurity() == Tool.AccessSecurity.PORTAL) {
            Site site = null;
            try {
                site = SiteService.getSiteVisit((String)siteTool.getSiteId());
            }
            catch (IdUnusedException e) {
                return false;
            }
            catch (PermissionException e) {
                return false;
            }
        }
        if (toolPathInfo == null && tool.getHome() != null) {
            toolSession = SessionManager.getCurrentSession().getToolSession(placementId);
            String redirectPath = (String)toolSession.getAttribute("sakai:tool:current_destination");
            if (redirectPath == null) {
                redirectPath = tool.getHome();
            }
            String redirectUrl = ServerConfigurationService.getServerUrl() + toolContextPath + redirectPath;
            res.sendRedirect(res.encodeRedirectURL(redirectUrl));
            return true;
        }
        if (tool.getHome() != null) {
            toolSession = SessionManager.getCurrentSession().getToolSession(placementId);
            toolSession.setAttribute("sakai:tool:current_destination", (Object)toolPathInfo);
        }
        this.setupForward(req, res, (Placement)siteTool, siteTool.getSkin());
        req.setAttribute("tool.url.manager", (Object)new ToolURLManagerImpl(res));
        tool.forward(req, res, (Placement)siteTool, toolContextPath, toolPathInfo);
        return true;
    }

    protected void doError(HttpServletRequest req, HttpServletResponse res, Throwable t) {
        ErrorReporter err = new ErrorReporter();
        err.report(req, res, t);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void setupForward(HttpServletRequest req, HttpServletResponse res, Placement p, String skin) throws ToolException {
        if (skin == null || skin.length() == 0) {
            skin = ServerConfigurationService.getString((String)"skin.default");
        }
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        String headCssToolBase = "<link href=\"" + skinRepo + "/tool_base.css\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n";
        String headCssToolSkin = "<link href=\"" + skinRepo + "/" + skin + "/tool.css\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n";
        String headCss = headCssToolBase + headCssToolSkin;
        String headJs = "<script type=\"text/javascript\" language=\"JavaScript\" src=\"/library/js/headscripts.js\"></script>\n";
        String head = headCss + headJs;
        StringBuilder bodyonload = new StringBuilder();
        if (p != null) {
            String element = Web.escapeJavascript((String)("Main" + p.getId()));
            bodyonload.append("setMainFrameHeight('" + element + "');");
        }
        bodyonload.append("setFocus(focus_path);");
        req.setAttribute("sakai.html.head", (Object)head);
        req.setAttribute("sakai.html.head.css", (Object)headCss);
        req.setAttribute("sakai.html.head.css.base", (Object)headCssToolBase);
        req.setAttribute("sakai.html.head.css.skin", (Object)headCssToolSkin);
        req.setAttribute("sakai.html.head.js", (Object)headJs);
        req.setAttribute("sakai.html.body.onload", (Object)bodyonload.toString());
    }
}

