/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.xsltcharon.impl;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.api.PortalRenderContext;
import org.sakaiproject.portal.api.PortalRenderEngine;
import org.sakaiproject.portal.render.api.RenderResult;
import org.sakaiproject.portal.render.api.ToolRenderException;
import org.sakaiproject.portal.xsltcharon.impl.XsltRenderEngine;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Web;
import org.sakaiproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;

public class XsltRenderContext
implements PortalRenderContext {
    private static final Log log = LogFactory.getLog(XsltRenderEngine.class);
    private static final String ALT_TEMPLATE = "xsltUseTemplate";
    private static ResourceLoader rb = new ResourceLoader("org/sakaiproject/portal/xsltcharon/messages");
    private PortalRenderEngine renderEngine;
    private PortalRenderContext baseContext;
    private Map context = new HashMap();
    private org.sakaiproject.user.api.UserDirectoryService userDirectoryService;
    private HttpServletRequest request;

    public XsltRenderContext(PortalRenderEngine renderEngine, PortalRenderContext baseContext, HttpServletRequest request) {
        this.renderEngine = renderEngine;
        this.baseContext = baseContext;
        this.request = request;
        this.userDirectoryService = UserDirectoryService.getInstance();
    }

    public void put(String string, Object value) {
        this.context.put(string, value);
        this.baseContext.put(string, value);
    }

    public Object get(String key) {
        return this.context.get(key);
    }

    public String dump() {
        return this.baseContext.dump();
    }

    public boolean uses(String includeOption) {
        return this.baseContext.uses(includeOption);
    }

    public PortalRenderEngine getRenderEngine() {
        return this.renderEngine;
    }

    public PortalRenderContext getBaseContext() {
        return this.baseContext;
    }

    public void setBaseContext(PortalRenderContext baseContext) {
        this.baseContext = baseContext;
    }

    public Document produceDocument() {
        Document doc = Xml.createDocument();
        Element root = doc.createElement("portal");
        doc.appendChild(root);
        User currentUser = this.userDirectoryService.getCurrentUser();
        boolean loggedIn = false;
        if (currentUser != null && currentUser.getId().length() > 0) {
            root.appendChild(this.createUserXml(doc, currentUser));
            loggedIn = true;
        }
        Map sitePages = (Map)this.context.get("sitePages");
        root.appendChild(this.createLoginXml(doc, this.request));
        this.appendTextElementNodeFromProp(doc, "pageTitle", "pageTitle", root);
        root.appendChild(this.createSkin(doc));
        root.appendChild(this.createConfixXml(doc, loggedIn, sitePages));
        if (this.context.get("subSites") != null) {
            if (sitePages.get("subsiteClass") != null) {
                Element subSiteClass = doc.createElement("subSiteClass");
                subSiteClass.setAttribute("subSiteClass", sitePages.get("subsiteClass").toString());
                root.appendChild(subSiteClass);
            }
            try {
                List subsites = (List)this.context.get("subSites");
                for (HashMap hashMap : subsites) {
                    Element subSiteElement = doc.createElement("subSite");
                    String siteTitle = hashMap.get("siteTitle").toString();
                    String siteUrl = hashMap.get("siteUrl").toString();
                    subSiteElement.setAttribute("siteTitle", siteTitle);
                    subSiteElement.setAttribute("siteUrl", siteUrl);
                    root.appendChild(subSiteElement);
                }
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
        if (loggedIn) {
            root.appendChild(this.createSites(doc));
        }
        try {
            root.appendChild(this.createPageCategories(doc, (List)sitePages.get("pageNavTools")));
        }
        catch (ToolRenderException e) {
            log.error((Object)"", (Throwable)e);
        }
        root.appendChild(this.createExternalizedXml(doc));
        return doc;
    }

    protected Element createExternalizedXml(Document doc) {
        Element externalized = doc.createElement("externalized");
        for (Map.Entry entry : rb.entrySet()) {
            externalized.appendChild(this.createExternalizedEntryXml(doc, entry.getKey(), entry.getValue()));
        }
        ResourceLoader rbsitenav = (ResourceLoader)this.context.get("rloader");
        for (Map.Entry entry : rbsitenav.entrySet()) {
            externalized.appendChild(this.createExternalizedEntryXml(doc, entry.getKey(), entry.getValue()));
        }
        return externalized;
    }

    protected Element createExternalizedEntryXml(Document doc, Object key, Object value) {
        Element entry = doc.createElement("entry");
        entry.setAttribute("key", (String)key);
        this.appendTextElementNode(doc, "value", (String)value, entry);
        return entry;
    }

    protected Element createSites(Document doc) {
        Element sites = doc.createElement("sites");
        Map tabSites = (Map)this.context.get("tabsSites");
        Element tabsSites = this.createSitesList(doc, tabSites, "tabsSites", "tabsSites");
        this.appendTextElementNode(doc, "tutorial", tabSites.get("tutorial").toString(), tabsSites);
        this.appendTextElementNode(doc, "tabsMoreSitesShow", tabSites.get("tabsMoreSitesShow").toString(), tabsSites);
        sites.appendChild(tabsSites);
        sites.appendChild(this.createSitesList(doc, tabSites, "tabsMoreSites", "tabsMoreSites"));
        if (tabSites.get("tabsMoreSortedTermList") != null) {
            sites.appendChild(this.createTermSites(doc, tabSites));
        }
        return sites;
    }

    protected Element createTermSites(Document doc, Map tabSites) {
        Element siteTypes = doc.createElement("siteTypes");
        List terms = (List)tabSites.get("tabsMoreSortedTermList");
        Map termsMap = (Map)tabSites.get("tabsMoreTerms");
        int index = 0;
        for (String title : terms) {
            Element siteType = doc.createElement("siteType");
            siteType.setAttribute("order", "" + index);
            this.appendTextElementNode(doc, "title", title, siteType);
            siteType.appendChild(this.createSitesList(doc, termsMap, title, "sites"));
            siteTypes.appendChild(siteType);
            ++index;
        }
        return siteTypes;
    }

    protected Element createSitesList(Document doc, Map currentContext, String prop, String elementName) {
        Element list = doc.createElement(elementName);
        List sites = (List)currentContext.get(prop);
        if (sites == null) {
            return list;
        }
        int index = 0;
        for (Map site : sites) {
            list.appendChild(this.createSite(doc, site, index));
            ++index;
        }
        return list;
    }

    protected Element createSite(Document doc, Map siteMap, int index) {
        Element site = doc.createElement("site");
        this.appendTextElementNode(doc, "url", (String)siteMap.get("siteUrl"), site);
        this.appendTextElementNode(doc, "title", (String)siteMap.get("siteTitle"), site);
        this.appendTextElementNode(doc, "description", (String)siteMap.get("siteDescription"), site);
        this.appendTextElementNode(doc, "shortDescription", (String)siteMap.get("shortDescription"), site);
        this.appendTextElementNode(doc, "parent", (String)siteMap.get("parentSite"), site);
        this.appendTextElementNode(doc, "type", (String)siteMap.get("siteType"), site);
        this.appendTextElementNode(doc, "siteId", (String)siteMap.get("siteId"), site);
        site.setAttribute("selected", siteMap.get("isCurrentSite").toString());
        if (((Boolean)siteMap.get("isCurrentSite")).booleanValue() && this.context.get("viewAsStudentLink") != null && ((Boolean)this.context.get("viewAsStudentLink")).booleanValue()) {
            Element viewAsStudentLink = doc.createElement("viewAsStudentLink");
            site.appendChild(viewAsStudentLink);
            if (this.context.get("roleSwitchState") != null) {
                this.appendTextElementNode(doc, "roleSwitchState", this.context.get("roleSwitchState").toString(), viewAsStudentLink);
            }
            this.appendTextElementNode(doc, "roleUrlValue", (String)this.context.get("roleUrlValue"), viewAsStudentLink);
            if (this.context.get("roleswapdropdown") != null) {
                this.appendTextElementNode(doc, "roleswapdropdown", this.context.get("roleswapdropdown").toString(), viewAsStudentLink);
            }
            this.appendTextElementNode(doc, "switchRoleUrl", (String)this.context.get("switchRoleUrl"), viewAsStudentLink);
            this.appendTextElementNode(doc, "panelString", (String)this.context.get("panelString"), viewAsStudentLink);
            if (this.context.get("siteRoles") != null) {
                List roles = (List)this.context.get("siteRoles");
                this.appendTextElementNodes(doc, roles.toArray(new String[roles.size()]), viewAsStudentLink, "siteRoles", "role");
            }
        }
        site.setAttribute("myWorkspace", siteMap.get("isMyWorkspace").toString());
        site.setAttribute("depth", siteMap.get("depth").toString());
        site.setAttribute("order", "" + index);
        if (siteMap.get("isChild") != null) {
            site.setAttribute("isChild", "true");
            site.setAttribute("child", siteMap.get("isChild").toString());
            List pwd = (List)siteMap.get("pwd");
            if (pwd != null) {
                for (Map pwdMap : pwd) {
                    Element pwdElement = doc.createElement("pwd");
                    for (Map.Entry entry : pwdMap.entrySet()) {
                        pwdElement.setAttribute(entry.getKey().toString(), entry.getValue().toString());
                    }
                    site.appendChild(pwdElement);
                }
            }
        } else if (siteMap.get("parentSite") != null) {
            site.setAttribute("child", Boolean.TRUE.toString());
        } else {
            site.setAttribute("child", Boolean.FALSE.toString());
        }
        Map sitePages = (Map)siteMap.get("sitePages");
        if (sitePages != null) {
            site.appendChild(this.createSitePages(doc, (List)sitePages.get("pageNavTools")));
        }
        return site;
    }

    protected Element createSitePages(Document doc, List<Map<String, ?>> navPages) {
        Element pages = doc.createElement("pages");
        if (navPages != null && navPages.size() > 0) {
            pages.setAttribute("count", Integer.toString(navPages.size()));
            for (Map<String, ?> navPage : navPages) {
                Element page = doc.createElement("page");
                page.setAttribute("hidden", navPage.get("hidden").toString());
                page.setAttribute("current", navPage.get("current").toString());
                page.setAttribute("isPage", navPage.get("isPage").toString());
                this.appendTextElementNode(doc, "title", navPage.get("pageTitle").toString(), page);
                this.appendTextElementNode(doc, "description", navPage.get("description").toString(), page);
                this.appendTextElementNode(doc, "url", navPage.get("pageRefUrl").toString(), page);
                this.appendTextElementNode(doc, "menuClass", navPage.get("menuClass").toString(), page);
                this.appendTextElementNode(doc, "pageId", navPage.get("pageId").toString(), page);
                pages.appendChild(page);
            }
        } else {
            pages.setAttribute("count", "0");
        }
        return pages;
    }

    protected Element createPageCategories(Document doc, List pageTools) throws ToolRenderException {
        Element categories = doc.createElement("categories");
        int index = 0;
        String lastCategory = null;
        Node lastCategoryElement = null;
        for (Map page : pageTools) {
            Map pageProps = (Map)page.get("pageProps");
            String currentCategory = (String)pageProps.get("sitePage.pageCategory");
            if (currentCategory == null || !this.isDisplayToolCategories()) {
                lastCategory = null;
                lastCategoryElement = null;
                categories.appendChild(this.createUncategorizedPage(doc, page, index));
                ++index;
                continue;
            }
            if (currentCategory.equals(lastCategory)) {
                lastCategoryElement.appendChild(this.createPageXml(doc, page));
                if (!"true".equalsIgnoreCase(page.get("current").toString())) continue;
                ((Element)lastCategoryElement.getParentNode()).setAttribute("selected", "true");
                continue;
            }
            lastCategory = currentCategory;
            lastCategoryElement = this.createCategory(doc, categories, page, currentCategory, index);
            lastCategoryElement.appendChild(this.createPageXml(doc, page));
            categories.appendChild(lastCategoryElement.getParentNode());
            ++index;
        }
        return categories;
    }

    protected Element createCategory(Document doc, Element categories, Map page, String name, int index) {
        Element categoryElement = doc.createElement("category");
        categoryElement.setAttribute("selected", page.get("current").toString());
        categoryElement.setAttribute("order", Integer.toString(index));
        Element categoryKeyElement = doc.createElement("key");
        this.safeAppendTextNode(doc, categoryKeyElement, name, true);
        Element categoryEscapedKeyElement = doc.createElement("escapedKey");
        this.safeAppendTextNode(doc, categoryEscapedKeyElement, Web.escapeJavascript((String)name), false);
        categoryElement.appendChild(categoryKeyElement);
        categoryElement.appendChild(categoryEscapedKeyElement);
        Element pagesElement = doc.createElement("pages");
        categoryElement.appendChild(pagesElement);
        return pagesElement;
    }

    protected Element createUncategorizedPage(Document doc, Map page, int index) throws ToolRenderException {
        Element categoryElement = doc.createElement("category");
        categoryElement.setAttribute("selected", page.get("current").toString());
        categoryElement.setAttribute("order", Integer.toString(index));
        Element categoryKeyElement = doc.createElement("key");
        this.safeAppendTextNode(doc, categoryKeyElement, "org.theospi.portfolio.portal.model.ToolCategory.uncategorized", false);
        Element categoryEscapedKeyElement = doc.createElement("escapedKey");
        this.safeAppendTextNode(doc, categoryEscapedKeyElement, Web.escapeJavascript((String)"org.theospi.portfolio.portal.model.ToolCategory.uncategorized"), false);
        categoryElement.appendChild(categoryKeyElement);
        categoryElement.appendChild(categoryEscapedKeyElement);
        Element pagesElement = doc.createElement("pages");
        pagesElement.appendChild(this.createPageXml(doc, page));
        categoryElement.appendChild(pagesElement);
        return categoryElement;
    }

    protected Element createPageXml(Document doc, Map page) throws ToolRenderException {
        Element pageElement = doc.createElement("page");
        pageElement.setAttribute("order", Integer.valueOf(0).toString());
        Boolean selected = (Boolean)page.get("current");
        pageElement.setAttribute("selected", selected.toString());
        pageElement.setAttribute("popUp", page.get("ispopup").toString());
        pageElement.setAttribute("hidden", page.get("hidden").toString());
        Element pageName = doc.createElement("title");
        this.safeAppendTextNode(doc, pageName, page.get("pageTitle").toString(), true);
        Element pageUrl = doc.createElement("url");
        this.safeAppendTextNode(doc, pageUrl, page.get("pageRefUrl").toString(), true);
        Element popPageUrl = doc.createElement("popUrl");
        this.safeAppendTextNode(doc, popPageUrl, page.get("pagePopupUrl").toString() + page.get("pageId").toString(), true);
        Element menuClass = doc.createElement("menuClass");
        this.safeAppendTextNode(doc, menuClass, page.get("menuClass").toString(), true);
        pageElement.appendChild(pageName);
        pageElement.appendChild(pageUrl);
        pageElement.appendChild(popPageUrl);
        pageElement.appendChild(menuClass);
        if (selected.booleanValue()) {
            pageElement.setAttribute("layout", this.context.get("pageColumnLayout").equals("col1") ? "0" : "1");
            Element columns = doc.createElement("columns");
            Element column = doc.createElement("column");
            column.setAttribute("index", "0");
            column.appendChild(this.createColumnToolsXml(doc, (List)this.context.get("pageColumn0Tools"), page));
            columns.appendChild(column);
            if (this.context.get("pageColumnLayout").equals("col1of2")) {
                Element column2 = doc.createElement("column");
                column2.setAttribute("index", "1");
                column2.appendChild(this.createColumnToolsXml(doc, (List)this.context.get("pageColumn1Tools"), page));
                columns.appendChild(column2);
            }
            pageElement.appendChild(columns);
        }
        return pageElement;
    }

    protected Element createColumnToolsXml(Document doc, List tools, Map page) throws ToolRenderException {
        Element toolsElement = doc.createElement("tools");
        Iterator i = tools.iterator();
        while (i.hasNext()) {
            toolsElement.appendChild(this.createToolXml(doc, (Map)i.next(), page));
        }
        return toolsElement;
    }

    protected Element createToolXml(Document doc, Map tool, Map page) throws ToolRenderException {
        Element toolElement = doc.createElement("tool");
        Element title = doc.createElement("title");
        this.safeAppendTextNode(doc, title, tool.get("toolTitle").toString(), true);
        Element escapedId = doc.createElement("escapedId");
        this.safeAppendTextNode(doc, escapedId, tool.get("toolPlacementIDJS").toString(), true);
        toolElement.appendChild(title);
        toolElement.appendChild(escapedId);
        this.appendTextElementNode(doc, "toolReset", tool.get("toolResetActionUrl").toString(), toolElement);
        this.appendTextElementNode(doc, "toolHelp", tool.get("toolHelpActionUrl").toString(), toolElement);
        if (tool.get("toolJSR168Edit") != null) {
            this.appendTextElementNode(doc, "toolJSR168Edit", tool.get("toolJSR168Edit").toString(), toolElement);
            toolElement.setAttribute("has168Edit", "true");
        }
        if (tool.get("toolJSR168Help") != null) {
            this.appendTextElementNode(doc, "toolJSR168Help", tool.get("toolJSR168Help").toString(), toolElement);
            toolElement.setAttribute("has168Help", "true");
        }
        toolElement.setAttribute("hasReset", tool.get("toolShowResetButton").toString());
        toolElement.setAttribute("hasHelp", tool.get("toolShowHelpButton").toString());
        if (((Boolean)tool.get("hasRenderResult")).booleanValue()) {
            toolElement.setAttribute("renderResult", "true");
            RenderResult result = (RenderResult)tool.get("toolRenderResult");
            this.appendTextElementNode(doc, "resultTitle", result.getTitle(), toolElement);
            String contentStr = result.getContent();
            if (contentStr == null) {
                throw new ToolRenderException("tool xml failed to render and is null");
            }
            contentStr = contentStr.replaceAll("title=\".*" + result.getTitle() + ".*\"", "");
            Tidy tdpr = new Tidy();
            tdpr.setForceOutput(true);
            tdpr.setShowWarnings(false);
            tdpr.setXHTML(true);
            tdpr.setXmlOut(true);
            tdpr.setPrintBodyOnly(true);
            tdpr.setQuiet(true);
            StringWriter sw = new StringWriter();
            tdpr.parse((Reader)new StringReader(contentStr), (Writer)sw);
            Document content = Xml.readDocumentFromString((String)("<div>" + sw.toString() + "</div>"));
            Element contentRoot = (Element)doc.importNode(content.getDocumentElement(), true);
            Element contentElement = doc.createElement("content");
            contentElement.appendChild(contentRoot);
            toolElement.appendChild(contentElement);
        } else {
            Element toolUrl = doc.createElement("url");
            this.safeAppendTextNode(doc, toolUrl, tool.get("toolUrl") + "?panel=Main", true);
            toolElement.appendChild(toolUrl);
        }
        return toolElement;
    }

    protected Map createSiteTypesMap() {
        HashMap siteTypes = new HashMap();
        return siteTypes;
    }

    protected Element createConfixXml(Document doc, boolean loggedIn, Map sitePages) {
        Element config = doc.createElement("config");
        String skinRepo = (String)this.context.get("logoSkinRepo") + "/" + this.context.get("logoSkin");
        String helpUrl = null;
        String tutorial = null;
        if (sitePages != null) {
            String presenceUrl = (String)sitePages.get("pageNavPresenceUrl");
            boolean showPresence = (Boolean)sitePages.get("pageNavShowPresenceLoggedIn");
            Element presence = doc.createElement("presence");
            this.safeAppendTextNode(doc, presence, presenceUrl, true);
            presence.setAttribute("include", Boolean.valueOf(showPresence && loggedIn).toString());
            config.appendChild(presence);
            helpUrl = (String)sitePages.get("pageNavHelpUrl");
            config.setAttribute("pageNavPublished", sitePages.get("pageNavPublished").toString());
        }
        Element logo = doc.createElement("logo");
        this.safeAppendTextNode(doc, logo, skinRepo + "/images/logo_inst.gif", true);
        Element banner = doc.createElement("banner");
        this.safeAppendTextNode(doc, banner, skinRepo + "/images/banner_inst.gif", true);
        Element logout = doc.createElement("logout");
        this.safeAppendTextNode(doc, logout, (String)this.context.get("loginLogInOutUrl"), true);
        String copyright = (String)this.context.get("");
        String service = (String)this.context.get("bottomNavService");
        String serviceVersion = (String)this.context.get("bottomNavServiceVersion");
        String sakaiVersion = (String)this.context.get("bottomNavSakaiVersion");
        String server = (String)this.context.get("bottomNavServer");
        String portalPath = (String)this.context.get("portalPath");
        String loggedOutUrl = (String)this.context.get("loggedOutUrl");
        String timeoutDialogEnabled = this.context.get("timeoutDialogEnabled").toString();
        String timeoutDialogWarningSeconds = this.context.get("timeoutDialogWarningSeconds").toString();
        String portal_allow_auto_minimize = this.context.get("portal_allow_auto_minimize").toString();
        String portal_allow_minimize_tools = this.context.get("portal_allow_minimize_tools").toString();
        String portal_allow_minimize_navigation = this.context.get("portal_allow_minimize_navigation").toString();
        String portal_add_mobile_link = this.context.get("portal_add_mobile_link").toString();
        String maxToolsInt = this.context.get("maxToolsInt").toString();
        String neoChat = this.context.get("neoChat").toString();
        String neoAvatar = this.context.get("neoAvatar").toString();
        if (this.context.containsKey("tutorial")) {
            tutorial = this.context.get("tutorial").toString();
        }
        String[] bottomNav = this.getListAsStringArray("bottomNav");
        List poweredByList = (List)this.context.get("bottomNavPoweredBy");
        String[] poweredByUrl = new String[poweredByList.size()];
        String[] poweredByImage = new String[poweredByList.size()];
        String[] poweredByAltText = new String[poweredByList.size()];
        config.appendChild(logo);
        config.appendChild(banner);
        config.appendChild(logout);
        this.appendTextElementNode(doc, "copyright", copyright, config);
        this.appendTextElementNode(doc, "service", service, config);
        this.appendTextElementNode(doc, "serviceVersion", serviceVersion, config);
        this.appendTextElementNode(doc, "sakaiVersion", sakaiVersion, config);
        this.appendTextElementNode(doc, "server", server, config);
        this.appendTextElementNode(doc, "helpUrl", helpUrl, config);
        this.appendTextElementNode(doc, "portalPath", portalPath, config);
        this.appendTextElementNode(doc, "loggedOutUrl", loggedOutUrl, config);
        this.appendTextElementNode(doc, "timeoutDialogWarningSeconds", timeoutDialogWarningSeconds, config);
        this.appendTextElementNode(doc, "timeoutDialogEnabled", timeoutDialogEnabled, config);
        this.appendTextElementNode(doc, "portal_allow_auto_minimize", portal_allow_auto_minimize, config);
        this.appendTextElementNode(doc, "portal_allow_minimize_tools", portal_allow_minimize_tools, config);
        this.appendTextElementNode(doc, "portal_allow_minimize_navigation", portal_allow_minimize_navigation, config);
        this.appendTextElementNode(doc, "portal_add_mobile_link", portal_add_mobile_link, config);
        this.appendTextElementNode(doc, "maxToolsInt", maxToolsInt, config);
        this.appendTextElementNode(doc, "neoChat", neoChat, config);
        this.appendTextElementNode(doc, "neoAvatar", neoAvatar, config);
        this.appendTextElementNode(doc, "tutorial", tutorial, config);
        this.appendTextElementNodes(doc, bottomNav, config, "bottomNavs", "bottomNav");
        for (int i = 0; i < poweredByList.size(); ++i) {
            Map poweredBy = (Map)poweredByList.get(i);
            poweredByAltText[i] = (String)poweredBy.get("poweredByAltText");
            poweredByImage[i] = (String)poweredBy.get("poweredByImage");
            poweredByUrl[i] = (String)poweredBy.get("poweredByUrl");
            config.appendChild(this.createPoweredByXml(doc, poweredByAltText[i], poweredByImage[i], poweredByUrl[i]));
        }
        this.appendTextElementNodes(doc, poweredByUrl, config, "poweredByUrls", "poweredByUrl");
        this.appendTextElementNodes(doc, poweredByImage, config, "poweredByImages", "poweredByImage");
        this.appendTextElementNodes(doc, poweredByAltText, config, "poweredByAltTexts", "poweredByAltText");
        this.addExtraConfig(config);
        return config;
    }

    protected void addExtraConfig(Element config) {
        Element extra = config.getOwnerDocument().createElement("extra");
        config.appendChild(extra);
        for (Map.Entry entry : this.context.entrySet()) {
            List value;
            if (entry.getValue() instanceof String) {
                this.appendTextElementNode(config.getOwnerDocument(), (String)entry.getKey(), (String)entry.getValue(), extra);
                continue;
            }
            if (entry.getValue() instanceof String[]) {
                this.appendTextElementNodes(config.getOwnerDocument(), (String[])entry.getValue(), extra, entry.getKey().toString() + "-list", entry.getKey().toString());
                continue;
            }
            if (!(entry.getValue() instanceof List) || (value = (List)entry.getValue()).size() <= 0 || !(value.get(0) instanceof String)) continue;
            String[] values = new String[value.size()];
            for (int j = 0; j < values.length; ++j) {
                values[j] = value.get(j) != null ? value.get(j).toString() : null;
            }
            this.appendTextElementNodes(config.getOwnerDocument(), values, extra, entry.getKey().toString() + "-list", entry.getKey().toString());
        }
    }

    protected Element createPoweredByXml(Document doc, String text, String image, String url) {
        Element poweredBy = doc.createElement("poweredBy");
        this.appendTextElementNode(doc, "text", text, poweredBy);
        this.appendTextElementNode(doc, "image", image, poweredBy);
        this.appendTextElementNode(doc, "url", url, poweredBy);
        return poweredBy;
    }

    protected String[] getListAsStringArray(String key) {
        List list = (List)this.context.get(key);
        return list.toArray(new String[0]);
    }

    protected Element createSkin(Document doc) {
        Element skins = doc.createElement("skins");
        String skinUrl = this.context.get("pageSkinRepo") + "/" + this.context.get("pageSkin") + "/portal.css";
        Element skin = doc.createElement("skin");
        skins.appendChild(skin);
        this.safeAppendTextNode(doc, skin, skinUrl, true);
        skin.setAttribute("order", "0");
        return skins;
    }

    protected Element createLoginXml(Document doc, HttpServletRequest req) {
        Element login = doc.createElement("loginInfo");
        this.appendTextElementNodeFromProp(doc, "topLogin", "siteNavTopLogin", login);
        this.appendTextElementNodeFromProp(doc, "logInOutUrl", "loginLogInOutUrl", login);
        this.appendTextElementNodeFromProp(doc, "loginText", "loginMessage", login);
        this.appendTextElementNodeFromProp(doc, "logoutText", "loginMessage", login);
        this.appendTextElementNodeFromProp(doc, "image1", "loginImage1", login);
        return login;
    }

    protected void appendTextElementNodeFromProp(Document doc, String nodeName, String propName, Element parent) {
        Object nodeValue = this.context.get(propName);
        if (nodeValue == null) {
            this.appendTextElementNode(doc, nodeName, null, parent);
        } else {
            this.appendTextElementNode(doc, nodeName, nodeValue.toString(), parent);
        }
    }

    protected Element createUserXml(Document doc, User current) {
        Element user = doc.createElement("currentUser");
        this.appendTextElementNode(doc, "id", current.getId(), user);
        this.appendTextElementNode(doc, "eid", current.getEid(), user);
        this.appendTextElementNode(doc, "first", current.getFirstName(), user);
        this.appendTextElementNode(doc, "last", current.getLastName(), user);
        this.appendTextElementNode(doc, "displayName", current.getDisplayName(), user);
        this.appendTextElementNode(doc, "email", current.getEmail(), user);
        this.appendTextElementNode(doc, "type", current.getType(), user);
        return user;
    }

    protected void appendTextElementNode(Document doc, String name, String text, Element parent) {
        Element element = doc.createElement(name);
        this.safeAppendTextNode(doc, element, text, true);
        parent.appendChild(element);
    }

    protected void safeAppendTextNode(Document doc, Element element, String text, boolean cdata) {
        if (text != null) {
            element.appendChild(cdata ? doc.createCDATASection(text) : doc.createTextNode(text));
        }
    }

    protected void dumpDocument(Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(System.out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void appendTextElementNodes(Document doc, String[] strings, Element parent, String topNodeName, String nodeName) {
        Element topNode = doc.createElement(topNodeName);
        if (strings == null) {
            return;
        }
        for (int i = 0; i < strings.length; ++i) {
            this.appendTextElementNode(doc, nodeName, strings[i], topNode);
        }
        parent.appendChild(topNode);
    }

    public String getAlternateTemplate() {
        if (this.request.getParameter(ALT_TEMPLATE) != null) {
            return this.request.getParameter(ALT_TEMPLATE);
        }
        if (this.request.getAttribute(ALT_TEMPLATE) != null) {
            return this.request.getAttribute(ALT_TEMPLATE).toString();
        }
        return null;
    }

    public boolean isDisplayToolCategories() {
        return ServerConfigurationService.getBoolean((String)"xslPortal.displayToolCategories", (boolean)true);
    }
}

