/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.xsltcharon.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.api.PortalRenderContext;
import org.sakaiproject.portal.api.PortalRenderEngine;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.xsltcharon.impl.ServletResourceUriResolver;
import org.sakaiproject.portal.xsltcharon.impl.XsltRenderContext;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.webapp.api.WebappResourceManager;
import org.w3c.dom.Document;

public class XsltRenderEngine
implements PortalRenderEngine {
    private static final String XSLT_CONTEXT = "xsltCharon";
    private static final Log log = LogFactory.getLog(XsltRenderEngine.class);
    private PortalService portalService;
    private String defaultTransformerPath;
    private Templates defaultTemplates;
    private URIResolver libraryServletResolver;
    private URIResolver servletResolver;
    private Map<String, Templates> templates = new Hashtable();
    private Map<String, String> transformerPaths;
    private WebappResourceManager libraryWebappResourceManager;
    private WebappResourceManager portalWebappResourceManager;
    private boolean cacheTemplates = true;
    private static final String XSLT_PORTAL_CACHE_TEMPLATES = "xslt-portal.cacheTemplates";

    public XsltRenderEngine() {
    }

    public XsltRenderEngine(PortalService portalService) {
        this.portalService = portalService;
    }

    public void init() throws Exception {
    }

    public void springInit() {
        if (ServerConfigurationService.getString((String)XSLT_PORTAL_CACHE_TEMPLATES) != null) {
            try {
                this.cacheTemplates = Boolean.parseBoolean(ServerConfigurationService.getString((String)XSLT_PORTAL_CACHE_TEMPLATES, (String)"true"));
            }
            catch (Exception e) {
                log.error((Object)"can't parse xslt-portal.cacheTemplates into a boolean", (Throwable)e);
            }
        }
        this.getPortalService().addRenderEngine(XSLT_CONTEXT, (PortalRenderEngine)this);
        try {
            this.setDefaultTemplates(this.createTemplate());
            this.setupTemplates();
        }
        catch (MalformedURLException e) {
            log.error((Object)"unable to init portal transformation", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"unable to init portal transformation", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"unable to init portal transformation", (Throwable)e);
        }
        this.setServletResolver((URIResolver)new ServletResourceUriResolver(this.getPortalWebappResourceManager()));
    }

    protected void setupTemplates() throws IOException, TransformerConfigurationException {
        for (Map.Entry entry : this.getTransformerPaths().entrySet()) {
            this.getTemplates().put(entry.getKey(), this.createTemplate((String)entry.getValue()));
        }
    }

    public void destroy() {
        this.getPortalService().removeRenderEngine(XSLT_CONTEXT, (PortalRenderEngine)this);
    }

    public PortalRenderContext newRenderContext(HttpServletRequest request) {
        PortalRenderContext base = this.getPortalService().getRenderEngine("charon", request).newRenderContext(request);
        return new XsltRenderContext((PortalRenderEngine)this, base, request);
    }

    public void render(String template, PortalRenderContext rcontext, Writer out) throws Exception {
        XsltRenderContext xrc = (XsltRenderContext)rcontext;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Portal trace is on, dumping PortalRenderContext to log:\n" + xrc.dump()));
        }
        if (template.equals("site")) {
            Document doc = xrc.produceDocument();
            this.writeDocument(doc, out, xrc);
        } else {
            xrc.getBaseContext().getRenderEngine().render(template, xrc.getBaseContext(), out);
        }
    }

    protected void writeDocument(Document doc, Writer out, XsltRenderContext xrc) {
        try {
            StreamResult outputTarget = new StreamResult(out);
            Transformer transformer = this.getTransformer(xrc);
            transformer.transform(new DOMSource(doc), outputTarget);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public Transformer getTransformer(XsltRenderContext xrc) {
        try {
            Templates templates = null;
            boolean skin = false;
            if (xrc.getAlternateTemplate() != null) {
                templates = (Templates)this.getTemplates().get(xrc.getAlternateTemplate());
            }
            if (templates == null) {
                templates = this.getSkinTemplates(xrc);
                skin = true;
            }
            if (templates == null) {
                templates = this.getDefaultTemplates();
                skin = false;
            }
            Transformer trans = templates.newTransformer();
            trans.setURIResolver(this.getServletResolver(skin));
            return trans;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Templates getSkinTemplates(XsltRenderContext xrc) throws IOException, TransformerConfigurationException {
        String skin = (String)xrc.get("pageSkin");
        Templates returned = null;
        if (this.cacheTemplates && (returned = (Templates)this.getTemplates().get("skin." + skin)) != null) {
            return returned;
        }
        InputStream skinStream = this.getLibraryWebappResourceManager().getResourceAsStream("/skin/" + skin + "/portal.xslt");
        if (skinStream == null) {
            String defaultSkin = ServerConfigurationService.getString((String)"skin.default");
            skinStream = this.getLibraryWebappResourceManager().getResourceAsStream("/skin/" + defaultSkin + "/portal.xslt");
            if (skinStream == null) {
                return null;
            }
        }
        returned = this.createTemplate(skinStream);
        if (this.cacheTemplates) {
            this.getTemplates().put("skin." + skin, returned);
        }
        return returned;
    }

    protected URIResolver getServletResolver(boolean skin) {
        if (skin) {
            return this.getLibraryServletResolver();
        }
        return this.getServletResolver();
    }

    public Templates getDefaultTemplates() {
        return this.defaultTemplates;
    }

    public void setDefaultTemplates(Templates defaultTemplates) {
        this.defaultTemplates = defaultTemplates;
    }

    public URIResolver getServletResolver() {
        return this.servletResolver;
    }

    public void setServletResolver(URIResolver servletResolver) {
        this.servletResolver = servletResolver;
    }

    public void setupForward(HttpServletRequest req, HttpServletResponse res, Placement p, String skin) {
        this.getPortalService().getRenderEngine("charon", req).setupForward(req, res, p, skin);
    }

    public PortalService getPortalService() {
        return this.portalService;
    }

    public void setPortalService(PortalService portalService) {
        this.portalService = portalService;
    }

    protected Templates createTemplate() throws IOException, TransformerConfigurationException {
        String transformerPath = this.getDefaultTransformerPath();
        return this.createTemplate(transformerPath);
    }

    protected Templates createTemplate(String transformerPath) throws IOException, TransformerConfigurationException {
        return this.createTemplate(this.getPortalWebappResourceManager().getResourceAsStream(transformerPath));
    }

    protected Templates createTemplate(URL url) throws IOException, TransformerConfigurationException {
        InputStream stream = url.openStream();
        String urlPath = url.toString();
        String systemId = urlPath.substring(0, urlPath.lastIndexOf(47) + 1);
        Templates templates = TransformerFactory.newInstance().newTemplates(new StreamSource(stream, systemId));
        return templates;
    }

    protected Templates createTemplate(InputStream stream) throws IOException, TransformerConfigurationException {
        Templates templates = TransformerFactory.newInstance().newTemplates(new StreamSource(stream));
        return templates;
    }

    public String getDefaultTransformerPath() {
        return this.defaultTransformerPath;
    }

    public void setDefaultTransformerPath(String defaultTransformerPath) {
        this.defaultTransformerPath = defaultTransformerPath;
    }

    public Map<String, Templates> getTemplates() {
        return this.templates;
    }

    public void setTemplates(Map<String, Templates> templates) {
        this.templates = templates;
    }

    public Map<String, String> getTransformerPaths() {
        return this.transformerPaths;
    }

    public void setTransformerPaths(Map<String, String> transformerPaths) {
        this.transformerPaths = transformerPaths;
    }

    public WebappResourceManager getLibraryWebappResourceManager() {
        if (this.libraryWebappResourceManager == null) {
            this.libraryWebappResourceManager = (WebappResourceManager)ComponentManager.get((String)"org.sakaiproject.webapp.api.WebappResourceManager.library");
        }
        return this.libraryWebappResourceManager;
    }

    public void setLibraryWebappResourceManager(WebappResourceManager libraryWebappResourceManager) {
        this.libraryWebappResourceManager = libraryWebappResourceManager;
    }

    public WebappResourceManager getPortalWebappResourceManager() {
        return this.portalWebappResourceManager;
    }

    public void setPortalWebappResourceManager(WebappResourceManager portalWebappResourceManager) {
        this.portalWebappResourceManager = portalWebappResourceManager;
    }

    public boolean isCacheTemplates() {
        return this.cacheTemplates;
    }

    public void setCacheTemplates(boolean cacheTemplates) {
        this.cacheTemplates = cacheTemplates;
    }

    public URIResolver getLibraryServletResolver() {
        if (this.libraryServletResolver == null) {
            this.libraryServletResolver = new ServletResourceUriResolver(this.getLibraryWebappResourceManager());
        }
        return this.libraryServletResolver;
    }

    public void setLibraryServletResolver(URIResolver libraryServletResolver) {
        this.libraryServletResolver = libraryServletResolver;
    }
}

