/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.profile.Profile;
import org.sakaiproject.api.app.profile.ProfileManager;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.api.common.edu.person.SakaiPersonManager;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.app.profile.ProfileImpl;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

public class LegacyProfileManagerImpl
implements ProfileManager {
    private static final Log LOG = LogFactory.getLog(LegacyProfileManagerImpl.class);
    private SakaiPersonManager sakaiPersonManager;
    private UserDirectoryService userDirectoryService;
    private static final String ANONYMOUS = "Anonymous";
    private ServerConfigurationService serverConfigurationService;

    public void setServerConfigurationService(ServerConfigurationService scs) {
        this.serverConfigurationService = scs;
    }

    public void init() {
        LOG.info((Object)"init()");
    }

    public void destroy() {
        LOG.debug((Object)"destroy()");
    }

    public Profile getProfile() {
        LOG.debug((Object)"getProfile()");
        return this.getProfileById(this.getCurrentUserId());
    }

    public Map<String, Profile> getProfiles(Set<String> userIds) {
        LOG.debug((Object)"getProfiles()");
        return this.findProfiles(userIds);
    }

    public List findProfiles(String searchString) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findProfiles(" + searchString + ")"));
        }
        if (searchString == null || searchString.length() < 1) {
            throw new IllegalArgumentException("Illegal searchString argument passed!");
        }
        List profiles = this.sakaiPersonManager.findSakaiPerson(searchString);
        ArrayList<Profile> searchResults = new ArrayList<Profile>();
        if (profiles != null && profiles.size() > 0) {
            Iterator profileIterator = profiles.iterator();
            while (profileIterator.hasNext()) {
                ProfileImpl profile = new ProfileImpl((SakaiPerson)profileIterator.next());
                if (profile == null || !profile.getSakaiPerson().getTypeUuid().equals(this.sakaiPersonManager.getUserMutableType().getUuid())) continue;
                if (this.getCurrentUserId().equals(profile.getUserId()) || SecurityService.isSuperUser()) {
                    searchResults.add(profile);
                    continue;
                }
                if (profile.getHidePublicInfo() == null || profile.getHidePublicInfo().booleanValue()) continue;
                if (profile.getHidePrivateInfo() != null && !profile.getHidePrivateInfo().booleanValue()) {
                    searchResults.add(profile);
                    continue;
                }
                searchResults.add(this.getOnlyPublicProfile(profile));
            }
        }
        return searchResults;
    }

    public void save(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("save(" + profile + ")"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Illegal profile argument passed!");
        }
        this.sakaiPersonManager.save(profile.getSakaiPerson());
    }

    public void setSakaiPersonManager(SakaiPersonManager sakaiPersonManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setSakaiPersonManager(SakaiPersonManager " + sakaiPersonManager + ")"));
        }
        this.sakaiPersonManager = sakaiPersonManager;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setUserDirectoryService(userDirectoryService " + userDirectoryService + ")"));
        }
        this.userDirectoryService = userDirectoryService;
    }

    public byte[] getInstitutionalPhotoByUserId(String uid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getInstitutionalPhotoByUserId(String " + uid + ")"));
        }
        return this.getInstitutionalPhoto(uid, false);
    }

    public byte[] getInstitutionalPhotoByUserId(String uid, boolean viewerHasPermission) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getInstitutionalPhotoByUserId(String" + uid + ", boolean " + viewerHasPermission + ")"));
        }
        return this.getInstitutionalPhoto(uid, viewerHasPermission);
    }

    public Profile getUserProfileById(String id) {
        SakaiPerson sakaiPerson;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getUserProfileById(String" + id + ")"));
        }
        if ((sakaiPerson = this.sakaiPersonManager.getSakaiPerson(id, this.sakaiPersonManager.getUserMutableType())) == null) {
            return null;
        }
        return new ProfileImpl(sakaiPerson);
    }

    public boolean displayCompleteProfile(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("displayCompleteProfile(Profile" + profile + ")"));
        }
        if (profile == null) {
            return false;
        }
        if (this.isCurrentUserProfile(profile) || SecurityService.isSuperUser()) {
            return true;
        }
        if (profile.getHidePrivateInfo() == null) {
            return false;
        }
        if (profile.getHidePublicInfo() == null) {
            return false;
        }
        return profile.getHidePrivateInfo() != true && profile.getHidePublicInfo() != true;
    }

    public boolean isCurrentUserProfile(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isCurrentUserProfile(Profile" + profile + ")"));
        }
        return profile != null && profile.getUserId().equals(this.getCurrentUserId());
    }

    public boolean isDisplayPictureURL(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isDisplayPictureURL(Profile" + profile + ")"));
        }
        return profile != null && this.displayCompleteProfile(profile) && (profile.isInstitutionalPictureIdPreferred() == null || profile.isInstitutionalPictureIdPreferred() != true) && profile.getPictureUrl() != null && profile.getPictureUrl().trim().length() > 0;
    }

    public boolean isDisplayUniversityPhoto(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isDisplayUniversityPhoto(Profile" + profile + ")"));
        }
        return profile != null && this.displayCompleteProfile(profile) && profile.isInstitutionalPictureIdPreferred() != null && profile.isInstitutionalPictureIdPreferred() == true && this.getInstitutionalPhotoByUserId(profile.getUserId()) != null && this.getInstitutionalPhotoByUserId(profile.getUserId()).length > 0;
    }

    public boolean isDisplayUniversityPhotoUnavailable(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isDisplayUniversityPhotoUnavailable(Profile" + profile + ")"));
        }
        return profile != null && this.displayCompleteProfile(profile) && profile.isInstitutionalPictureIdPreferred() != null && profile.isInstitutionalPictureIdPreferred() == true && this.getInstitutionalPhotoByUserId(profile.getUserId()) == null && (this.getInstitutionalPhotoByUserId(profile.getUserId()) == null || this.getInstitutionalPhotoByUserId(profile.getUserId()).length < 1);
    }

    public boolean isDisplayNoPhoto(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isDisplayNoPhoto(Profile" + profile + ")"));
        }
        return profile == null || !this.displayCompleteProfile(profile) || profile.isInstitutionalPictureIdPreferred() == null || profile.isInstitutionalPictureIdPreferred() != true && (profile.getPictureUrl() == null || profile.getPictureUrl().trim().length() < 1);
    }

    public boolean isShowTool() {
        LOG.debug((Object)"isShowTool()");
        Profile profile = this.getProfile();
        return profile.getUserId() != ANONYMOUS && profile.getUserId().equalsIgnoreCase(this.getCurrentUserId());
    }

    public boolean isShowSearch() {
        LOG.debug((Object)"isShowSearch()");
        Profile profile = this.getProfile();
        if (!"false".equalsIgnoreCase(this.serverConfigurationService.getString("profile.showSearch", "true")) || this.userDirectoryService.getCurrentUser().getId().equals("admin")) {
            if (!"false".equalsIgnoreCase(this.serverConfigurationService.getString("separateIdEid@org.sakaiproject.user.api.UserDirectoryService"))) {
                return profile.getUserId() != ANONYMOUS && this.isSiteMember(profile.getSakaiPerson().getAgentUuid());
            }
            return profile.getUserId() != ANONYMOUS && this.isSiteMember(profile.getUserId());
        }
        return false;
    }

    private Profile getOnlyPublicProfile(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getOnlyPublicProfile(Profile" + profile + ")"));
        }
        profile.getSakaiPerson().setJpegPhoto(null);
        profile.setPictureUrl(null);
        profile.setEmail(null);
        profile.setHomepage(null);
        profile.setHomePhone(null);
        profile.setOtherInformation(null);
        return profile;
    }

    private byte[] getInstitutionalPhoto(String userId, boolean viewerHasPermission) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getInstitutionalPhoto(" + userId + ")"));
        }
        if (userId == null || userId.length() < 1) {
            throw new IllegalArgumentException("Illegal userId argument passed!");
        }
        SakaiPerson sakaiSystemPerson = this.sakaiPersonManager.getSakaiPerson(userId, this.sakaiPersonManager.getSystemMutableType());
        SakaiPerson sakaiPerson = this.sakaiPersonManager.getSakaiPerson(userId, this.sakaiPersonManager.getUserMutableType());
        ProfileImpl profile = null;
        if (sakaiSystemPerson == null) {
            try {
                this.userDirectoryService.getUser(userId);
            }
            catch (UserNotDefinedException unde) {
                LOG.warn((Object)("User " + userId + " does not exist. "), (Throwable)unde);
                return null;
            }
            sakaiSystemPerson = this.sakaiPersonManager.create(userId, this.sakaiPersonManager.getSystemMutableType());
        }
        ProfileImpl systemProfile = new ProfileImpl(sakaiSystemPerson);
        if (this.getCurrentUserId().equals(userId) || SecurityService.isSuperUser() || viewerHasPermission) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Official Photo fetched for userId " + userId));
            }
            return systemProfile.getInstitutionalPicture();
        }
        if (sakaiPerson != null) {
            profile = new ProfileImpl(sakaiPerson);
            if (sakaiPerson != null && profile.getHidePublicInfo() != null && !profile.getHidePublicInfo().booleanValue() && profile.getHidePrivateInfo() != null && !profile.getHidePrivateInfo().booleanValue() && profile.isInstitutionalPictureIdPreferred() != null && profile.isInstitutionalPictureIdPreferred().booleanValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Official Photo fetched for userId " + userId));
                }
                return systemProfile.getInstitutionalPicture();
            }
        }
        return null;
    }

    private boolean isSiteMember(String uid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isSiteMember(String" + uid + ")"));
        }
        try {
            return SecurityService.unlock((String)uid, (String)SiteService.SITE_VISIT, (String)SiteService.siteReference((String)this.getCurrentSiteId()));
        }
        catch (Exception e) {
            LOG.error((Object)"Exception:", (Throwable)e);
            return false;
        }
    }

    private String getCurrentSiteId() {
        LOG.debug((Object)"getCurrentSiteId()");
        Placement placement = ToolManager.getCurrentPlacement();
        return placement.getContext();
    }

    private Profile getProfileById(String id) {
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(id);
        Map<String, Profile> profiles = this.findProfiles(userIds);
        return profiles.get(id);
    }

    private Map<String, Profile> findProfiles(Set<String> userIds) {
        HashMap<String, Profile> profiles = new HashMap<String, Profile>();
        if (userIds == null || userIds.isEmpty()) {
            return profiles;
        }
        Map sakaiPeople = this.sakaiPersonManager.getSakaiPersons(userIds, this.sakaiPersonManager.getUserMutableType());
        for (String userId : userIds) {
            SakaiPerson sakaiPerson;
            block8: {
                if (userId == null || userId.length() < 1) {
                    LOG.info((Object)("Illegal uid argument passed: userId=" + userId));
                    continue;
                }
                sakaiPerson = (SakaiPerson)sakaiPeople.get(userId);
                if (userId != null && userId.trim().length() > 0) {
                    try {
                        User user = this.userDirectoryService.getUser(userId);
                        if (sakaiPerson == null) {
                            LOG.info((Object)("Could not find a sakaiPerson for id=" + user.getId() + ", eid=" + user.getEid()));
                            sakaiPerson = this.sakaiPersonManager.create(user.getId(), this.sakaiPersonManager.getUserMutableType());
                            sakaiPeople.put(user.getId(), sakaiPerson);
                        }
                    }
                    catch (UserNotDefinedException e) {
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debug((Object)("Profile requested for nonexistent userid: " + userId));
                    }
                }
            }
            profiles.put(userId, new ProfileImpl(sakaiPerson));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning profiles for " + profiles.keySet().size() + " users"));
        }
        return profiles;
    }

    private String getCurrentUserId() {
        LOG.debug((Object)"getCurrentUser()");
        return SessionManager.getCurrentSession().getUserId();
    }
}

