/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.profile;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.profile.ProfileManager;
import org.sakaiproject.component.cover.ComponentManager;

public class ProfileImageServlet
extends HttpServlet {
    private static final String PHOTO = "photo";
    private static final String CONTENT_TYPE = "image/jpeg";
    private static final String IMAGE_PATH = "/images/";
    private static final String UNAVAILABLE_IMAGE = "/officialPhotoUnavailable.jpg";
    private ProfileManager profileManager;
    private static final Log LOG = LogFactory.getLog(ProfileImageServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("doGet(HttpServletRequest" + request + ", HttpServletResponse" + response + ")"));
        }
        response.setContentType(CONTENT_TYPE);
        String userId = null;
        userId = request.getParameter(PHOTO);
        if (userId != null && userId.trim().length() > 0) {
            byte[] institutionalPhoto = this.getProfileManager().getInstitutionalPhotoByUserId(userId);
            ServletOutputStream stream = response.getOutputStream();
            if (institutionalPhoto != null && institutionalPhoto.length > 0) {
                LOG.debug((Object)("Display University ID photo for user:" + userId));
                response.setContentLength(institutionalPhoto.length);
                stream.write(institutionalPhoto);
                stream.flush();
            } else {
                try {
                    BufferedInputStream in = null;
                    try {
                        int ch;
                        in = new BufferedInputStream(new FileInputStream(this.getServletContext().getRealPath(IMAGE_PATH) + UNAVAILABLE_IMAGE));
                        while ((ch = in.read()) != -1) {
                            LOG.debug((Object)("Display University ID photo for user:" + userId + " is unavailable"));
                            stream.write((char)ch);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public ProfileManager getProfileManager() {
        if (this.profileManager == null) {
            return (ProfileManager)ComponentManager.get((String)"org.sakaiproject.api.app.profile.LegacyProfileManager");
        }
        return this.profileManager;
    }
}

