/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.profile;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.profile.Profile;
import org.sakaiproject.api.app.profile.ProfileManager;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;

public class ProfileTool {
    private static final Log LOG = LogFactory.getLog(ProfileTool.class);
    private static ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.profile.bundle.Messages");
    private static ResourceLoader cb = new ResourceLoader("org.sakaiproject.tool.profile.config.Config");
    private static final String NONE = "none";
    private static final String UNIVERSITY_PHOTO = "universityId";
    private static final String PICTURE_URL = "pictureUrl";
    private static final String NO_PICTURE = "photoUnavialable";
    private static final String NO_UNIVERSITY_PHOTO_AVAILABLE = "officalPhotoUnavailable";
    private ProfileManager profileService;
    private Profile profile;
    private boolean loadingFirstTime = true;
    private String pictureIdPreference = "none";
    private boolean displayPicture = false;
    private boolean displayNoProfileMsg = false;
    private boolean displayEvilTagMsg = false;
    private boolean displayEmptyFirstNameMsg = false;
    private boolean displayEmptyLastNameMsg = false;
    private boolean displayMalformedPictureUrlError = false;
    private boolean displayMalformedHomepageUrlError = false;
    private boolean displayInvalidEmailError = false;
    private String malformedUrlError = null;
    private String evilTagMsg = null;

    public String processActionEditSave() {
        LOG.debug((Object)"processActionEditSave()");
        this.displayEvilTagMsg = false;
        this.displayEmptyFirstNameMsg = false;
        this.displayEmptyLastNameMsg = false;
        this.displayMalformedPictureUrlError = false;
        this.displayMalformedHomepageUrlError = false;
        this.displayInvalidEmailError = false;
        if (this.profile != null && this.profile.getUserId() == null) {
            LOG.error((Object)"processActionEditSave :No User Found");
            return "permissionException";
        }
        if (this.profile.getFirstName() == null || this.profile.getFirstName().trim().length() < 1) {
            this.displayEmptyFirstNameMsg = true;
            return "edit";
        }
        if (this.profile.getLastName() == null || this.profile.getLastName().trim().length() < 1) {
            this.displayEmptyLastNameMsg = true;
            return "edit";
        }
        if (this.profile.getEmail() == null || !this.isValidEmail(this.profile.getEmail())) {
            this.displayInvalidEmailError = true;
            return "edit";
        }
        if (this.profile.getOtherInformation() != null) {
            StringBuilder alertMsg = new StringBuilder();
            String errorMsg = null;
            try {
                errorMsg = FormattedText.processFormattedText((String)this.profile.getOtherInformation(), (StringBuilder)alertMsg);
                if (alertMsg.length() > 0) {
                    this.evilTagMsg = alertMsg.toString();
                    this.displayEvilTagMsg = true;
                    return "edit";
                }
            }
            catch (Exception e) {
                LOG.error((Object)(" " + errorMsg), (Throwable)e);
            }
        }
        if (this.getPictureIdPreference() != null && this.getPictureIdPreference().equals(UNIVERSITY_PHOTO)) {
            this.profile.setInstitutionalPictureIdPreferred(new Boolean(true));
            this.profile.setPictureUrl(null);
            this.displayPicture = true;
            this.pictureIdPreference = UNIVERSITY_PHOTO;
        } else if (this.getPictureIdPreference() != null && this.getPictureIdPreference().equals(PICTURE_URL)) {
            this.profile.setInstitutionalPictureIdPreferred(new Boolean(false));
            this.displayPicture = true;
            this.pictureIdPreference = PICTURE_URL;
            if (this.profile.getPictureUrl() != null && this.profile.getPictureUrl().trim().length() > 0) {
                try {
                    String pictureUrl = this.validateURL(this.profile.getPictureUrl());
                    this.profile.setPictureUrl(pictureUrl);
                }
                catch (MalformedURLException e) {
                    this.displayMalformedPictureUrlError = true;
                    this.malformedUrlError = rb.getString("validurl") + " \"" + this.profile.getPictureUrl() + "\" " + rb.getString("invalid");
                    return "edit";
                }
            }
        } else {
            this.profile.setInstitutionalPictureIdPreferred(new Boolean(false));
            this.profile.setPictureUrl(null);
            this.displayPicture = false;
            this.pictureIdPreference = NONE;
        }
        if (this.profile.getHomepage() != null && this.profile.getHomepage().trim().length() > 0) {
            try {
                String homepageUrl = this.validateURL(this.profile.getHomepage().trim());
                this.profile.setHomepage(homepageUrl);
            }
            catch (MalformedURLException e) {
                this.displayMalformedHomepageUrlError = true;
                this.malformedUrlError = rb.getString("validurl") + " \"" + this.profile.getHomepage() + "\" " + rb.getString("invalid");
                return "edit";
            }
        }
        try {
            this.profileService.save(this.profile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return "main";
    }

    public String processActionEdit() {
        LOG.debug((Object)"processActionEdit()");
        try {
            if (this.profile != null && this.profile.getUserId() == null) {
                LOG.error((Object)"processActionEdit : No User Found");
                return "PermissionException";
            }
            this.setPictureIdPreference(this.profile);
            return "edit";
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String processCancel() {
        LOG.debug((Object)"processCancel()");
        this.profile = this.profileService.getProfile();
        return "main";
    }

    public Profile getProfile() {
        LOG.debug((Object)"getProfile()");
        if (this.loadingFirstTime) {
            this.profile = this.profileService.getProfile();
            this.setPictureIdPreference(this.profile);
            this.loadingFirstTime = false;
        } else {
            this.displayNoProfileMsg = this.profile == null ? true : (this.profile.getFirstName() == null || this.profile.getLastName() == null ? true : this.profile.getFirstName().equalsIgnoreCase("") || this.profile.getLastName().equalsIgnoreCase(""));
        }
        return this.profile;
    }

    public ProfileManager getProfileService() {
        LOG.debug((Object)"getProfileService()");
        return this.profileService;
    }

    public void setProfileService(ProfileManager profileService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setProfileService(ProfileManager" + profileService + ")()"));
        }
        this.profileService = profileService;
    }

    public boolean isDisplayNoProfileMsg() {
        LOG.debug((Object)"isDisplayNoProfileMsg()");
        return this.displayNoProfileMsg;
    }

    public boolean isLoadingFirstTime() {
        LOG.debug((Object)"isLoadingFirstTime()");
        return this.loadingFirstTime;
    }

    public String getPictureIdPreference() {
        LOG.debug((Object)"getPictureIdPreference()");
        return this.pictureIdPreference;
    }

    public void setPictureIdPreference(String pictureIdPreference) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setPictureIDPreference(String" + pictureIdPreference + ")"));
        }
        this.pictureIdPreference = pictureIdPreference;
    }

    public boolean isShowTool() {
        LOG.debug((Object)"isShowTool()");
        return this.profileService.isShowTool();
    }

    public boolean isShowSearch() {
        LOG.debug((Object)"isShowSearch()");
        return this.profileService.isShowSearch();
    }

    public String getTitle() {
        LOG.debug((Object)"getTitle()");
        return SiteService.findTool((String)ToolManager.getCurrentPlacement().getId()).getTitle();
    }

    public String getEvilTagMsg() {
        LOG.debug((Object)"getEvilTagMsg()");
        return this.evilTagMsg;
    }

    public boolean isDisplayEvilTagMsg() {
        LOG.debug((Object)"isDisplayEvilTagMsg()");
        return this.displayEvilTagMsg;
    }

    public boolean isDisplayInvalidEmailMsg() {
        return this.displayInvalidEmailError;
    }

    public boolean isDisplayEmptyFirstNameMsg() {
        LOG.debug((Object)"isDisplayEmptyFirstNameMsg()");
        return this.displayEmptyFirstNameMsg;
    }

    public boolean isDisplayEmptyLastNameMsg() {
        LOG.debug((Object)"isDisplayEmptyLastNameMsg()");
        return this.displayEmptyLastNameMsg;
    }

    public boolean isDisplayNoPicture() {
        LOG.debug((Object)"isDisplayPicture()");
        return this.profileService.isDisplayNoPhoto(this.profile);
    }

    public void setProfile(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setProfile(Profile" + profile + ")"));
        }
        this.profile = profile;
    }

    public boolean isDisplayPictureURL() {
        LOG.debug((Object)"isDisplayPictureURL()");
        return this.profileService.isDisplayPictureURL(this.profile);
    }

    public boolean isDisplayUniversityPhoto() {
        LOG.debug((Object)"isDisplayUniversityPhoto()");
        return this.profileService.isDisplayUniversityPhoto(this.profile);
    }

    public boolean isDisplayUniversityPhotoUnavailable() {
        LOG.debug((Object)"isDisplayUniversityPhotoUnavailable()");
        return this.profileService.isDisplayUniversityPhotoUnavailable(this.profile);
    }

    private void setPictureIdPreference(Profile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setPictureIdPreference(Profile" + profile + ")"));
        }
        if (profile.isInstitutionalPictureIdPreferred() != null && profile.isInstitutionalPictureIdPreferred().booleanValue()) {
            this.pictureIdPreference = UNIVERSITY_PHOTO;
            this.displayPicture = true;
        } else if (profile.getPictureUrl() != null && profile.getPictureUrl().length() > 0) {
            this.pictureIdPreference = PICTURE_URL;
            this.displayPicture = true;
        } else {
            this.pictureIdPreference = NONE;
            this.displayPicture = false;
        }
    }

    public boolean isDisplayMalformedPictureUrlError() {
        LOG.debug((Object)"isDisplayMalformedPictureUrlError()");
        return this.displayMalformedPictureUrlError;
    }

    public boolean isDisplayMalformedHomepageUrlError() {
        LOG.debug((Object)"isDisplayMalformedHomepageUrlError()");
        return this.displayMalformedHomepageUrlError;
    }

    public String getMalformedUrlError() {
        LOG.debug((Object)"getMalformedUrlError()");
        return this.malformedUrlError;
    }

    private String validateURL(String url) throws MalformedURLException {
        if (url != null && !url.equals("") && url.indexOf("://") == -1) {
            url = "http://" + url;
        }
        if (url != null && !url.equals("")) {
            try {
                URL u = new URL(url);
            }
            catch (MalformedURLException e1) {
                try {
                    Pattern pattern = Pattern.compile("\\s*([a-zA-Z0-9]+)://([^\\n]+)");
                    Matcher matcher = pattern.matcher(url);
                    if (!matcher.matches()) {
                        throw e1;
                    }
                    URL test = new URL("http://" + matcher.group(2));
                }
                catch (MalformedURLException e2) {
                    throw e1;
                }
            }
        }
        return url;
    }

    private boolean isValidEmail(String email) {
        if (email == null || email.equals("")) {
            return false;
        }
        if ((email = email.trim()).indexOf("@") == -1) {
            return false;
        }
        if (email.indexOf(" ") > 0) {
            return false;
        }
        return email.matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*$");
    }

    public String getImageUrlToDisplay() {
        String imageUrl = "";
        imageUrl = this.isDisplayUniversityPhoto() ? "ProfileImageServlet.prf?photo=" + this.profile.getUserId() : (this.isDisplayPictureURL() ? this.profile.getPictureUrl() : (this.isDisplayNoPicture() ? cb.getString(NO_PICTURE) : cb.getString(NO_UNIVERSITY_PHOTO_AVAILABLE)));
        return imageUrl;
    }
}

