/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.profile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.event.ValueChangeEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.profile.Profile;
import org.sakaiproject.api.app.profile.ProfileManager;
import org.sakaiproject.tool.profile.SearchTool;
import org.sakaiproject.util.ResourceLoader;

public class SearchTool {
    private ResourceLoader msgs = new ResourceLoader("org.sakaiproject.tool.profile.bundle.Messages");
    private static final Log LOG = LogFactory.getLog(SearchTool.class);
    private DecoratedProfile profile;
    private String searchKeyword;
    private List searchResults;
    private List currentSearchResults;
    private int noOfRecDisplayedFrom = 0;
    private int noOfRecDisplayedTo = 0;
    private int numberOfSearchedRecordsDisplayedPerPage = 10;
    private String displayNoOfRec = "10";
    private boolean showPrevious = false;
    private boolean showNext = false;
    private boolean showSearchResults = false;
    private boolean showNoMatchFound = false;
    private boolean redirectToSearchedProfile = false;
    protected ProfileManager profileService;

    public SearchTool() {
        this.reset(this.msgs.getString("java.search_keyword"));
    }

    public String getDisplayPage() {
        LOG.debug((Object)"getDisplayPage()");
        if (this.redirectToSearchedProfile) {
            return "displaySearchedProfile";
        }
        return "main";
    }

    public void processValueChangeForDisplayNSearchResult(ValueChangeEvent vce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processValueChangeForDisplayNSearchResult(ValueChangeEvent " + vce + ")"));
        }
        this.setDisplayNoOfRec((String)vce.getNewValue());
        LOG.debug((Object)("Show these many rec :" + (String)vce.getNewValue()));
        this.processActionDisplayFirst();
    }

    public String processActionDisplayFirst() {
        LOG.debug((Object)"processActionDisplayFirst()");
        try {
            if (this.searchResults != null && this.searchResults.size() > 1 && this.searchResults.size() <= this.numberOfSearchedRecordsDisplayedPerPage) {
                this.showPrevious = false;
                this.showNext = false;
                this.showSearchResults = true;
                this.currentSearchResults = this.searchResults;
                this.noOfRecDisplayedFrom = 1;
                this.noOfRecDisplayedTo = this.searchResults.size();
                return this.getDisplayPage();
            }
            if (this.searchResults != null && this.searchResults.size() > this.numberOfSearchedRecordsDisplayedPerPage) {
                this.currentSearchResults = this.searchResults.subList(0, this.numberOfSearchedRecordsDisplayedPerPage);
                this.noOfRecDisplayedFrom = 1;
                this.noOfRecDisplayedTo = this.numberOfSearchedRecordsDisplayedPerPage;
                this.showPrevious = false;
                this.showNext = true;
                this.showSearchResults = true;
                return this.getDisplayPage();
            }
            return this.profile.processActionDisplayProfile();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String processActionDisplayNext() {
        LOG.debug((Object)"processActionDisplayNext()");
        try {
            if (this.searchResults != null && this.searchResults.size() > this.noOfRecDisplayedTo) {
                this.showNoMatchFound = false;
                this.showSearchResults = true;
                this.showPrevious = true;
                if (this.searchResults.size() > this.noOfRecDisplayedTo + this.numberOfSearchedRecordsDisplayedPerPage) {
                    this.currentSearchResults = this.searchResults.subList(this.noOfRecDisplayedTo, this.noOfRecDisplayedTo + this.numberOfSearchedRecordsDisplayedPerPage);
                    this.noOfRecDisplayedFrom = this.noOfRecDisplayedTo + 1;
                    this.noOfRecDisplayedTo += this.numberOfSearchedRecordsDisplayedPerPage;
                    this.showNext = true;
                    return this.getDisplayPage();
                }
                if (this.searchResults.size() == this.noOfRecDisplayedTo + this.numberOfSearchedRecordsDisplayedPerPage) {
                    this.currentSearchResults = this.searchResults.subList(this.noOfRecDisplayedTo, this.noOfRecDisplayedTo + this.numberOfSearchedRecordsDisplayedPerPage);
                    this.noOfRecDisplayedFrom = this.noOfRecDisplayedTo + 1;
                    this.noOfRecDisplayedTo += this.numberOfSearchedRecordsDisplayedPerPage;
                    this.showNext = false;
                    return this.getDisplayPage();
                }
                if (this.searchResults.size() < this.noOfRecDisplayedTo + this.numberOfSearchedRecordsDisplayedPerPage) {
                    this.currentSearchResults = this.searchResults.subList(this.noOfRecDisplayedTo, this.searchResults.size());
                    this.noOfRecDisplayedFrom = this.noOfRecDisplayedTo + 1;
                    this.noOfRecDisplayedTo = this.searchResults.size();
                    this.showNext = false;
                    return this.getDisplayPage();
                }
            }
            return this.getDisplayPage();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String processActionDisplayPrevious() {
        LOG.debug((Object)"processActionDisplayPrevious()");
        try {
            if (this.searchResults != null && this.noOfRecDisplayedFrom > 1 && this.noOfRecDisplayedFrom >= this.numberOfSearchedRecordsDisplayedPerPage) {
                this.showNext = true;
                this.showNoMatchFound = false;
                this.showSearchResults = true;
                if (this.noOfRecDisplayedFrom - this.numberOfSearchedRecordsDisplayedPerPage == 1) {
                    this.showPrevious = false;
                    this.currentSearchResults = this.searchResults.subList(0, this.numberOfSearchedRecordsDisplayedPerPage);
                    this.noOfRecDisplayedFrom = 1;
                    this.noOfRecDisplayedTo = this.numberOfSearchedRecordsDisplayedPerPage;
                } else {
                    this.showPrevious = true;
                    this.currentSearchResults = this.searchResults.subList(this.noOfRecDisplayedFrom - this.numberOfSearchedRecordsDisplayedPerPage - 1, this.noOfRecDisplayedFrom - 1);
                    this.noOfRecDisplayedTo = this.noOfRecDisplayedFrom - 1;
                    this.noOfRecDisplayedFrom -= this.numberOfSearchedRecordsDisplayedPerPage;
                }
            } else {
                this.showPrevious = false;
            }
            return this.getDisplayPage();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String processActionDisplayLast() {
        LOG.debug((Object)"processActionDisplayLast()");
        try {
            if (this.searchResults != null && this.searchResults.size() > 1 && this.searchResults.size() <= this.numberOfSearchedRecordsDisplayedPerPage) {
                this.showPrevious = false;
                this.showNext = false;
                this.currentSearchResults = this.searchResults;
                return this.getDisplayPage();
            }
            if (this.searchResults != null && this.searchResults.size() > this.numberOfSearchedRecordsDisplayedPerPage) {
                int displayRecForLastPage = this.searchResults.size() % this.numberOfSearchedRecordsDisplayedPerPage;
                if (displayRecForLastPage == 0) {
                    this.currentSearchResults = this.searchResults.subList(this.searchResults.size() - this.numberOfSearchedRecordsDisplayedPerPage, this.searchResults.size());
                    this.noOfRecDisplayedFrom = this.searchResults.size() - this.numberOfSearchedRecordsDisplayedPerPage + 1;
                } else {
                    this.currentSearchResults = this.searchResults.subList(this.searchResults.size() - displayRecForLastPage, this.searchResults.size());
                    this.noOfRecDisplayedFrom = this.searchResults.size() - displayRecForLastPage + 1;
                }
                this.noOfRecDisplayedTo = this.searchResults.size();
                this.showPrevious = true;
                this.showNext = false;
                return this.getDisplayPage();
            }
            return this.profile.processActionDisplayProfile();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String processActionSearch() {
        LOG.debug((Object)"processActionSearch()");
        try {
            this.reset(this.searchKeyword);
            if (this.searchKeyword == null || this.searchKeyword.trim().length() < 1) {
                this.showNoMatchFound = true;
                return "main";
            }
            List profiles = this.profileService.findProfiles(this.searchKeyword);
            this.searchResults = new ArrayList();
            if (profiles != null && profiles.size() > 0) {
                Iterator profileIterator = profiles.iterator();
                while (profileIterator.hasNext()) {
                    this.profile = new DecoratedProfile(this, (Profile)profileIterator.next());
                    this.searchResults.add(this.profile);
                }
                return this.processActionDisplayFirst();
            }
            this.showNoMatchFound = true;
            return "main";
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean isShowNext() {
        LOG.debug((Object)"isShowNext()");
        return this.showNext;
    }

    public boolean isShowPrevious() {
        LOG.debug((Object)"isShowPrevious()");
        return this.showPrevious;
    }

    public List getCurrentSearchResults() {
        LOG.debug((Object)"getCurrentSearchResults()");
        return this.currentSearchResults;
    }

    public void setCurrentSearchResults(List currentSearchResults) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setCurrentSearchResults(List" + currentSearchResults + ")"));
        }
        this.currentSearchResults = currentSearchResults;
    }

    public boolean isShowNoMatchFound() {
        LOG.debug((Object)"isShowNoMatchFound()");
        return this.showNoMatchFound;
    }

    public boolean isShowSearchResults() {
        LOG.debug((Object)"isShowSearchResults()");
        return this.showSearchResults;
    }

    public void reset(String searchKeyword) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reset(String" + searchKeyword + ")"));
        }
        this.searchKeyword = searchKeyword;
        this.profile = null;
        this.searchResults = null;
        this.currentSearchResults = null;
        this.noOfRecDisplayedFrom = 0;
        this.noOfRecDisplayedTo = 0;
        this.showPrevious = false;
        this.showNext = false;
        this.showSearchResults = false;
        this.showNoMatchFound = false;
        this.redirectToSearchedProfile = false;
    }

    public String processCancel() {
        LOG.debug((Object)"processCancel()");
        this.reset(this.msgs.getString("java.search_keyword"));
        return "main";
    }

    public String getDisplayNoOfRec() {
        LOG.debug((Object)"getDisplayNoOfRec()");
        try {
            if (this.displayNoOfRec != null && Integer.parseInt(this.displayNoOfRec) != 0) {
                this.numberOfSearchedRecordsDisplayedPerPage = Integer.parseInt(this.displayNoOfRec);
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.displayNoOfRec;
    }

    public void setDisplayNoOfRec(String no_of_searched_rec_per_page) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setDisplayNoOfRec(String " + no_of_searched_rec_per_page + ")"));
        }
        this.displayNoOfRec = no_of_searched_rec_per_page;
        try {
            if (this.displayNoOfRec != null && Integer.parseInt(this.displayNoOfRec) != 0) {
                this.numberOfSearchedRecordsDisplayedPerPage = Integer.parseInt(this.displayNoOfRec);
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public DecoratedProfile getProfile() {
        LOG.debug((Object)"getProfile()");
        return this.profile;
    }

    public ProfileManager getProfileService() {
        LOG.debug((Object)"getProfileService()");
        return this.profileService;
    }

    public String getSearchKeyword() {
        LOG.debug((Object)"getSearchKeyword()");
        return this.searchKeyword;
    }

    public List getSearchResults() {
        LOG.debug((Object)"getSearchResults()");
        return this.searchResults;
    }

    public void setProfileService(ProfileManager profileService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setProfileService(ProfileManager " + profileService + ")"));
        }
        this.profileService = profileService;
    }

    public void setProfile(DecoratedProfile profile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setProfile(DecoratedProfile " + profile + ")"));
        }
        this.profile = profile;
    }

    public void setSearchKeyword(String searchKeyword) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setSearchResults(String " + searchKeyword + ")"));
        }
        this.searchKeyword = searchKeyword;
    }

    public void setSearchResults(List searchResults) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setSearchResults(List " + searchResults + ")"));
        }
        this.searchResults = searchResults;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ DecoratedProfile access$102(SearchTool x0, DecoratedProfile x1) {
        x0.profile = x1;
        return x0.profile;
    }

    static /* synthetic */ boolean access$202(SearchTool x0, boolean x1) {
        x0.redirectToSearchedProfile = x1;
        return x0.redirectToSearchedProfile;
    }
}

