/**
 * Copyright (c) 2008-2012 The Sakai Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *             http://www.osedu.org/licenses/ECL-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sakaiproject.profile2.types;

/**
 * These are the types of privacy settings in Profile2.
 * <p>
 * We use these when checking the different options
 * <p>
 * 
 * @author Steve Swinsburg (steve.swinsburg@gmail.com)
 * @since 1.5
 *
 */
public enum PrivacyType {

	PRIVACY_OPTION_PROFILEIMAGE,
	PRIVACY_OPTION_BASICINFO,
	PRIVACY_OPTION_CONTACTINFO,
	PRIVACY_OPTION_PERSONALINFO,
	PRIVACY_OPTION_SEARCH,
	PRIVACY_OPTION_MYFRIENDS,
	PRIVACY_OPTION_MYSTATUS,
	PRIVACY_OPTION_MYPICTURES,
	PRIVACY_OPTION_MESSAGES,
	PRIVACY_OPTION_BUSINESSINFO,
	PRIVACY_OPTION_STAFFINFO,
	PRIVACY_OPTION_STUDENTINFO,
	PRIVACY_OPTION_MYKUDOS,
	PRIVACY_OPTION_MYWALL,
	PRIVACY_OPTION_SOCIALINFO,
	PRIVACY_OPTION_ONLINESTATUS;
	
}
