/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.messaging.api.BullhornData;
import org.sakaiproject.messaging.api.bullhornhandlers.AbstractBullhornHandler;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.sakaiproject.user.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FriendStatusBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendStatusBullhornHandler.class);
    @Resource
    private ProfileConnectionsLogic profileConnectionsLogic;
    @Resource
    private ProfileLinkLogic profileLinkLogic;

    public List<String> getHandledEvents() {
        return Arrays.asList("profile.status.update");
    }

    public Optional<List<BullhornData>> handleEvent(Event e) {
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        ArrayList<BullhornData> bhEvents = new ArrayList<BullhornData>();
        List<User> connections = this.profileConnectionsLogic.getConnectedUsersForUserInsecurely(from);
        for (User connection : connections) {
            String to = connection.getId();
            String url = this.profileLinkLogic.getInternalDirectUrlToUserProfile(to, from);
            bhEvents.add(new BullhornData(from, to, "", "", url));
        }
        return Optional.of(bhEvents);
    }
}

