/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.messaging.api.AbstractUserNotificationHandler;
import org.sakaiproject.messaging.api.UserNotificationData;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FriendRequestUserNotificationHandler
extends AbstractUserNotificationHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendRequestUserNotificationHandler.class);
    @Resource
    private ServerConfigurationService serverConfigurationService;
    @Resource
    private SiteService siteService;

    public List<String> getHandledEvents() {
        return Arrays.asList("profile.friend.request");
    }

    public Optional<List<UserNotificationData>> handleEvent(Event e) {
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        String to = pathParts[2];
        String siteId = "~" + to;
        try {
            Site site = this.siteService.getSite(siteId);
            String toolId = site.getToolForCommonId("sakai.profile2").getId();
            String url = this.serverConfigurationService.getPortalUrl() + "/site/" + siteId + "/tool/" + toolId + "/connections";
            return Optional.of(Collections.singletonList(new UserNotificationData(from, to, siteId, "", url)));
        }
        catch (IdUnusedException idue) {
            log.error("No site for id: " + siteId);
            return Optional.empty();
        }
    }
}

