/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.legacy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.profile.Profile;
import org.sakaiproject.api.app.profile.ProfileManager;
import org.sakaiproject.profile2.legacy.ProfileImpl;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ProfileImage;
import org.sakaiproject.profile2.model.UserProfile;

public class ProfileManagerImpl
implements ProfileManager {
    private static final Log log = LogFactory.getLog(ProfileManagerImpl.class);
    private ProfileLogic profileLogic;
    private ProfileImageLogic imageLogic;
    private SakaiProxy sakaiProxy;

    public Profile getUserProfileById(String userId) {
        UserProfile userProfile = this.profileLogic.getUserProfile(userId);
        if (userProfile == null) {
            return null;
        }
        Profile profile = this.transformUserProfiletoLegacyProfile(userProfile);
        ProfileImage image = this.getProfileImage(userId);
        if (StringUtils.isNotBlank((String)image.getUrl())) {
            profile.setPictureUrl(image.getUrl());
        }
        return profile;
    }

    public boolean displayCompleteProfile(Profile profile) {
        if (profile == null) {
            return false;
        }
        String currentSiteId = this.sakaiProxy.getCurrentSiteId();
        return this.sakaiProxy.isUserMyWorkspace(currentSiteId) || this.sakaiProxy.isUserAllowedInSite(this.sakaiProxy.getCurrentUserId(), "roster.viewprofile", currentSiteId);
    }

    public byte[] getInstitutionalPhotoByUserId(String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new IllegalArgumentException("Illegal userId argument passed!");
        }
        ProfileImage image = this.getProfileImage(userId);
        return image.getBinary();
    }

    public byte[] getInstitutionalPhotoByUserId(String userId, boolean viewerHasPermission) {
        return this.getInstitutionalPhotoByUserId(userId);
    }

    public Map<String, Profile> getProfiles(Set<String> userIds) {
        HashMap<String, Profile> profiles = new HashMap<String, Profile>();
        if (userIds == null || userIds.isEmpty()) {
            return profiles;
        }
        for (String userId : userIds) {
            Profile profile = this.getUserProfileById(userId);
            if (profile == null) continue;
            profiles.put(userId, profile);
        }
        return profiles;
    }

    private ProfileImage getProfileImage(String userUuid) {
        String currentSiteId = this.sakaiProxy.getCurrentSiteId();
        return this.imageLogic.getProfileImage(userUuid, null, null, 1, currentSiteId);
    }

    private Profile transformUserProfiletoLegacyProfile(UserProfile up) {
        String userUuid = up.getUserUuid();
        ProfileImpl p = new ProfileImpl();
        p.setUserID(userUuid);
        p.setNickName(up.getNickname());
        p.setFirstName(this.sakaiProxy.getUserFirstName(userUuid));
        p.setLastName(this.sakaiProxy.getUserLastName(userUuid));
        p.setEmail(this.sakaiProxy.getUserEmail(userUuid));
        p.setHomepage(up.getHomepage());
        p.setHomePhone(up.getHomephone());
        p.setWorkPhone(up.getWorkphone());
        p.setDepartment(up.getDepartment());
        p.setPosition(up.getPosition());
        p.setSchool(up.getSchool());
        p.setRoom(up.getRoom());
        p.setOtherInformation(up.getPersonalSummary());
        p.setHidePrivateInfo(false);
        p.setHidePublicInfo(false);
        p.setInstitutionalPictureIdPreferred(true);
        return p;
    }

    public boolean isCurrentUserProfile(Profile profile) {
        return profile != null && StringUtils.equals((String)profile.getUserId(), (String)this.sakaiProxy.getCurrentUserId());
    }

    public void init() {
        log.info((Object)"Profile2's LegacyProfileManager: init()");
    }

    public void destroy() {
        log.debug((Object)"Profile2's LegacyProfileManager: destroy()");
    }

    public void setProfileLogic(ProfileLogic profileLogic) {
        this.profileLogic = profileLogic;
    }

    public void setImageLogic(ProfileImageLogic imageLogic) {
        this.imageLogic = imageLogic;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public List findProfiles(String arg0) {
        return null;
    }

    public Profile getProfile() {
        return null;
    }

    public boolean isDisplayNoPhoto(Profile arg0) {
        return false;
    }

    public boolean isDisplayPictureURL(Profile arg0) {
        return false;
    }

    public boolean isDisplayUniversityPhoto(Profile arg0) {
        return false;
    }

    public boolean isDisplayUniversityPhotoUnavailable(Profile arg0) {
        return false;
    }

    public boolean isShowSearch() {
        return false;
    }

    public boolean isShowTool() {
        return false;
    }

    public void save(Profile arg0) {
    }
}

