/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.conversion.ProfileConverter;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.ProfileStatusLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.BasicPerson;
import org.sakaiproject.profile2.model.CompanyProfile;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.model.SocialNetworkingInfo;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.types.PrivacyType;
import org.sakaiproject.profile2.util.ProfileUtils;
import org.sakaiproject.user.api.User;

public class ProfileLogicImpl
implements ProfileLogic {
    private static final Logger log = Logger.getLogger(ProfileLogicImpl.class);
    private SakaiProxy sakaiProxy;
    private ProfileDao dao;
    private ProfilePreferencesLogic preferencesLogic;
    private ProfileStatusLogic statusLogic;
    private ProfilePrivacyLogic privacyLogic;
    private ProfileConnectionsLogic connectionsLogic;
    private ProfileImageLogic imageLogic;
    private ProfileConverter converter;
    private ProfileLinkLogic linkLogic;

    public UserProfile getUserProfile(String userUuid) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("Must be logged in to get a UserProfile.");
        }
        User u = this.sakaiProxy.getUserById(userUuid);
        if (u == null) {
            log.error((Object)("User " + userUuid + " does not exist."));
            return null;
        }
        UserProfile p = new UserProfile();
        p.setUserUuid(userUuid);
        p.setDisplayName(u.getDisplayName());
        p.setImageUrl(this.imageLogic.getProfileImageEntityUrl(userUuid, 1));
        p.setImageThumbUrl(this.imageLogic.getProfileImageEntityUrl(userUuid, 2));
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userUuid);
        if (sakaiPerson == null) {
            return p;
        }
        p = this.transformSakaiPersonToUserProfile(p, sakaiPerson);
        if (userUuid.equals(currentUserUuid) || this.sakaiProxy.isSuperUser()) {
            p.setEmail(u.getEmail());
            p.setStatus(this.statusLogic.getUserStatus(userUuid));
            p.setSocialInfo(this.getSocialNetworkingInfo(userUuid));
            p.setCompanyProfiles(this.getCompanyProfiles(userUuid));
            return p;
        }
        if (!this.privacyLogic.isBirthYearVisible(userUuid)) {
            if (p.getDateOfBirth() != null) {
                p.setDateOfBirth(ProfileUtils.stripYear((Date)p.getDateOfBirth()));
            } else {
                p.setDateOfBirth(null);
            }
        }
        if (!this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_BASICINFO)) {
            p.setNickname(null);
            p.setDateOfBirth(null);
            p.setPersonalSummary(null);
        }
        if (this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_CONTACTINFO)) {
            p.setEmail(u.getEmail());
        } else {
            p.setEmail(null);
            p.setHomepage(null);
            p.setHomephone(null);
            p.setWorkphone(null);
            p.setMobilephone(null);
            p.setFacsimile(null);
        }
        if (!this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_STAFFINFO)) {
            p.setDepartment(null);
            p.setPosition(null);
            p.setSchool(null);
            p.setRoom(null);
            p.setStaffProfile(null);
            p.setAcademicProfileUrl(null);
            p.setUniversityProfileUrl(null);
            p.setPublications(null);
        }
        if (!this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_STUDENTINFO)) {
            p.setCourse(null);
            p.setSubjects(null);
        }
        if (!this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_PERSONALINFO)) {
            p.setFavouriteBooks(null);
            p.setFavouriteTvShows(null);
            p.setFavouriteMovies(null);
            p.setFavouriteQuotes(null);
        }
        if (this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_SOCIALINFO)) {
            p.setSocialInfo(this.getSocialNetworkingInfo(userUuid));
        }
        if (this.sakaiProxy.isBusinessProfileEnabled()) {
            if (this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_BUSINESSINFO)) {
                p.setCompanyProfiles(this.getCompanyProfiles(userUuid));
            } else {
                p.setBusinessBiography(null);
            }
        } else {
            p.setBusinessBiography(null);
        }
        if (this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_MYSTATUS)) {
            p.setStatus(this.statusLogic.getUserStatus(userUuid));
        }
        return p;
    }

    public boolean saveUserProfile(SakaiPerson sp) {
        if (this.sakaiProxy.updateSakaiPerson(sp)) {
            this.sendProfileChangeEmailNotification(sp.getAgentUuid());
            return true;
        }
        return false;
    }

    public boolean addNewCompanyProfile(CompanyProfile companyProfile) {
        if (this.dao.addNewCompanyProfile(companyProfile)) {
            log.info((Object)("Added new company profile for user: " + companyProfile.getUserUuid()));
            return true;
        }
        return false;
    }

    public boolean updateCompanyProfile(CompanyProfile companyProfile) {
        if (this.dao.updateCompanyProfile(companyProfile)) {
            log.info((Object)("Saved company profile for user: " + companyProfile.getUserUuid()));
            return true;
        }
        return false;
    }

    public List<CompanyProfile> getCompanyProfiles(String userId) {
        return this.dao.getCompanyProfiles(userId);
    }

    public boolean removeCompanyProfile(String userId, long companyProfileId) {
        if (userId == null || Long.valueOf(companyProfileId) == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogicImpl.removeCompanyProfile()");
        }
        CompanyProfile companyProfile = this.dao.getCompanyProfile(userId, companyProfileId);
        if (companyProfile == null) {
            log.error((Object)("CompanyProfile record does not exist for userId: " + userId + ", companyProfileId: " + companyProfileId));
            return false;
        }
        if (this.dao.removeCompanyProfile(companyProfile)) {
            log.info((Object)("User: " + userId + " removed company profile: " + companyProfileId));
            return true;
        }
        return false;
    }

    public SocialNetworkingInfo getSocialNetworkingInfo(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogic.getSocialNetworkingInfo");
        }
        SocialNetworkingInfo socialNetworkingInfo = this.dao.getSocialNetworkingInfo(userId);
        if (null == socialNetworkingInfo) {
            socialNetworkingInfo = new SocialNetworkingInfo(userId);
        }
        return socialNetworkingInfo;
    }

    public boolean saveSocialNetworkingInfo(SocialNetworkingInfo socialNetworkingInfo) {
        if (this.dao.saveSocialNetworkingInfo(socialNetworkingInfo)) {
            log.info((Object)("Updated social networking info for user: " + socialNetworkingInfo.getUserUuid()));
            return true;
        }
        return false;
    }

    public BasicPerson getBasicPerson(String userUuid) {
        return this.getBasicPerson(this.sakaiProxy.getUserById(userUuid));
    }

    public BasicPerson getBasicPerson(User user) {
        BasicPerson p = new BasicPerson();
        p.setUuid(user.getId());
        p.setDisplayName(user.getDisplayName());
        p.setType(user.getType());
        return p;
    }

    public List<BasicPerson> getBasicPersons(List<User> users) {
        ArrayList<BasicPerson> list = new ArrayList<BasicPerson>();
        for (User u : users) {
            list.add(this.getBasicPerson(u));
        }
        return list;
    }

    public Person getPerson(String userUuid) {
        return this.getPerson(this.sakaiProxy.getUserById(userUuid));
    }

    public Person getPerson(User user) {
        if (user == null) {
            return null;
        }
        Person p = new Person();
        String userUuid = user.getId();
        p.setUuid(userUuid);
        p.setDisplayName(user.getDisplayName());
        p.setType(user.getType());
        p.setPreferences(this.preferencesLogic.getPreferencesRecordForUser(userUuid));
        p.setPrivacy(this.privacyLogic.getPrivacyRecordForUser(userUuid));
        p.setProfile(this.getUserProfile(userUuid));
        return p;
    }

    public List<Person> getPersons(List<User> users) {
        ArrayList<Person> list = new ArrayList<Person>();
        for (User u : users) {
            list.add(this.getPerson(u));
        }
        return list;
    }

    public List<String> getAllSakaiPersonIds() {
        return this.dao.getAllSakaiPersonIds();
    }

    public int getAllSakaiPersonIdsCount() {
        return this.dao.getAllSakaiPersonIdsCount();
    }

    public void init() {
        log.info((Object)"Profile2: init()");
        if (this.sakaiProxy.isProfileConversionEnabled()) {
            this.converter.convertProfileImages();
        }
        if (this.sakaiProxy.isProfileImportEnabled()) {
            String csv = this.sakaiProxy.getProfileImportCsvPath();
            this.converter.importProfiles(csv);
        }
    }

    private UserProfile transformSakaiPersonToUserProfile(UserProfile p, SakaiPerson sp) {
        p.setNickname(sp.getNickname());
        p.setDateOfBirth(sp.getDateOfBirth());
        p.setPersonalSummary(sp.getNotes());
        p.setHomepage(sp.getLabeledURI());
        p.setWorkphone(sp.getTelephoneNumber());
        p.setHomephone(sp.getHomePhone());
        p.setMobilephone(sp.getMobile());
        p.setFacsimile(sp.getFacsimileTelephoneNumber());
        p.setDepartment(sp.getOrganizationalUnit());
        p.setPosition(sp.getTitle());
        p.setSchool(sp.getCampus());
        p.setRoom(sp.getRoomNumber());
        p.setStaffProfile(sp.getStaffProfile());
        p.setAcademicProfileUrl(sp.getAcademicProfileUrl());
        p.setUniversityProfileUrl(sp.getUniversityProfileUrl());
        p.setPublications(sp.getPublications());
        p.setCourse(sp.getEducationCourse());
        p.setSubjects(sp.getEducationSubjects());
        p.setFavouriteBooks(sp.getFavouriteBooks());
        p.setFavouriteTvShows(sp.getFavouriteTvShows());
        p.setFavouriteMovies(sp.getFavouriteMovies());
        p.setFavouriteQuotes(sp.getFavouriteQuotes());
        p.setBusinessBiography(sp.getBusinessBiography());
        return p;
    }

    private void sendProfileChangeEmailNotification(String userUuid) {
        boolean enabled = Boolean.valueOf(this.sakaiProxy.getServerConfigurationParameter("profile2.profile.change.email.enabled", "false"));
        if (!enabled) {
            return;
        }
        String eidTo = this.sakaiProxy.getServerConfigurationParameter("profile2.profile.change.email.eid", null);
        if (StringUtils.isBlank((String)eidTo)) {
            log.error((Object)"Profile change email notification is enabled but no user eid to send it to is set. Please set 'profile2.profile.change.email.eid' in sakai.properties");
            return;
        }
        String userUuidTo = this.sakaiProxy.getUserIdForEid(eidTo);
        if (StringUtils.isBlank((String)userUuidTo)) {
            log.error((Object)"Profile change email notification is setup with an invalid eid. Please adjust 'profile2.profile.change.email.eid' in sakai.properties");
            return;
        }
        String emailTemplateKey = "profile2.profileChangeNotification";
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("userDisplayName", this.sakaiProxy.getUserDisplayName(userUuid));
        replacementValues.put("localSakaiName", this.sakaiProxy.getServiceName());
        replacementValues.put("profileLink", this.linkLogic.getEntityLinkToProfileHome(userUuid));
        replacementValues.put("localSakaiUrl", this.sakaiProxy.getPortalUrl());
        this.sakaiProxy.sendEmail(userUuidTo, emailTemplateKey, replacementValues);
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setPreferencesLogic(ProfilePreferencesLogic preferencesLogic) {
        this.preferencesLogic = preferencesLogic;
    }

    public void setStatusLogic(ProfileStatusLogic statusLogic) {
        this.statusLogic = statusLogic;
    }

    public void setPrivacyLogic(ProfilePrivacyLogic privacyLogic) {
        this.privacyLogic = privacyLogic;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }

    public void setImageLogic(ProfileImageLogic imageLogic) {
        this.imageLogic = imageLogic;
    }

    public void setConverter(ProfileConverter converter) {
        this.converter = converter;
    }

    public void setLinkLogic(ProfileLinkLogic linkLogic) {
        this.linkLogic = linkLogic;
    }
}

