/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.lang.reflect.Method;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.cover.SessionManager;

public class EditorConfiguration {
    public static final String ATTR_ENABLE_RESOURCE_SEARCH = "org.sakaiproject.util.EditorConfiguration.enableResourceSearch";

    public static String getWysiwigEditor() {
        return ServerConfigurationService.getString((String)"wysiwyg.editor");
    }

    public static boolean enableResourceSearch() {
        Session session = SessionManager.getCurrentSession();
        Boolean showCitationsButton = (Boolean)session.getAttribute(ATTR_ENABLE_RESOURCE_SEARCH);
        if (showCitationsButton == null) {
            Object component = ComponentManager.get((String)"org.sakaiproject.citation.api.ConfigurationService");
            if (component == null) {
                showCitationsButton = Boolean.FALSE;
            } else {
                try {
                    Method method = component.getClass().getMethod("librarySearchEnabled", new Class[0]);
                    if (method == null) {
                        showCitationsButton = Boolean.FALSE;
                    } else {
                        showCitationsButton = (Boolean)method.invoke(component, null);
                        session.setAttribute(ATTR_ENABLE_RESOURCE_SEARCH, (Object)showCitationsButton);
                    }
                }
                catch (Exception e) {
                    showCitationsButton = Boolean.FALSE;
                }
            }
        }
        return showCitationsButton;
    }
}

