/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.ParseUtil;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class StatusStreamImpl
implements StatusStream {
    private static final Logger logger = Logger.getLogger(StatusStreamImpl.class);
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;

    StatusStreamImpl(InputStream stream) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
    }

    StatusStreamImpl(HttpResponse response) throws IOException {
        this(response.asStream());
        this.response = response;
    }

    public void next(StatusListener listener) throws TwitterException {
        block13: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.br.readLine();
                if (null == line) {
                    throw new IOException("the end of the stream has been reached");
                }
                if (line.length() <= 0) break block13;
                logger.debug("received:", line);
                try {
                    JSONObject json = new JSONObject(line);
                    if (!json.isNull("text")) {
                        listener.onStatus(new StatusJSONImpl(json));
                    } else if (!json.isNull("delete")) {
                        listener.onDeletionNotice(new StatusDeletionNoticeImpl(json));
                    } else if (!json.isNull("limit")) {
                        listener.onTrackLimitationNotice(ParseUtil.getInt("track", json.getJSONObject("limit")));
                    }
                }
                catch (JSONException jsone) {
                    listener.onException(jsone);
                }
            }
            catch (IOException ioe) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.streamAlive = false;
                throw new TwitterException("Stream closed.", ioe);
            }
        }
    }

    public void close() throws IOException {
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }
}

