/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.entity;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.api.common.edu.person.SakaiPersonManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.user.api.User;

public class ProfileContentProducer
implements EntityContentProducer {
    private ProfileLogic profileLogic = null;
    private SearchService searchService = null;
    private SearchIndexBuilder searchIndexBuilder = null;
    private SakaiProxy sakaiProxy = null;
    private SakaiPersonManager sakaiPersonManager = null;
    private Logger logger = Logger.getLogger(ProfileContentProducer.class);

    public void init() {
        this.searchService.registerFunction("profile.info.update");
        this.searchIndexBuilder.registerEntityContentProducer((EntityContentProducer)this);
    }

    public boolean canRead(String reference) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"canRead()");
        }
        return true;
    }

    public Integer getAction(Event event) {
        String eventName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getAction()");
        }
        if ("profile.info.update".equals(eventName = event.getEvent())) {
            return SearchBuilderItem.ACTION_ADD;
        }
        return SearchBuilderItem.ACTION_UNKNOWN;
    }

    public String getContainer(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getContainer()");
        }
        return null;
    }

    public String getContent(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getContent(" + ref + ")"));
        }
        String[] parts = ref.split("/");
        String type = parts[1];
        String id = parts[2];
        if ("profile".equals(type)) {
            try {
                SakaiPerson sp = this.sakaiPersonManager.getSakaiPerson(id, this.sakaiPersonManager.getUserMutableType());
                String notes = "";
                if (sp != null) {
                    notes = sp.getNotes();
                }
                return notes;
            }
            catch (Exception e) {
                this.logger.error((Object)("Caught exception whilst getting content for profile '" + id + "'"), (Throwable)e);
            }
        }
        return null;
    }

    public Reader getContentReader(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getContentReader(" + ref + ")"));
        }
        return null;
    }

    public Map getCustomProperties(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getCustomProperties(" + ref + ")"));
        }
        return null;
    }

    public String getCustomRDF(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getCustomRDF(" + ref + ")"));
        }
        return null;
    }

    public String getId(String ref) {
        String[] parts;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getId(" + ref + ")"));
        }
        if ((parts = ref.split("/")).length == 3) {
            return parts[2];
        }
        return "unknown";
    }

    public List getSiteContent(String siteId) {
        String uuid;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getSiteContent(" + siteId + ")"));
        }
        ArrayList<String> refs = new ArrayList<String>();
        if (siteId.startsWith("~") && siteId.length() == 37 && (uuid = siteId.substring(1)) != null) {
            refs.add("/profile/" + uuid);
        }
        return refs;
    }

    public Iterator getSiteContentIterator(String siteId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getSiteContentIterator(" + siteId + ")"));
        }
        return this.getSiteContent(siteId).iterator();
    }

    public String getSiteId(String eventRef) {
        String[] parts;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getSiteId(" + eventRef + ")"));
        }
        if ((parts = eventRef.split("/")).length == 3) {
            String id = "~" + parts[2];
            return id;
        }
        return null;
    }

    public String getSubType(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getSubType(" + ref + ")"));
        }
        return null;
    }

    public String getTitle(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getTitle(" + ref + ")"));
        }
        String[] parts = ref.split("/");
        String type = parts[1];
        String id = parts[2];
        if ("profile".equals(type)) {
            try {
                User user = this.sakaiProxy.getUserById(id);
                return user.getDisplayName();
            }
            catch (Exception e) {
                this.logger.error((Object)("Caught exception whilst getting user display name for id '" + id + "'"), (Throwable)e);
            }
        }
        return "Unrecognised";
    }

    public String getTool() {
        return "Profile";
    }

    public String getType(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getType(" + ref + ")"));
        }
        return "profile";
    }

    public String getUrl(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getUrl(" + ref + ")"));
        }
        String[] parts = ref.split("/");
        String type = parts[1];
        String id = parts[2];
        return null;
    }

    public boolean isContentFromReader(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("isContentFromReader(" + ref + ")"));
        }
        return false;
    }

    public boolean isForIndex(String ref) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("isForIndex(" + ref + ")"));
        }
        return true;
    }

    public boolean matches(String ref) {
        String[] parts;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("matches(" + ref + ")"));
        }
        return "profile".equals((parts = ref.split("/"))[1]);
    }

    public boolean matches(Event event) {
        String eventName = event.getEvent();
        return "profile.info.update".equals(eventName);
    }

    public void setProfileLogic(ProfileLogic profileLogic) {
        this.profileLogic = profileLogic;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setSakaiPersonManager(SakaiPersonManager sakaiPersonManager) {
        this.sakaiPersonManager = sakaiPersonManager;
    }
}

