/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.logic.ProfileExternalIntegrationLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ExternalIntegrationInfo;
import org.sakaiproject.profile2.util.ProfileUtils;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.http.AccessToken;

public class ProfileExternalIntegrationLogicImpl
implements ProfileExternalIntegrationLogic {
    private static final Logger log = Logger.getLogger(ProfileExternalIntegrationLogicImpl.class);
    @Deprecated
    private final String TWITTER_OAUTH_CONSUMER_KEY = "XzSPZIj0LxNaaoBz8XrgZQ";
    @Deprecated
    private final String TWITTER_OAUTH_CONSUMER_SECRET = "FSChsnmTufYi3X9H25YdFRxBhPXgnh2H0lMnLh7ZVG4";
    private ProfileDao dao;
    private SakaiProxy sakaiProxy;

    public ExternalIntegrationInfo getExternalIntegrationInfo(String userUuid) {
        ExternalIntegrationInfo info = this.dao.getExternalIntegrationInfo(userUuid);
        if (info != null) {
            return info;
        }
        return this.getDefaultExternalIntegrationInfo(userUuid);
    }

    public boolean updateExternalIntegrationInfo(ExternalIntegrationInfo info) {
        if (this.dao.updateExternalIntegrationInfo(info)) {
            log.info((Object)("ExternalIntegrationInfo updated for user: " + info.getUserUuid()));
            return true;
        }
        return false;
    }

    public Map<String, String> getTwitterOAuthConsumerDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", this.sakaiProxy.getServerConfigurationParameter("profile2.twitter.oauth.key", "XzSPZIj0LxNaaoBz8XrgZQ"));
        map.put("secret", this.sakaiProxy.getServerConfigurationParameter("profile2.twitter.oauth.secret", "FSChsnmTufYi3X9H25YdFRxBhPXgnh2H0lMnLh7ZVG4"));
        return map;
    }

    public String getTwitterName(ExternalIntegrationInfo info) {
        if (info == null) {
            return null;
        }
        String token = info.getTwitterToken();
        String secret = info.getTwitterSecret();
        if (StringUtils.isNotBlank((String)token) && StringUtils.isNotBlank((String)secret)) {
            Map<String, String> config = this.getTwitterOAuthConsumerDetails();
            AccessToken accessToken = new AccessToken(token, secret);
            Twitter twitter = new TwitterFactory().getOAuthAuthorizedInstance(config.get("key"), config.get("secret"), accessToken);
            try {
                return twitter.verifyCredentials().getScreenName();
            }
            catch (TwitterException e) {
                log.error((Object)("Error retrieving Twitter credentials: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            }
        }
        return null;
    }

    public boolean validateTwitterCredentials(ExternalIntegrationInfo info) {
        return StringUtils.isNotBlank((String)this.getTwitterName(info));
    }

    public void sendMessageToTwitter(String userUuid, String message) {
        if (!this.sakaiProxy.isTwitterIntegrationEnabledGlobally()) {
            return;
        }
        ExternalIntegrationInfo info = this.getExternalIntegrationInfo(userUuid);
        String token = info.getTwitterToken();
        String secret = info.getTwitterSecret();
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)secret)) {
            return;
        }
        message = ProfileUtils.truncate((String)message, (int)140, (boolean)false);
        class TwitterUpdater
        implements Runnable {
            private Thread runner;
            private String userUuid;
            private String userToken;
            private String userSecret;
            private String message;

            public TwitterUpdater(String userUuid, String userToken, String userSecret, String message) {
                this.userUuid = userUuid;
                this.userToken = userToken;
                this.userSecret = userSecret;
                this.message = message;
                this.runner = new Thread((Runnable)this, "Profile2 TwitterUpdater thread");
                this.runner.start();
            }

            @Override
            public synchronized void run() {
                Map<String, String> config = ProfileExternalIntegrationLogicImpl.this.getTwitterOAuthConsumerDetails();
                AccessToken accessToken = new AccessToken(this.userToken, this.userSecret);
                Twitter twitter = new TwitterFactory().getOAuthAuthorizedInstance(config.get("key"), config.get("secret"), accessToken);
                try {
                    twitter.updateStatus(this.message);
                    log.info((Object)("Twitter status updated for: " + this.userUuid));
                    ProfileExternalIntegrationLogicImpl.this.sakaiProxy.postEvent("profile.twitter.update", "/profile/" + this.userUuid, true);
                }
                catch (TwitterException e) {
                    log.error((Object)("ProfileLogic.sendMessageToTwitter() failed. " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
                }
            }
        }
        new TwitterUpdater(userUuid, token, secret, message);
    }

    public String getGoogleAuthenticationUrl() {
        String clientId = this.sakaiProxy.getServerConfigurationParameter("profile2.integration.google.client-id", null);
        if (StringUtils.isBlank((String)clientId)) {
            log.error((Object)"Google integration not properly configured. Please set the client id");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://accounts.google.com/o/oauth2/auth?");
        sb.append("client_id=");
        sb.append(clientId);
        sb.append("&redirect_uri=");
        sb.append("urn:ietf:wg:oauth:2.0:oob");
        sb.append("&response_type=code");
        sb.append("&scope=");
        sb.append("https://docs.google.com/feeds/");
        return sb.toString();
    }

    private ExternalIntegrationInfo getDefaultExternalIntegrationInfo(String userUuid) {
        ExternalIntegrationInfo info = new ExternalIntegrationInfo();
        info.setUserUuid(userUuid);
        return info;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }
}

