/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.ProfileStatusLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.model.ProfileStatus;
import org.sakaiproject.profile2.types.PrivacyType;
import org.sakaiproject.profile2.util.ProfileUtils;

public class ProfileStatusLogicImpl
implements ProfileStatusLogic {
    private static final Logger log = Logger.getLogger(ProfileStatusLogicImpl.class);
    private SakaiProxy sakaiProxy;
    private ProfilePrivacyLogic privacyLogic;
    private ProfileConnectionsLogic connectionsLogic;
    private ProfileDao dao;

    public ProfileStatus getUserStatus(String userUuid, ProfilePrivacy privacy) {
        if (privacy == null) {
            return null;
        }
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (!StringUtils.equals((String)userUuid, (String)currentUserUuid) && !this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_MYSTATUS)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(6, -7);
        Date oldestStatusDate = cal.getTime();
        ProfileStatus status = this.dao.getUserStatus(userUuid, oldestStatusDate);
        if (status == null) {
            return null;
        }
        if (status.getDateAdded() != null) {
            status.setDateFormatted(ProfileUtils.convertDateForStatus((Date)status.getDateAdded()));
        }
        return status;
    }

    public ProfileStatus getUserStatus(String userUuid) {
        return this.getUserStatus(userUuid, this.privacyLogic.getPrivacyRecordForUser(userUuid));
    }

    public boolean setUserStatus(String userId, String status) {
        ProfileStatus profileStatus = new ProfileStatus(userId, status, new Date());
        return this.setUserStatus(profileStatus);
    }

    public boolean setUserStatus(ProfileStatus profileStatus) {
        if (!StringUtils.equals((String)this.sakaiProxy.getCurrentUserId(), (String)profileStatus.getUserUuid())) {
            throw new SecurityException("You are not authorised to perform that action.");
        }
        String tMessage = ProfileUtils.truncate((String)profileStatus.getMessage(), (int)255, (boolean)false);
        profileStatus.setMessage(tMessage);
        if (this.dao.setUserStatus(profileStatus)) {
            log.info((Object)("Updated status for user: " + profileStatus.getUserUuid()));
            return true;
        }
        return false;
    }

    public boolean clearUserStatus(String userId) {
        ProfileStatus profileStatus = this.getUserStatus(userId);
        if (profileStatus == null) {
            log.error((Object)("ProfileStatus null for userId: " + userId));
            return false;
        }
        if (!StringUtils.equals((String)this.sakaiProxy.getCurrentUserId(), (String)profileStatus.getUserUuid())) {
            throw new SecurityException("You are not authorised to perform that action.");
        }
        if (this.dao.clearUserStatus(profileStatus)) {
            log.info((Object)("User: " + userId + " cleared status"));
            return true;
        }
        return false;
    }

    public int getStatusUpdatesCount(String userUuid) {
        return this.dao.getStatusUpdatesCount(userUuid);
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setPrivacyLogic(ProfilePrivacyLogic privacyLogic) {
        this.privacyLogic = privacyLogic;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }
}

