/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import twitter4j.PagableResponseList;
import twitter4j.ParseUtil;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserList;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserListJSONImpl
extends TwitterResponseImpl
implements UserList,
Serializable {
    private int id;
    private String name;
    private String fullName;
    private String slug;
    private String description;
    private int subscriberCount;
    private int memberCount;
    private String uri;
    private boolean mode;
    private User user;
    private static final long serialVersionUID = -6345893237975349030L;

    UserListJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        this.init(res.asJSONObject());
    }

    UserListJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = ParseUtil.getInt("id", json);
        this.name = ParseUtil.getRawString("name", json);
        this.fullName = ParseUtil.getRawString("full_name", json);
        this.slug = ParseUtil.getRawString("slug", json);
        this.description = ParseUtil.getRawString("description", json);
        this.subscriberCount = ParseUtil.getInt("subscriber_count", json);
        this.memberCount = ParseUtil.getInt("member_count", json);
        this.uri = ParseUtil.getRawString("uri", json);
        this.mode = "public".equals(ParseUtil.getRawString("mode", json));
        try {
            if (!json.isNull("user")) {
                this.user = new UserJSONImpl(json.getJSONObject("user"));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(json.toString()).toString(), jsone);
        }
    }

    @Override
    public int compareTo(UserList that) {
        return this.id - that.getId();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getSubscriberCount() {
        return this.subscriberCount;
    }

    @Override
    public int getMemberCount() {
        return this.memberCount;
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.uri);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    @Override
    public boolean isPublic() {
        return this.mode;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    static PagableResponseList<UserList> createUserListList(HttpResponse res) throws TwitterException {
        try {
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("lists");
            int size = list.length();
            PagableResponseList<UserList> users = new PagableResponseList<UserList>(size, json, res);
            for (int i = 0; i < size; ++i) {
                users.add(new UserListJSONImpl(list.getJSONObject(i)));
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof UserList && ((UserList)obj).getId() == this.id;
    }

    public String toString() {
        return new StringBuffer().append("UserListJSONImpl{id=").append(this.id).append(", name='").append(this.name).append('\'').append(", fullName='").append(this.fullName).append('\'').append(", slug='").append(this.slug).append('\'').append(", description='").append(this.description).append('\'').append(", subscriberCount=").append(this.subscriberCount).append(", memberCount=").append(this.memberCount).append(", uri='").append(this.uri).append('\'').append(", mode='").append(this.mode).append('\'').append(", user=").append(this.user).append('}').toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((UserList)x0);
    }
}

