/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.profile2.cache.CacheManager;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileSearchLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.BasicConnection;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.model.ProfileSearchTerm;
import org.sakaiproject.profile2.util.ProfileUtils;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.user.api.User;

public class ProfileSearchLogicImpl
implements ProfileSearchLogic {
    private static final Logger log = Logger.getLogger(ProfileSearchLogicImpl.class);
    private Cache cache;
    private final String CACHE_NAME = "org.sakaiproject.profile2.cache.search";
    private SakaiProxy sakaiProxy;
    private ProfileDao dao;
    private ProfileLogic profileLogic;
    private ProfileConnectionsLogic connectionsLogic;
    private CacheManager cacheManager;

    public List<Person> findUsersByNameOrEmail(String search, boolean includeConnections, String worksiteId) {
        List<String> sakaiPersonUuids = this.dao.findSakaiPersonsByNameOrEmail(search);
        List<User> users = this.sakaiProxy.getUsers(sakaiPersonUuids);
        users.addAll(this.sakaiProxy.searchUsers(search));
        users.addAll(this.sakaiProxy.searchExternalUsers(search));
        ProfileUtils.removeDuplicates((List)users);
        if (!includeConnections) {
            this.removeConnectionsFromUsers(users);
        }
        if (null != worksiteId) {
            users = this.removeNonWorksiteMembersFromUsers(users, worksiteId);
        }
        log.debug((Object)("Found " + users.size() + " results for search: " + search));
        int maxResults = this.sakaiProxy.getMaxSearchResults();
        if (users.size() >= maxResults) {
            users = users.subList(0, maxResults);
        }
        users = this.removeInvisibleUsers(users);
        return this.profileLogic.getPersons(users);
    }

    public List<Person> findUsersByInterest(String search, boolean includeConnections, String worksiteId) {
        List<String> sakaiPersonUuids = this.dao.findSakaiPersonsByInterest(search, this.sakaiProxy.isBusinessProfileEnabled());
        if (!includeConnections) {
            this.removeConnectionsFromUserIds(sakaiPersonUuids);
        }
        if (null != worksiteId) {
            sakaiPersonUuids = this.removeNonWorksiteMembersFromUserIds(sakaiPersonUuids, worksiteId);
        }
        List<Object> users = this.sakaiProxy.getUsers(sakaiPersonUuids);
        int maxResults = this.sakaiProxy.getMaxSearchResults();
        if (users.size() >= maxResults) {
            users = users.subList(0, maxResults);
        }
        users = this.removeInvisibleUsers(users);
        return this.profileLogic.getPersons(users);
    }

    public ProfileSearchTerm getLastSearchTerm(String userUuid) {
        List<ProfileSearchTerm> searchHistory = this.getSearchHistory(userUuid);
        if (null != searchHistory && searchHistory.size() > 0) {
            return searchHistory.get(searchHistory.size() - 1);
        }
        return null;
    }

    public List<ProfileSearchTerm> getSearchHistory(String userUuid) {
        if (this.cache.containsKey((Object)userUuid)) {
            ArrayList<ProfileSearchTerm> searchHistory = new ArrayList<ProfileSearchTerm>(((Map)this.cache.get((Object)userUuid)).values());
            Collections.sort(searchHistory);
            return searchHistory;
        }
        return null;
    }

    public void addSearchTermToHistory(String userUuid, ProfileSearchTerm searchTerm) {
        if (null == searchTerm) {
            throw new IllegalArgumentException("search term cannot be null");
        }
        if (null == searchTerm.getUserUuid()) {
            throw new IllegalArgumentException("search term must contain UUID of user");
        }
        if (!userUuid.equals(searchTerm.getUserUuid())) {
            throw new IllegalArgumentException("userUuid must match search term userUuid");
        }
        HashMap searchHistory = false == this.cache.containsKey((Object)searchTerm.getUserUuid()) ? new HashMap() : (HashMap)this.cache.get((Object)searchTerm.getUserUuid());
        searchHistory.remove(searchTerm.getSearchTerm());
        if (searchHistory.size() == 5) {
            searchHistory.remove(this.getSearchHistory(userUuid).get(0).getSearchTerm());
        }
        searchHistory.put(searchTerm.getSearchTerm(), searchTerm);
        this.cache.put((Object)searchTerm.getUserUuid(), (Object)searchHistory);
    }

    public void clearSearchHistory(String userUuid) {
        if (this.cache.containsKey((Object)userUuid)) {
            this.cache.remove((Object)userUuid);
        } else {
            log.warn((Object)("unable to clear search history; uuid not found: " + userUuid));
        }
    }

    private List<User> removeInvisibleUsers(List<User> users) {
        if (this.sakaiProxy.isSuperUser()) {
            return users;
        }
        List invisibleUsers = this.sakaiProxy.getUsers(this.sakaiProxy.getInvisibleUsers());
        if (invisibleUsers.isEmpty()) {
            return users;
        }
        users.removeAll(invisibleUsers);
        return users;
    }

    private void removeConnectionsFromUsers(List<User> users) {
        List connections = this.connectionsLogic.getBasicConnectionsForUser(this.sakaiProxy.getCurrentUserId());
        block0: for (BasicConnection connection : connections) {
            for (User user : users) {
                if (!user.getId().equals(connection.getUuid())) continue;
                users.remove(user);
                continue block0;
            }
        }
    }

    private void removeConnectionsFromUserIds(List<String> userIds) {
        List connections = this.connectionsLogic.getBasicConnectionsForUser(this.sakaiProxy.getCurrentUserId());
        for (BasicConnection connection : connections) {
            if (!userIds.contains(connection.getUuid())) continue;
            userIds.remove(connection.getUuid());
        }
    }

    private List<User> removeNonWorksiteMembersFromUsers(List<User> users, String worksiteId) {
        ArrayList<User> worksiteMembers = new ArrayList<User>();
        Site site = this.sakaiProxy.getSite(worksiteId);
        if (null == site) {
            log.error((Object)("Unable to receive worksite with id: " + worksiteId));
        } else {
            Set members = this.sakaiProxy.getSite(worksiteId).getMembers();
            block0: for (Member member : members) {
                for (User user : users) {
                    if (!user.getId().equals(member.getUserId())) continue;
                    worksiteMembers.add(user);
                    continue block0;
                }
            }
        }
        return worksiteMembers;
    }

    private List<String> removeNonWorksiteMembersFromUserIds(List<String> userIds, String worksiteId) {
        ArrayList<String> worksiteMemberIds = new ArrayList<String>();
        Site site = this.sakaiProxy.getSite(worksiteId);
        if (null == site) {
            log.error((Object)("Unable to receive worksite with id: " + worksiteId));
        } else {
            Set members = this.sakaiProxy.getSite(worksiteId).getMembers();
            block0: for (Member member : members) {
                for (String userId : userIds) {
                    if (!userId.equals(member.getUserId())) continue;
                    worksiteMemberIds.add(userId);
                    continue block0;
                }
            }
        }
        return worksiteMemberIds;
    }

    public void init() {
        this.cache = this.cacheManager.createCache("org.sakaiproject.profile2.cache.search");
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setProfileLogic(ProfileLogic profileLogic) {
        this.profileLogic = profileLogic;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

