/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.api.common.edu.person.SakaiPersonManager;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.emailtemplateservice.model.RenderedTemplate;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.event.api.ActivityService;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.MimeTypeByteArray;
import org.sakaiproject.profile2.util.ProfileUtils;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.Validator;

public class SakaiProxyImpl
implements SakaiProxy {
    private static final Logger log = Logger.getLogger(SakaiProxyImpl.class);
    private ToolManager toolManager;
    private SecurityService securityService;
    private SessionManager sessionManager;
    private SiteService siteService;
    private UserDirectoryService userDirectoryService;
    private SakaiPersonManager sakaiPersonManager;
    private ContentHostingService contentHostingService;
    private EventTrackingService eventTrackingService;
    private EmailService emailService;
    private ServerConfigurationService serverConfigurationService;
    private EmailTemplateService emailTemplateService;
    private IdManager idManager;
    private ActivityService activityService;
    private ArrayList<String> emailTemplates;

    public String getCurrentSiteId() {
        return this.toolManager.getCurrentPlacement().getContext();
    }

    public String getCurrentUserId() {
        return this.sessionManager.getCurrentSessionUserId();
    }

    public User getCurrentUser() {
        return this.userDirectoryService.getCurrentUser();
    }

    public String getUserEid(String userId) {
        String eid = null;
        try {
            eid = this.userDirectoryService.getUser(userId).getEid();
        }
        catch (UserNotDefinedException e) {
            log.warn((Object)("Cannot get eid for id: " + userId + " : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return eid;
    }

    public String getUserIdForEid(String eid) {
        String userUuid = null;
        try {
            userUuid = this.userDirectoryService.getUserByEid(eid).getId();
        }
        catch (UserNotDefinedException e) {
            log.warn((Object)("Cannot get id for eid: " + eid + " : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return userUuid;
    }

    public String getUserDisplayName(String userId) {
        String name = null;
        try {
            name = this.userDirectoryService.getUser(userId).getDisplayName();
        }
        catch (UserNotDefinedException e) {
            log.warn((Object)("Cannot get displayname for id: " + userId + " : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return name;
    }

    public String getUserFirstName(String userId) {
        String email = null;
        try {
            email = this.userDirectoryService.getUser(userId).getFirstName();
        }
        catch (UserNotDefinedException e) {
            log.warn((Object)("Cannot get first name for id: " + userId + " : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return email;
    }

    public String getUserLastName(String userId) {
        String email = null;
        try {
            email = this.userDirectoryService.getUser(userId).getLastName();
        }
        catch (UserNotDefinedException e) {
            log.warn((Object)("Cannot get last name for id: " + userId + " : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return email;
    }

    public String getUserEmail(String userId) {
        String email = null;
        try {
            email = this.userDirectoryService.getUser(userId).getEmail();
        }
        catch (UserNotDefinedException e) {
            log.warn((Object)("Cannot get email for id: " + userId + " : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return email;
    }

    public boolean checkForUser(String userId) {
        User u = null;
        try {
            u = this.userDirectoryService.getUser(userId);
            if (u != null) {
                return true;
            }
        }
        catch (UserNotDefinedException e) {
            log.info((Object)("User with id: " + userId + " does not exist : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return false;
    }

    public boolean checkForUserByEid(String eid) {
        User u = null;
        try {
            u = this.userDirectoryService.getUserByEid(eid);
            if (u != null) {
                return true;
            }
        }
        catch (UserNotDefinedException e) {
            log.info((Object)("User with eid: " + eid + " does not exist : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return false;
    }

    public boolean isSuperUser() {
        return this.securityService.isSuperUser();
    }

    public boolean isAdminUser() {
        return StringUtils.equals((String)this.sessionManager.getCurrentSessionUserId(), (String)"admin");
    }

    public boolean isSuperUserAndProxiedToUser(String userId) {
        return this.isSuperUser() && !StringUtils.equals((String)userId, (String)this.getCurrentUserId());
    }

    public String getUserType(String userId) {
        String type = null;
        try {
            type = this.userDirectoryService.getUser(userId).getType();
        }
        catch (UserNotDefinedException e) {
            log.info((Object)("User with eid: " + userId + " does not exist : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return type;
    }

    public User getUserById(String userId) {
        User u = null;
        try {
            u = this.userDirectoryService.getUser(userId);
        }
        catch (UserNotDefinedException e) {
            log.info((Object)("User with id: " + userId + " does not exist : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
        }
        return u;
    }

    public User getUserQuietly(String userId) {
        User u = null;
        try {
            u = this.userDirectoryService.getUser(userId);
        }
        catch (UserNotDefinedException userNotDefinedException) {
            // empty catch block
        }
        return u;
    }

    public String getCurrentToolTitle() {
        Tool tool = this.toolManager.getCurrentTool();
        if (tool != null) {
            return tool.getTitle();
        }
        return "Profile";
    }

    public List<User> getUsers(List<String> userIds) {
        return this.userDirectoryService.getUsers(userIds);
    }

    public List<String> getUuids(List<User> users) {
        ArrayList<String> uuids = new ArrayList<String>();
        for (User u : users) {
            uuids.add(u.getId());
        }
        return uuids;
    }

    public SakaiPerson getSakaiPerson(String userId) {
        SakaiPerson sakaiPerson = null;
        try {
            sakaiPerson = this.sakaiPersonManager.getSakaiPerson(userId, this.sakaiPersonManager.getUserMutableType());
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.getSakaiPerson(): Couldn't get SakaiPerson for: " + userId + " : " + e.getClass() + " : " + e.getMessage()));
        }
        return sakaiPerson;
    }

    public byte[] getSakaiPersonJpegPhoto(String userId) {
        SakaiPerson sakaiPerson = null;
        byte[] image = null;
        try {
            sakaiPerson = this.sakaiPersonManager.getSakaiPerson(userId, this.sakaiPersonManager.getUserMutableType());
            if (sakaiPerson != null) {
                image = sakaiPerson.getJpegPhoto();
            }
            if (image == null && (sakaiPerson = this.sakaiPersonManager.getSakaiPerson(userId, this.sakaiPersonManager.getSystemMutableType())) != null) {
                image = sakaiPerson.getJpegPhoto();
            }
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.getSakaiPersonJpegPhoto(): Couldn't get SakaiPerson Jpeg photo for: " + userId + " : " + e.getClass() + " : " + e.getMessage()));
        }
        return image;
    }

    public String getSakaiPersonImageUrl(String userId) {
        SakaiPerson sakaiPerson = null;
        String url = null;
        try {
            sakaiPerson = this.sakaiPersonManager.getSakaiPerson(userId, this.sakaiPersonManager.getUserMutableType());
            if (sakaiPerson != null) {
                url = sakaiPerson.getPictureUrl();
            }
            if (StringUtils.isBlank(url) && (sakaiPerson = this.sakaiPersonManager.getSakaiPerson(userId, this.sakaiPersonManager.getSystemMutableType())) != null) {
                url = sakaiPerson.getPictureUrl();
            }
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.getSakaiPersonImageUrl(): Couldn't get SakaiPerson image URL for: " + userId + " : " + e.getClass() + " : " + e.getMessage()));
        }
        return url;
    }

    public SakaiPerson getSakaiPersonPrototype() {
        SakaiPerson sakaiPerson = null;
        try {
            sakaiPerson = this.sakaiPersonManager.getPrototype();
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.getSakaiPersonPrototype(): Couldn't get SakaiPerson prototype: " + e.getClass() + " : " + e.getMessage()));
        }
        return sakaiPerson;
    }

    public SakaiPerson createSakaiPerson(String userId) {
        SakaiPerson sakaiPerson = null;
        try {
            sakaiPerson = this.sakaiPersonManager.create(userId, this.sakaiPersonManager.getUserMutableType());
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.createSakaiPerson(): Couldn't create SakaiPerson: " + e.getClass() + " : " + e.getMessage()));
        }
        return sakaiPerson;
    }

    public boolean updateSakaiPerson(SakaiPerson sakaiPerson) {
        try {
            this.sakaiPersonManager.save(sakaiPerson);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.updateSakaiPerson(): Couldn't update SakaiPerson: " + e.getClass() + " : " + e.getMessage()));
            e.printStackTrace();
            return false;
        }
    }

    public int getMaxProfilePictureSize() {
        return this.serverConfigurationService.getInt("profile2.picture.max", 2);
    }

    private String getProfileGalleryPath(String userId) {
        String slash = "/";
        StringBuilder path = new StringBuilder();
        path.append(slash);
        path.append("private");
        path.append(slash);
        path.append("profileGallery");
        path.append(slash);
        path.append(userId);
        path.append(slash);
        return path.toString();
    }

    public String getProfileGalleryImagePath(String userId, String imageId) {
        StringBuilder path = new StringBuilder(this.getProfileGalleryPath(userId));
        path.append("images");
        path.append("/");
        path.append(imageId);
        return path.toString();
    }

    public String getProfileGalleryThumbnailPath(String userId, String imageId) {
        StringBuilder path = new StringBuilder(this.getProfileGalleryPath(userId));
        path.append("thumbnails");
        path.append("/");
        path.append(imageId);
        return path.toString();
    }

    public String getProfileImageResourcePath(String userId, int type) {
        String slash = "/";
        StringBuilder path = new StringBuilder();
        path.append(slash);
        path.append("private");
        path.append(slash);
        path.append("profileImages");
        path.append(slash);
        path.append(userId);
        path.append(slash);
        path.append(type);
        path.append(slash);
        path.append(ProfileUtils.generateUuid());
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFile(String fullResourceId, String userId, String fileName, String mimeType, byte[] fileData) {
        ContentResourceEdit resource = null;
        boolean result = true;
        try {
            this.enableSecurityAdvisor();
            try {
                resource = this.contentHostingService.addResource(fullResourceId);
                resource.setContentType(mimeType);
                resource.setContent(fileData);
                ResourcePropertiesEdit props = resource.getPropertiesEdit();
                props.addProperty("DAV:getcontenttype", mimeType);
                props.addProperty("DAV:displayname", fileName);
                props.addProperty("CHEF:creator", userId);
                resource.getPropertiesEdit().set((ResourceProperties)props);
                this.contentHostingService.commitResource(resource, 0);
                result = true;
            }
            catch (IdUsedException e) {
                this.contentHostingService.cancelResource(resource);
                log.error((Object)("SakaiProxy.saveFile(): id= " + fullResourceId + " is in use : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
                result = false;
            }
            catch (Exception e) {
                this.contentHostingService.cancelResource(resource);
                log.error((Object)("SakaiProxy.saveFile(): failed: " + e.getClass() + " : " + e.getMessage()));
                result = false;
            }
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.saveFile():" + e.getClass() + ":" + e.getMessage()));
            result = false;
        }
        finally {
            this.disableSecurityAdvisor();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeTypeByteArray getResource(String resourceId) {
        block11: {
            MimeTypeByteArray mtba = new MimeTypeByteArray();
            if (StringUtils.isBlank((String)resourceId)) {
                return null;
            }
            try {
                ContentResource resource;
                block10: {
                    this.enableSecurityAdvisor();
                    try {
                        resource = this.contentHostingService.getResource(resourceId);
                        if (resource != null) break block10;
                        MimeTypeByteArray mimeTypeByteArray = null;
                        return mimeTypeByteArray;
                    }
                    catch (Exception e) {
                        log.error((Object)("SakaiProxy.getResource() failed for resourceId: " + resourceId + " : " + e.getClass() + " : " + e.getMessage()));
                        break block11;
                    }
                }
                mtba.setBytes(resource.getContent());
                mtba.setMimeType(resource.getContentType());
                MimeTypeByteArray mimeTypeByteArray = mtba;
                return mimeTypeByteArray;
            }
            catch (Exception e) {
                log.error((Object)("SakaiProxy.getResource():" + e.getClass() + ":" + e.getMessage()));
            }
            finally {
                this.disableSecurityAdvisor();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeResource(String resourceId) {
        boolean result = false;
        try {
            this.enableSecurityAdvisor();
            this.contentHostingService.removeResource(resourceId);
            result = true;
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.removeResource() failed for resourceId " + resourceId + ": " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.disableSecurityAdvisor();
        }
        return result;
    }

    public List<User> searchUsers(String search) {
        return this.userDirectoryService.searchUsers(search, 1, 99);
    }

    public List<User> searchExternalUsers(String search) {
        return this.userDirectoryService.searchExternalUsers(search, 1, 99);
    }

    public void postEvent(String event, String reference, boolean modify) {
        this.eventTrackingService.post(this.eventTrackingService.newEvent(event, reference, modify));
    }

    public void sendEmail(String userId, String subject, String message) {
        class EmailSender {
            private String userId;
            private String subject;
            private String message;
            public final String MULTIPART_BOUNDARY = "======sakai-multi-part-boundary======";
            public final String BOUNDARY_LINE = "\n\n--======sakai-multi-part-boundary======\n";
            public final String TERMINATION_LINE = "\n\n--======sakai-multi-part-boundary======--\n\n";
            public final String MIME_ADVISORY = "This message is for MIME-compliant mail readers.";
            public final String PLAIN_TEXT_HEADERS = "Content-Type: text/plain\n\n";
            public final String HTML_HEADERS = "Content-Type: text/html; charset=ISO-8859-1\n\n";
            public final String HTML_END = "\n  </body>\n</html>\n";

            public EmailSender(String userId, String subject, String message) {
                this.userId = userId;
                this.subject = subject;
                this.message = message;
            }

            public void send() {
                try {
                    User user = SakaiProxyImpl.this.userDirectoryService.getUser(this.userId);
                    if (StringUtils.isBlank((String)user.getEmail())) {
                        log.error((Object)("SakaiProxy.sendEmail() failed. No email for userId: " + this.userId));
                        return;
                    }
                    SakaiProxyImpl.this.emailService.sendToUsers(Collections.singleton(user), this.getHeaders(user.getEmail(), this.subject), this.formatMessage(this.subject, this.message));
                    log.info((Object)("Email sent to: " + this.userId));
                }
                catch (UserNotDefinedException e) {
                    log.error((Object)("SakaiProxy.sendEmail() failed for userId: " + this.userId + " : " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
                }
            }

            private String formatMessage(String subject, String message) {
                StringBuilder sb = new StringBuilder();
                sb.append("This message is for MIME-compliant mail readers.");
                sb.append("\n\n--======sakai-multi-part-boundary======\n");
                sb.append("Content-Type: text/plain\n\n");
                sb.append(Validator.escapeHtmlFormattedText((String)message));
                sb.append("\n\n--======sakai-multi-part-boundary======\n");
                sb.append("Content-Type: text/html; charset=ISO-8859-1\n\n");
                sb.append(this.htmlPreamble(subject));
                sb.append(message);
                sb.append("\n  </body>\n</html>\n");
                sb.append("\n\n--======sakai-multi-part-boundary======--\n\n");
                return sb.toString();
            }

            private String htmlPreamble(String subject) {
                StringBuilder sb = new StringBuilder();
                sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n");
                sb.append("\"http://www.w3.org/TR/html4/loose.dtd\">\n");
                sb.append("<html>\n");
                sb.append("<head><title>");
                sb.append(subject);
                sb.append("</title></head>\n");
                sb.append("<body>\n");
                return sb.toString();
            }

            private List<String> getHeaders(String emailTo, String subject) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("MIME-Version: 1.0");
                headers.add("Content-Type: multipart/alternative; boundary=\"======sakai-multi-part-boundary======\"");
                headers.add(this.formatSubject(subject));
                headers.add(this.getFrom());
                if (StringUtils.isNotBlank((String)emailTo)) {
                    headers.add("To: " + emailTo);
                }
                return headers;
            }

            private String getFrom() {
                StringBuilder sb = new StringBuilder();
                sb.append("From: ");
                sb.append(SakaiProxyImpl.this.getServiceName());
                sb.append(" <no-reply@");
                sb.append(SakaiProxyImpl.this.getServerName());
                sb.append(">");
                return sb.toString();
            }

            private String formatSubject(String subject) {
                StringBuilder sb = new StringBuilder();
                sb.append("Subject: ");
                sb.append(subject);
                return sb.toString();
            }
        }
        new EmailSender(userId, subject, message).send();
    }

    public void sendEmail(List<String> userIds, final String emailTemplateKey, final Map<String, String> replacementValues) {
        final ArrayList<User> users = new ArrayList<User>(this.getUsers(userIds));
        Thread sendMailThread = new Thread(){

            @Override
            public void run() {
                RenderedTemplate template = null;
                for (User user : users) {
                    log.info((Object)("SakaiProxy.sendEmail() attempting to send email to: " + user.getId()));
                    try {
                        template = SakaiProxyImpl.this.emailTemplateService.getRenderedTemplateForUser(emailTemplateKey, user.getReference(), replacementValues);
                        if (template == null) {
                            log.error((Object)("SakaiProxy.sendEmail() no template with key: " + emailTemplateKey));
                            return;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("SakaiProxy.sendEmail() error retrieving template for user: " + user.getId() + " with key: " + emailTemplateKey + " : " + e.getClass() + " : " + e.getMessage()));
                        continue;
                    }
                    SakaiProxyImpl.this.sendEmail(user.getId(), template.getRenderedSubject(), template.getRenderedHtmlMessage());
                }
            }
        };
        sendMailThread.start();
    }

    public void sendEmail(String userId, String emailTemplateKey, Map<String, String> replacementValues) {
        this.sendEmail(Collections.singletonList(userId), emailTemplateKey, replacementValues);
    }

    public String getServerName() {
        return this.serverConfigurationService.getServerName();
    }

    public String getPortalUrl() {
        return this.serverConfigurationService.getPortalUrl();
    }

    public String getServerUrl() {
        return this.serverConfigurationService.getServerUrl();
    }

    public String getFullPortalUrl() {
        return this.getServerUrl() + this.getPortalPath();
    }

    public String getPortalPath() {
        return this.serverConfigurationService.getString("portalPath", "/portal");
    }

    public boolean isUsingNormalPortal() {
        return StringUtils.equals((String)this.getPortalPath(), (String)"/portal");
    }

    public String getUserHomeUrl() {
        return this.serverConfigurationService.getUserHomeUrl();
    }

    public String getServiceName() {
        return this.serverConfigurationService.getString("ui.service", "Sakai");
    }

    public void updateEmailForUser(String userId, String email) {
        try {
            UserEdit userEdit = null;
            userEdit = this.userDirectoryService.editUser(userId);
            userEdit.setEmail(email);
            this.userDirectoryService.commitEdit(userEdit);
            log.info((Object)("User email updated for: " + userId));
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.updateEmailForUser() failed for userId: " + userId + " : " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void updateNameForUser(String userId, String firstName, String lastName) {
        try {
            UserEdit userEdit = null;
            userEdit = this.userDirectoryService.editUser(userId);
            userEdit.setFirstName(firstName);
            userEdit.setLastName(lastName);
            this.userDirectoryService.commitEdit(userEdit);
            log.info((Object)("User name details updated for: " + userId));
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.updateNameForUser() failed for userId: " + userId + " : " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public String getDirectUrlToUserProfile(String userId, String extraParams) {
        String portalUrl = this.getFullPortalUrl();
        String siteId = this.getUserMyWorkspace(userId);
        ToolConfiguration toolConfig = this.getFirstInstanceOfTool(siteId, "sakai.profile2");
        if (toolConfig == null) {
            log.warn((Object)("SakaiProxy.getDirectUrlToUserProfile() failed to find sakai.profile2 installed in My Workspace for userId: " + userId));
            StringBuilder url = new StringBuilder();
            url.append(portalUrl);
            url.append("/site/");
            url.append(siteId);
            return url.toString();
        }
        String pageId = toolConfig.getPageId();
        String placementId = toolConfig.getId();
        try {
            StringBuilder url = new StringBuilder();
            url.append(portalUrl);
            url.append("/site/");
            url.append(siteId);
            url.append("/page/");
            url.append(pageId);
            if (StringUtils.isNotBlank((String)extraParams)) {
                url.append("?toolstate-");
                url.append(placementId);
                url.append("=");
                url.append(URLEncoder.encode(extraParams, "UTF-8"));
            }
            return url.toString();
        }
        catch (Exception e) {
            log.error((Object)("SakaiProxy.getDirectUrl():" + e.getClass() + ":" + e.getMessage()));
            return null;
        }
    }

    public boolean isAccountUpdateAllowed(String userId) {
        try {
            UserEdit edit = this.userDirectoryService.editUser(userId);
            this.userDirectoryService.cancelEdit(edit);
            return true;
        }
        catch (Exception e) {
            log.info((Object)("SakaiProxy.isAccountUpdateAllowed() false for userId: " + userId));
            return false;
        }
    }

    public boolean isBusinessProfileEnabled() {
        return this.serverConfigurationService.getBoolean("profile2.profile.business.enabled", false);
    }

    public boolean isWallEnabledGlobally() {
        return this.serverConfigurationService.getBoolean("profile2.wall.enabled", true);
    }

    public boolean isWallDefaultProfilePage() {
        return this.serverConfigurationService.getBoolean("profile2.wall.default", false);
    }

    public boolean isProfileConversionEnabled() {
        return this.serverConfigurationService.getBoolean("profile2.convert", false);
    }

    public boolean isProfileImportEnabled() {
        return this.serverConfigurationService.getBoolean("profile2.import", false);
    }

    public String getProfileImportCsvPath() {
        return this.serverConfigurationService.getString("profile2.import.csv", null);
    }

    public boolean isTwitterIntegrationEnabledGlobally() {
        return this.serverConfigurationService.getBoolean("profile2.integration.twitter.enabled", true);
    }

    public String getTwitterSource() {
        return this.serverConfigurationService.getString("profile2.integration.twitter.source", "Profile2");
    }

    public boolean isProfileGalleryEnabledGlobally() {
        return this.serverConfigurationService.getBoolean("profile2.gallery.enabled", true);
    }

    public boolean isProfilePictureChangeEnabled() {
        boolean globallyEnabled = this.serverConfigurationService.getBoolean("profile2.picture.change.enabled", true);
        String userType = this.getUserType(this.getCurrentUserId());
        return this.serverConfigurationService.getBoolean("profile2.picture.change." + userType + ".enabled", globallyEnabled);
    }

    public int getProfilePictureType() {
        String pictureType = this.serverConfigurationService.getString("profile2.picture.type", "upload");
        if (pictureType.equals("upload")) {
            return 1;
        }
        if (pictureType.equals("url")) {
            return 2;
        }
        if (pictureType.equals("official")) {
            return 3;
        }
        return 1;
    }

    public List<String> getAcademicEntityConfigurationSet() {
        String configuration = this.serverConfigurationService.getString("profile2.profile.entity.set.academic", "displayName,imageUrl");
        String[] parameters = StringUtils.split((String)configuration, (char)',');
        List<String> tempList = Arrays.asList(parameters);
        ArrayList<String> list = new ArrayList<String>(tempList);
        return list;
    }

    public List<String> getMinimalEntityConfigurationSet() {
        String configuration = this.serverConfigurationService.getString("profile2.profile.entity.set.minimal", "displayName,statusMessage,statusDate");
        String[] parameters = StringUtils.split((String)configuration, (char)',');
        List<String> tempList = Arrays.asList(parameters);
        ArrayList<String> list = new ArrayList<String>(tempList);
        return list;
    }

    public String ensureUuid(String userId) {
        User u;
        try {
            u = this.userDirectoryService.getUser(userId);
            if (u != null) {
                return userId;
            }
        }
        catch (UserNotDefinedException e) {
            // empty catch block
        }
        try {
            u = this.userDirectoryService.getUserByEid(userId);
            if (u != null) {
                return u.getId();
            }
        }
        catch (UserNotDefinedException userNotDefinedException) {
            // empty catch block
        }
        log.error((Object)("User: " + userId + " could not be found in any lookup by either id or eid"));
        return null;
    }

    public boolean currentUserMatchesRequest(String userUuid) {
        String currentUserUuid = this.getCurrentUserId();
        return StringUtils.equals((String)currentUserUuid, (String)userUuid);
    }

    public boolean isPrivacyChangeAllowedGlobally() {
        return this.serverConfigurationService.getBoolean("profile2.privacy.change.enabled", true);
    }

    public HashMap<String, Object> getOverriddenPrivacySettings() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("profileImage", this.serverConfigurationService.getInt("profile2.privacy.default.profileImage", 0));
        props.put("basicInfo", this.serverConfigurationService.getInt("profile2.privacy.default.basicInfo", 0));
        props.put("contactInfo", this.serverConfigurationService.getInt("profile2.privacy.default.contactInfo", 0));
        props.put("staffInfo", this.serverConfigurationService.getInt("profile2.privacy.default.staffInfo", 0));
        props.put("studentInfo", this.serverConfigurationService.getInt("profile2.privacy.default.studentInfo", 0));
        props.put("personalInfo", this.serverConfigurationService.getInt("profile2.privacy.default.personalInfo", 0));
        props.put("birthYear", this.serverConfigurationService.getBoolean("profile2.privacy.default.birthYear", true));
        props.put("myFriends", this.serverConfigurationService.getInt("profile2.privacy.default.myFriends", 0));
        props.put("myStatus", this.serverConfigurationService.getInt("profile2.privacy.default.myStatus", 0));
        props.put("myPictures", this.serverConfigurationService.getInt("profile2.privacy.default.myPictures", 0));
        props.put("messages", this.serverConfigurationService.getInt("profile2.privacy.default.messages", 1));
        props.put("businessInfo", this.serverConfigurationService.getInt("profile2.privacy.default.businessInfo", 0));
        props.put("myKudos", this.serverConfigurationService.getInt("profile2.privacy.default.myKudos", 0));
        props.put("myWall", this.serverConfigurationService.getInt("profile2.privacy.default.myWall", 0));
        props.put("socialInfo", this.serverConfigurationService.getInt("profile2.privacy.default.socialInfo", 0));
        props.put("onlineStatus", this.serverConfigurationService.getInt("profile2.privacy.default.onlineStatus", 0));
        return props;
    }

    public List<String> getInvisibleUsers() {
        String config = this.serverConfigurationService.getString("profile2.invisible.users", "postmaster");
        return ProfileUtils.getListFromString((String)config, (char)',');
    }

    public boolean isConnectionAllowedBetweenUserTypes(String requestingUserType, String targetUserType) {
        if (this.isSuperUser()) {
            return true;
        }
        String configuration = this.serverConfigurationService.getString("profile2.allowed.connection.usertypes." + requestingUserType);
        if (StringUtils.isBlank((String)configuration)) {
            return true;
        }
        String[] values = StringUtils.split((String)configuration, (char)',');
        List<String> valueList = Arrays.asList(values);
        return valueList.contains(targetUserType);
    }

    public boolean toggleProfileLocked(String userId, boolean locked) {
        SakaiPerson sp = this.getSakaiPerson(userId);
        if (sp == null) {
            return false;
        }
        sp.setLocked(Boolean.valueOf(locked));
        return this.updateSakaiPerson(sp);
    }

    public boolean isOfficialImageEnabledGlobally() {
        return this.serverConfigurationService.getBoolean("profile2.official.image.enabled", false);
    }

    public boolean isUsingOfficialImageButAlternateSelectionEnabled() {
        return this.isOfficialImageEnabledGlobally() && this.getProfilePictureType() != 3 && this.isProfilePictureChangeEnabled();
    }

    public String getOfficialImageSource() {
        return this.serverConfigurationService.getString("profile2.official.image.source", "url");
    }

    public String getOfficialImageAttribute() {
        return this.serverConfigurationService.getString("profile2.official.image.attribute", "jpegPhoto");
    }

    public String getSkinRepoProperty() {
        return this.serverConfigurationService.getString("skin.repo");
    }

    public String getToolSkinCSS(String skinRepo) {
        String skin = this.siteService.findTool(this.sessionManager.getCurrentToolSession().getPlacementId()).getSkin();
        if (skin == null) {
            skin = this.serverConfigurationService.getString("skin.default");
        }
        return skinRepo + "/" + skin + "/tool.css";
    }

    public String createUuid() {
        return this.idManager.createUuid();
    }

    public boolean isUserActive(String userUuid) {
        return this.activityService.isUserActive(userUuid);
    }

    public List<String> getActiveUsers(List<String> userUuids) {
        return this.activityService.getActiveUsers(userUuids);
    }

    public Long getLastEventTimeForUser(String userUuid) {
        return this.activityService.getLastEventTimeForUser(userUuid);
    }

    public Map<String, Long> getLastEventTimeForUsers(List<String> userUuids) {
        return this.activityService.getLastEventTimeForUsers(userUuids);
    }

    public String getServerConfigurationParameter(String key, String def) {
        return this.serverConfigurationService.getString(key, def);
    }

    public boolean isUserMyWorkspace(String siteId) {
        return this.siteService.isUserSite(siteId);
    }

    public boolean isUserAllowedInSite(String userId, String permission, String siteId) {
        if (this.securityService.isSuperUser()) {
            return true;
        }
        String siteRef = siteId;
        if (siteId != null && !siteId.startsWith("/site")) {
            siteRef = "/site/" + siteId;
        }
        return this.securityService.unlock(userId, permission, siteRef);
    }

    public boolean checkForSite(String siteId) {
        return this.siteService.siteExists(siteId);
    }

    public int getMaxSearchResults() {
        return this.serverConfigurationService.getInt("profile2.search.maxSearchResults", 50);
    }

    public int getMaxSearchResultsPerPage() {
        return this.serverConfigurationService.getInt("profile2.search.maxSearchResultsPerPage", 25);
    }

    public boolean isGravatarImageEnabledGlobally() {
        return this.serverConfigurationService.getBoolean("profile2.gravatar.image.enabled", true);
    }

    public boolean isUserAllowedAddSite(String userUuid) {
        return this.siteService.allowAddSite(userUuid);
    }

    public Site addSite(String id, String type) {
        Site site = null;
        try {
            site = this.siteService.addSite(id, type);
        }
        catch (IdInvalidException e) {
            e.printStackTrace();
        }
        catch (IdUsedException e) {
            e.printStackTrace();
        }
        catch (PermissionException e) {
            e.printStackTrace();
        }
        return site;
    }

    public boolean saveSite(Site site) {
        try {
            this.siteService.save(site);
        }
        catch (IdUnusedException e) {
            e.printStackTrace();
            return false;
        }
        catch (PermissionException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Site getSite(String siteId) {
        try {
            return this.siteService.getSite(siteId);
        }
        catch (IdUnusedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Site> getUserSites() {
        return this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, SiteService.SortType.TITLE_ASC, null);
    }

    public Tool getTool(String id) {
        return this.toolManager.getTool(id);
    }

    public List<String> getToolsRequired(String category) {
        return this.serverConfigurationService.getToolsRequired(category);
    }

    public boolean isGoogleIntegrationEnabledGlobally() {
        return this.serverConfigurationService.getBoolean("profile2.integration.google.enabled", false);
    }

    public boolean isLoggedIn() {
        return StringUtils.isNotBlank((String)this.getCurrentUserId());
    }

    private void enableSecurityAdvisor() {
        this.securityService.pushAdvisor(new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        });
    }

    private void disableSecurityAdvisor() {
        this.securityService.popAdvisor();
    }

    private String getUserMyWorkspace(String userId) {
        return this.siteService.getUserSiteId(userId);
    }

    private ToolConfiguration getFirstInstanceOfTool(String siteId, String toolId) {
        try {
            return this.siteService.getSite(siteId).getToolForCommonId(toolId);
        }
        catch (IdUnusedException e) {
            log.error((Object)("SakaiProxy.getFirstInstanceOfTool() failed for siteId: " + siteId + " and toolId: " + toolId));
            return null;
        }
    }

    public void init() {
        log.info((Object)"Profile2 SakaiProxy init()");
        this.emailTemplateService.processEmailTemplates(this.emailTemplates);
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setSakaiPersonManager(SakaiPersonManager sakaiPersonManager) {
        this.sakaiPersonManager = sakaiPersonManager;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setEmailTemplates(ArrayList<String> emailTemplates) {
        this.emailTemplates = emailTemplates;
    }
}

