/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.hbm.model.ProfileImageExternal;
import org.sakaiproject.profile2.hbm.model.ProfileImageOfficial;
import org.sakaiproject.profile2.hbm.model.ProfileImageUploaded;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.GalleryImage;
import org.sakaiproject.profile2.model.MimeTypeByteArray;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.model.ProfileImage;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.types.PrivacyType;
import org.sakaiproject.profile2.util.Messages;
import org.sakaiproject.profile2.util.ProfileUtils;
import org.sakaiproject.user.api.User;

public class ProfileImageLogicImpl
implements ProfileImageLogic {
    private static final Logger log = Logger.getLogger(ProfileImageLogicImpl.class);
    private SakaiProxy sakaiProxy;
    private ProfilePrivacyLogic privacyLogic;
    private ProfileConnectionsLogic connectionsLogic;
    private ProfilePreferencesLogic preferencesLogic;
    private ProfileDao dao;

    public ProfileImage getProfileImage(String userUuid, ProfilePreferences prefs, ProfilePrivacy privacy, int size) {
        return this.getProfileImage(userUuid, prefs, privacy, size, null);
    }

    public ProfileImage getProfileImage(String userUuid, ProfilePreferences prefs, ProfilePrivacy privacy, int size, String siteId) {
        ProfileImage image = new ProfileImage();
        boolean allowed = false;
        boolean isSameUser = false;
        String defaultImageUrl = 2 == size ? this.getUnavailableImageThumbnailURL() : this.getUnavailableImageURL();
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (StringUtils.equals((String)userUuid, (String)currentUserUuid)) {
            isSameUser = true;
        }
        if (StringUtils.isBlank((String)currentUserUuid)) {
            throw new SecurityException("Must be logged in to request a profile image.");
        }
        if (prefs != null && !StringUtils.equals((String)userUuid, (String)prefs.getUserUuid())) {
            log.error((Object)("ProfilePreferences data supplied was not for user: " + userUuid));
            image.setExternalImageUrl(defaultImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, false));
            return image;
        }
        if (privacy != null && !StringUtils.equals((String)userUuid, (String)privacy.getUserUuid())) {
            log.error((Object)("ProfilePrivacy data supplied was not for user: " + userUuid));
            image.setExternalImageUrl(defaultImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, false));
            return image;
        }
        if (isSameUser) {
            allowed = true;
        }
        if (StringUtils.isNotBlank((String)siteId) && !this.sakaiProxy.isUserMyWorkspace(siteId)) {
            log.debug((Object)("checking if user: " + currentUserUuid + " has permissions in site: " + siteId));
            allowed = this.sakaiProxy.isUserAllowedInSite(currentUserUuid, "roster.viewofficialphoto", siteId);
        }
        if (!allowed && privacy == null && (privacy = this.privacyLogic.getPrivacyRecordForUser(userUuid)) == null) {
            log.error((Object)("Couldn't retrieve ProfilePrivacy data for user: " + userUuid + ". Using default image."));
            image.setExternalImageUrl(defaultImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, false));
            return image;
        }
        if (!allowed) {
            allowed = this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_PROFILEIMAGE);
        }
        if (!allowed) {
            image.setExternalImageUrl(defaultImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, false));
            return image;
        }
        String userTypeImageUrl = this.getUserTypeImageUrl(userUuid);
        if (StringUtils.isNotBlank((String)userTypeImageUrl)) {
            image.setExternalImageUrl(userTypeImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, true));
            return image;
        }
        int imageType = this.sakaiProxy.getProfilePictureType();
        if (prefs == null) {
            prefs = this.preferencesLogic.getPreferencesRecordForUser(userUuid);
        }
        if (prefs != null && this.sakaiProxy.isUsingOfficialImageButAlternateSelectionEnabled() && prefs.isUseOfficialImage()) {
            imageType = 3;
        }
        if (prefs != null && this.sakaiProxy.isGravatarImageEnabledGlobally() && prefs.isUseGravatar()) {
            imageType = 4;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("imageType: " + imageType));
            log.debug((Object)("size: " + size));
        }
        switch (imageType) {
            case 1: {
                MimeTypeByteArray mtba = this.getUploadedProfileImage(userUuid, size);
                if (mtba == null || mtba.getBytes() == null) {
                    image.setExternalImageUrl(defaultImageUrl);
                } else {
                    image.setUploadedImage(mtba.getBytes());
                    image.setMimeType(mtba.getMimeType());
                }
                image.setAltText(this.getAltText(userUuid, isSameUser, true));
                break;
            }
            case 2: {
                image.setExternalImageUrl(this.getExternalProfileImageUrl(userUuid, size));
                image.setAltText(this.getAltText(userUuid, isSameUser, true));
                break;
            }
            case 3: {
                String data;
                String officialImageSource = this.sakaiProxy.getOfficialImageSource();
                if (StringUtils.equals((String)officialImageSource, (String)"url")) {
                    image.setOfficialImageUrl(this.getOfficialImageUrl(userUuid));
                } else if (StringUtils.equals((String)officialImageSource, (String)"provider") && StringUtils.isBlank((String)(data = this.getOfficialImageEncoded(userUuid)))) {
                    image.setExternalImageUrl(defaultImageUrl);
                }
                image.setAltText(this.getAltText(userUuid, isSameUser, true));
                break;
            }
            case 4: {
                String gravatarUrl = this.getGravatarUrl(userUuid);
                if (StringUtils.isBlank((String)gravatarUrl)) {
                    image.setExternalImageUrl(defaultImageUrl);
                    image.setAltText(this.getAltText(userUuid, isSameUser, false));
                    break;
                }
                image.setExternalImageUrl(gravatarUrl);
                image.setAltText(this.getAltText(userUuid, isSameUser, true));
                break;
            }
            default: {
                image.setExternalImageUrl(defaultImageUrl);
                image.setAltText(this.getAltText(userUuid, isSameUser, false));
            }
        }
        return image;
    }

    public ProfileImage getProfileImage(Person person, int size) {
        return this.getProfileImage(person.getUuid(), person.getPreferences(), person.getPrivacy(), size, null);
    }

    public ProfileImage getProfileImage(Person person, int size, String siteId) {
        return this.getProfileImage(person.getUuid(), person.getPreferences(), person.getPrivacy(), size, siteId);
    }

    public boolean setUploadedProfileImage(String userUuid, byte[] imageBytes, String mimeType, String fileName) {
        ProfileImageUploaded profileImage;
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to update a user's profile image.");
        }
        if (!this.sakaiProxy.isSuperUser() && !StringUtils.equals((String)currentUserUuid, (String)userUuid)) {
            throw new SecurityException("Not allowed to save.");
        }
        if (!this.sakaiProxy.isProfilePictureChangeEnabled()) {
            log.warn((Object)"Profile image changes are not permitted as per sakai.properties setting 'profile2.picture.change.enabled'.");
            return false;
        }
        byte[] mainImageBytes = ProfileUtils.scaleImage((byte[])imageBytes, (int)200, (String)mimeType);
        String mainResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 1);
        if (!this.sakaiProxy.saveFile(mainResourceId, userUuid, fileName, mimeType, mainImageBytes)) {
            log.error((Object)"Couldn't add main image to CHS. Aborting.");
            return false;
        }
        byte[] thumbnailImageBytes = ProfileUtils.scaleImage((byte[])imageBytes, (int)100, (String)mimeType);
        String thumbnailResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 2);
        log.debug((Object)("Profile.ChangeProfilePicture.onSubmit thumbnailResourceId: " + thumbnailResourceId));
        if (!this.sakaiProxy.saveFile(thumbnailResourceId, userUuid, fileName, mimeType, thumbnailImageBytes)) {
            log.warn((Object)"Couldn't add thumbnail image to CHS. Main image will be used instead.");
            thumbnailResourceId = null;
        }
        byte[] avatarImageBytes = ProfileUtils.createAvatar((byte[])imageBytes, (String)mimeType);
        String avatarResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 3);
        log.debug((Object)("Profile.ChangeProfilePicture.onSubmit avatarResourceId: " + avatarResourceId));
        if (!this.sakaiProxy.saveFile(avatarResourceId, userUuid, fileName, mimeType, avatarImageBytes)) {
            log.warn((Object)"Couldn't add avatar image to CHS. Main image will be used instead.");
            avatarResourceId = null;
        }
        if (this.dao.addNewProfileImage(profileImage = new ProfileImageUploaded(userUuid, mainResourceId, thumbnailResourceId, avatarResourceId, true))) {
            log.info((Object)("Added a new profile image for user: " + userUuid));
            return true;
        }
        return false;
    }

    public boolean setExternalProfileImage(String userUuid, String fullSizeUrl, String thumbnailUrl, String avatar) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to update a user's profile image.");
        }
        if (!this.sakaiProxy.isSuperUser() && !StringUtils.equals((String)currentUserUuid, (String)userUuid)) {
            throw new SecurityException("Not allowed to save.");
        }
        if (!this.sakaiProxy.isProfilePictureChangeEnabled()) {
            log.warn((Object)"Profile image changes are not permitted as per sakai.properties setting 'profile2.picture.change.enabled'.");
            return false;
        }
        ProfileImageExternal externalImage = new ProfileImageExternal(userUuid, fullSizeUrl, thumbnailUrl, avatar);
        if (this.dao.saveExternalImage(externalImage)) {
            log.info((Object)("Updated external image record for user: " + userUuid));
            return true;
        }
        return false;
    }

    public boolean saveOfficialImageUrl(String userUuid, String url) {
        ProfileImageOfficial officialImage = new ProfileImageOfficial(userUuid, url);
        if (this.dao.saveOfficialImageUrl(officialImage)) {
            log.info((Object)("Updated official image record for user: " + userUuid));
            return true;
        }
        return false;
    }

    public boolean addGalleryImage(String userUuid, byte[] imageBytes, String mimeType, String fileName) {
        byte[] scaledImageBytes;
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to add a gallery image.");
        }
        if (!this.sakaiProxy.isSuperUser() && !StringUtils.equals((String)currentUserUuid, (String)userUuid)) {
            throw new SecurityException("You are not allowed to add a gallery image.");
        }
        String imageId = this.sakaiProxy.createUuid();
        String mainResourcePath = this.sakaiProxy.getProfileGalleryImagePath(userUuid, imageId);
        if (!this.sakaiProxy.saveFile(mainResourcePath, userUuid, fileName, mimeType, scaledImageBytes = ProfileUtils.scaleImage((byte[])imageBytes, (int)575, (String)mimeType))) {
            log.error((Object)"Couldn't add gallery image to CHS. Aborting.");
            return false;
        }
        byte[] thumbnailBytes = ProfileUtils.scaleImage((byte[])imageBytes, (int)125, (String)mimeType);
        String thumbnailResourcePath = this.sakaiProxy.getProfileGalleryThumbnailPath(userUuid, imageId);
        this.sakaiProxy.saveFile(thumbnailResourcePath, userUuid, fileName, mimeType, thumbnailBytes);
        GalleryImage galleryImage = new GalleryImage(userUuid, mainResourcePath, thumbnailResourcePath, fileName);
        if (this.dao.addNewGalleryImage(galleryImage)) {
            log.info((Object)("Added new gallery image for user: " + galleryImage.getUserUuid()));
            return true;
        }
        return false;
    }

    public List<GalleryImage> getGalleryImages(String userUuid) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to make a request for a user's gallery images.");
        }
        return this.dao.getGalleryImages(userUuid);
    }

    public List<GalleryImage> getGalleryImagesRandomized(String userUuid) {
        List<GalleryImage> images = this.getGalleryImages(userUuid);
        Collections.shuffle(images);
        return images;
    }

    public boolean removeGalleryImage(String userId, long imageId) {
        if (userId == null || Long.valueOf(imageId) == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogicImpl.removeGalleryImage()");
        }
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to remove a gallery image.");
        }
        if (!this.sakaiProxy.isSuperUser() && !StringUtils.equals((String)currentUserUuid, (String)userId)) {
            throw new SecurityException("You are not allowed to remove this gallery image.");
        }
        GalleryImage galleryImage = this.dao.getGalleryImageRecord(userId, imageId);
        if (galleryImage == null) {
            log.error((Object)("GalleryImage record does not exist for userId: " + userId + ", imageId: " + imageId));
            return false;
        }
        if (!this.sakaiProxy.removeResource(galleryImage.getMainResource())) {
            log.error((Object)("Gallery image not removed: " + galleryImage.getMainResource()));
        }
        if (!this.sakaiProxy.removeResource(galleryImage.getThumbnailResource())) {
            log.error((Object)("Gallery thumbnail not removed: " + galleryImage.getThumbnailResource()));
        }
        if (this.dao.removeGalleryImage(galleryImage)) {
            log.info((Object)("User: " + userId + " removed gallery image: " + imageId));
            return true;
        }
        return false;
    }

    public String getGravatarUrl(String userUuid) {
        String email = this.sakaiProxy.getUserEmail(userUuid);
        if (StringUtils.isBlank((String)email)) {
            return null;
        }
        return "http://www.gravatar.com/avatar/" + ProfileUtils.calculateMD5((String)email) + "?s=200";
    }

    private String getUnavailableImageURL(String imagePath) {
        StringBuilder path = new StringBuilder();
        path.append(this.sakaiProxy.getServerUrl());
        path.append(imagePath);
        return path.toString();
    }

    public String getUnavailableImageURL() {
        return this.getUnavailableImageURL("/profile2-tool/images/no_image.gif");
    }

    public String getUnavailableImageThumbnailURL() {
        return this.getUnavailableImageURL("/profile2-tool/images/no_image_thumbnail.gif");
    }

    public String getProfileImageEntityUrl(String userUuid, int size) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sakaiProxy.getServerUrl());
        sb.append("/direct/profile/");
        sb.append(userUuid);
        sb.append("/image/");
        if (size == 2) {
            sb.append("thumb/");
        }
        return sb.toString();
    }

    public int getGalleryImagesCount(String userUuid) {
        return this.dao.getGalleryImagesCount(userUuid);
    }

    private MimeTypeByteArray getUploadedProfileImage(String userUuid, int size) {
        MimeTypeByteArray mtba = new MimeTypeByteArray();
        ProfileImageUploaded profileImage = this.dao.getCurrentProfileImageRecord(userUuid);
        if (profileImage == null) {
            log.debug((Object)("ProfileLogic.getUploadedProfileImage() null for userUuid: " + userUuid));
            return null;
        }
        if (size == 1) {
            mtba = this.sakaiProxy.getResource(profileImage.getMainResource());
        }
        if (size == 2 && ((mtba = this.sakaiProxy.getResource(profileImage.getThumbnailResource())) == null || mtba.getBytes() == null)) {
            mtba = this.sakaiProxy.getResource(profileImage.getMainResource());
        }
        if (size == 3 && ((mtba = this.sakaiProxy.getResource(profileImage.getAvatarResource())) == null || mtba.getBytes() == null)) {
            mtba = this.sakaiProxy.getResource(profileImage.getMainResource());
        }
        return mtba;
    }

    private String getExternalProfileImageUrl(String userUuid, int size) {
        ProfileImageExternal externalImage = this.dao.getExternalImageRecordForUser(userUuid);
        String defaultImageUrl = this.getUnavailableImageURL();
        if (externalImage == null) {
            return defaultImageUrl;
        }
        String url = null;
        if (size == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning main image url for userId: " + userUuid));
            }
            url = externalImage.getMainUrl();
        }
        if (size == 2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning thumb image url for userId: " + userUuid));
            }
            url = externalImage.getThumbnailUrl();
        }
        if (size == 3) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning avatar image url for userId: " + userUuid));
            }
            url = externalImage.getAvatarUrl();
        }
        if (StringUtils.isNotBlank((String)url)) {
            return url;
        }
        url = externalImage.getMainUrl();
        if (StringUtils.isBlank((String)url)) {
            url = defaultImageUrl;
        }
        log.info((Object)("ProfileLogic.getExternalProfileImageUrl. No URL for userId: " + userUuid + ", imageType: " + size + ". Returning default."));
        return defaultImageUrl;
    }

    private String getOfficialImageUrl(String userUuid) {
        ProfileImageOfficial official = this.dao.getOfficialImageRecordForUser(userUuid);
        String defaultImageUrl = this.getUnavailableImageURL();
        if (official == null) {
            return defaultImageUrl;
        }
        if (StringUtils.isBlank((String)official.getUrl())) {
            log.info((Object)("ProfileLogic.getOfficialImageUrl. No URL for userUuid: " + userUuid + ". Returning default."));
            return defaultImageUrl;
        }
        return official.getUrl();
    }

    private String getOfficialImageEncoded(String userUuid) {
        User u = this.sakaiProxy.getUserById(userUuid);
        return u.getProperties().getProperty(this.sakaiProxy.getOfficialImageAttribute());
    }

    private String getAltText(String userUuid, boolean isOwner, boolean hasImage) {
        if (isOwner && hasImage) {
            return Messages.getString((String)"profile.image.my.alt");
        }
        if (isOwner && !hasImage) {
            return Messages.getString((String)"profile.image.my.none.alt");
        }
        if (!isOwner) {
            String displayName = this.sakaiProxy.getUserDisplayName(userUuid);
            return Messages.getString((String)"profile.image.other.alt", (Object[])new Object[]{displayName});
        }
        return null;
    }

    private String getUserTypeImageUrl(String userUuid) {
        String userType;
        boolean enabled = Boolean.valueOf(this.sakaiProxy.getServerConfigurationParameter("profile2.user.type.image.enabled", "false"));
        String imageUrl = null;
        if (enabled && StringUtils.isNotBlank((String)(userType = this.sakaiProxy.getUserType(userUuid)))) {
            imageUrl = this.sakaiProxy.getServerConfigurationParameter("profile.user.type.image." + userType, null);
        }
        return imageUrl;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setPrivacyLogic(ProfilePrivacyLogic privacyLogic) {
        this.privacyLogic = privacyLogic;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }

    public void setPreferencesLogic(ProfilePreferencesLogic preferencesLogic) {
        this.preferencesLogic = preferencesLogic;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }
}

