/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.conversion;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.CsvToBean;
import au.com.bytecode.opencsv.bean.HeaderColumnNameTranslateMappingStrategy;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.exception.ProfileNotDefinedException;
import org.sakaiproject.profile2.hbm.model.ProfileImageExternal;
import org.sakaiproject.profile2.hbm.model.ProfileImageUploaded;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ImportableUserProfile;
import org.sakaiproject.profile2.model.MimeTypeByteArray;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.util.ProfileUtils;

public class ProfileConverter {
    private static final Logger log = Logger.getLogger(ProfileConverter.class);
    private SakaiProxy sakaiProxy;
    private ProfileDao dao;
    private SecurityService securityService;
    private ProfileImageLogic imageLogic;
    ConvertedImage ci = null;
    private static final String DEFAULT_FILE_NAME = "Profile Image";
    private static final String DEFAULT_MIME_TYPE = "image/jpeg";

    public void init() {
        log.info((Object)"Profile2: ===============================");
        log.info((Object)"Profile2: Conversion utility starting up.");
        log.info((Object)"Profile2: ===============================");
    }

    public void convertProfileImages() {
        ArrayList<String> allUsers = new ArrayList<String>(this.dao.getAllSakaiPersonIds());
        if (allUsers.isEmpty()) {
            log.warn((Object)"Profile2 image converter: No SakaiPersons to process. Nothing to do!");
            return;
        }
        for (String userUuid : allUsers) {
            ProfileImageExternal externalProfileImage;
            ProfileImageUploaded uploadedProfileImage = this.dao.getCurrentProfileImageRecord(userUuid);
            this.ci = new ConvertedImage();
            this.ci.setUserUuid(userUuid);
            if (uploadedProfileImage == null) {
                this.convertSakaiPersonImage();
                if (StringUtils.isNotBlank((String)this.ci.getMainResourceId())) {
                    this.generateAndPersistThumbnail();
                    this.generateAndPersistAvatar();
                }
            } else {
                this.ci.setMainResourceId(uploadedProfileImage.getMainResource());
                this.ci.setThumbnailResourceId(uploadedProfileImage.getThumbnailResource());
                this.ci.setAvatarResourceId(uploadedProfileImage.getAvatarResource());
                MimeTypeByteArray mtba = this.sakaiProxy.getResource(this.ci.getMainResourceId());
                this.ci.setImage(mtba.getBytes());
                this.ci.setMimeType(mtba.getMimeType());
                if (this.ci.needsThumb()) {
                    this.generateAndPersistThumbnail();
                }
                if (this.ci.needsAvatar()) {
                    this.generateAndPersistAvatar();
                }
            }
            if (this.ci.isNeedsSaving()) {
                ProfileImageUploaded convertedProfileImage = new ProfileImageUploaded(userUuid, this.ci.getMainResourceId(), this.ci.getThumbnailResourceId(), this.ci.getAvatarResourceId(), true);
                if (this.dao.addNewProfileImage(convertedProfileImage)) {
                    log.info((Object)("Profile2 image converter: Binary image converted and saved for " + userUuid));
                } else {
                    log.warn((Object)("Profile2 image converter: Binary image conversion failed for " + userUuid));
                }
            }
            if ((externalProfileImage = this.dao.getExternalImageRecordForUser(userUuid)) != null) {
                log.info((Object)("Profile2 image converter: ProfileImageExternal record exists for " + userUuid + ". Nothing to do here, skipping..."));
            } else {
                log.info((Object)("Profile2 image converter: No existing ProfileImageExternal record for " + userUuid + ". Processing..."));
                String url = this.sakaiProxy.getSakaiPersonImageUrl(userUuid);
                if (StringUtils.isBlank((String)url)) {
                    log.info((Object)("Profile2 image converter: No url image to convert for " + userUuid + ". Skipping..."));
                } else {
                    externalProfileImage = new ProfileImageExternal(userUuid, url, null, null);
                    if (this.dao.saveExternalImage(externalProfileImage)) {
                        log.info((Object)("Profile2 image converter: Url image converted and saved for " + userUuid));
                    } else {
                        log.warn((Object)("Profile2 image converter: Url image conversion failed for " + userUuid));
                    }
                }
            }
            log.info((Object)("Profile2 image converter: Finished converting user profile for: " + userUuid));
        }
    }

    public void importProfileImages() {
        ArrayList<String> allUsers = new ArrayList<String>(this.dao.getAllSakaiPersonIds());
        if (allUsers.isEmpty()) {
            log.warn((Object)"Profile2 image converter: No SakaiPersons to process. Nothing to do!");
            return;
        }
        for (String userUuid : allUsers) {
            ProfileImageUploaded uploadedProfileImage = this.dao.getCurrentProfileImageRecord(userUuid);
            this.ci = new ConvertedImage();
            this.ci.setUserUuid(userUuid);
            if (uploadedProfileImage == null) {
                ProfileImageExternal externalProfileImage = this.dao.getExternalImageRecordForUser(userUuid);
                if (externalProfileImage == null) {
                    log.info((Object)("No existing external profile images for " + userUuid));
                } else {
                    String mainUrl = externalProfileImage.getMainUrl();
                    if (StringUtils.isNotBlank((String)mainUrl)) {
                        this.retrieveMainImage(userUuid, mainUrl);
                    } else {
                        log.info((Object)("No URL set for " + userUuid));
                    }
                }
                if (StringUtils.isNotBlank((String)this.ci.getMainResourceId())) {
                    this.generateAndPersistThumbnail();
                    this.generateAndPersistAvatar();
                }
            }
            if (!this.ci.isNeedsSaving()) continue;
            ProfileImageUploaded convertedProfileImage = new ProfileImageUploaded(userUuid, this.ci.getMainResourceId(), this.ci.getThumbnailResourceId(), this.ci.getAvatarResourceId(), true);
            if (this.dao.addNewProfileImage(convertedProfileImage)) {
                log.info((Object)("Profile2 image converter: Binary image converted and saved for " + userUuid));
                continue;
            }
            log.warn((Object)("Profile2 image converter: Binary image conversion failed for " + userUuid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveMainImage(String userUuid, String mainUrl) {
        InputStream inputStream = null;
        try {
            URL url = new URL(mainUrl);
            HttpURLConnection openConnection = (HttpURLConnection)url.openConnection();
            openConnection.setReadTimeout(5000);
            openConnection.setConnectTimeout(5000);
            openConnection.setInstanceFollowRedirects(true);
            openConnection.connect();
            int responseCode = openConnection.getResponseCode();
            if (responseCode == 200) {
                String mimeType = openConnection.getContentType();
                inputStream = openConnection.getInputStream();
                byte[] imageMain = ProfileUtils.scaleImage((InputStream)inputStream, (int)200, (String)mimeType);
                String mainResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 1);
                log.info((Object)("Profile2 image converter: mainResourceId: " + mainResourceId));
                if (!this.sakaiProxy.saveFile(mainResourceId, userUuid, DEFAULT_FILE_NAME, mimeType, imageMain)) {
                    log.error((Object)"Profile2 image importer: Saving main profile image failed.");
                } else {
                    this.ci.setImage(imageMain);
                    this.ci.setMimeType(mimeType);
                    this.ci.setFileName(DEFAULT_FILE_NAME);
                    this.ci.setMainResourceId(mainResourceId);
                    this.ci.setNeedsSaving(true);
                }
            } else {
                log.warn((Object)("Failed to get good response for user " + userUuid + " for " + mainUrl + " got " + responseCode));
            }
        }
        catch (MalformedURLException e) {
            log.info((Object)("Invalid URL for user: " + userUuid + " of: " + mainUrl));
        }
        catch (IOException e) {
            log.warn((Object)("Failed to download image for: " + userUuid + " from: " + mainUrl + " error of: " + e.getMessage()));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    log.info((Object)("Failed to close input stream for request to: " + mainUrl));
                }
            }
        }
    }

    public void importProfiles(String path) {
        if (StringUtils.isBlank((String)path)) {
            log.warn((Object)"Profile2 importer: invalid path to CSV file. Aborting.");
            return;
        }
        HeaderColumnNameTranslateMappingStrategy strat = new HeaderColumnNameTranslateMappingStrategy();
        strat.setType(ImportableUserProfile.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("eid", "eid");
        map.put("nickname", "nickname");
        map.put("position", "position");
        map.put("department", "department");
        map.put("school", "school");
        map.put("room", "room");
        map.put("web site", "homepage");
        map.put("work phone", "workphone");
        map.put("home phone", "homephone");
        map.put("mobile phone", "mobilephone");
        map.put("fax", "facsimile");
        map.put("books", "favouriteBooks");
        map.put("tv", "favouriteTvShows");
        map.put("movies", "favouriteMovies");
        map.put("quotes", "favouriteQuotes");
        map.put("summary", "personalSummary");
        map.put("course", "course");
        map.put("subjects", "subjects");
        map.put("staff profile", "staffProfile");
        map.put("uni profile url", "universityProfileUrl");
        map.put("academic profile url", "academicProfileUrl");
        map.put("publications", "publications");
        map.put("official image url", "officialImageUrl");
        strat.setColumnMapping(map);
        CsvToBean csv = new CsvToBean();
        List list = new ArrayList();
        try {
            list = csv.parse((MappingStrategy)strat, new CSVReader((Reader)new FileReader(path)));
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)("Profile2 importer: Couldn't find file: " + fnfe.getClass() + " : " + fnfe.getMessage()));
        }
        SecurityAdvisor securityAdvisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.enableSecurityAdvisor(securityAdvisor);
        for (ImportableUserProfile profile : list) {
            String uuid;
            block10: {
                log.info((Object)("Processing user: " + profile.getEid()));
                uuid = this.sakaiProxy.getUserIdForEid(profile.getEid());
                if (StringUtils.isBlank((String)uuid)) {
                    log.error((Object)("Invalid user: " + profile.getEid() + ". Skipping..."));
                    continue;
                }
                profile.setUserUuid(uuid);
                if (this.hasPersistentProfile(uuid)) {
                    log.warn((Object)("User: " + profile.getEid() + " already has a profile. Skipping..."));
                    continue;
                }
                try {
                    SakaiPerson sp = this.transformUserProfileToSakaiPerson((UserProfile)profile);
                    if (sp == null) continue;
                    if (this.sakaiProxy.updateSakaiPerson(sp)) {
                        log.info((Object)("Profile saved for user: " + profile.getEid()));
                        break block10;
                    }
                    log.error((Object)("Couldn't save profile for user: " + profile.getEid()));
                }
                catch (ProfileNotDefinedException pnde) {}
                continue;
            }
            if (!StringUtils.isNotBlank((String)profile.getOfficialImageUrl())) continue;
            if (this.imageLogic.saveOfficialImageUrl(uuid, profile.getOfficialImageUrl())) {
                log.info((Object)("Official image saved for user: " + profile.getEid()));
                continue;
            }
            log.error((Object)("Couldn't save official image for user: " + profile.getEid()));
        }
        this.disableSecurityAdvisor(securityAdvisor);
    }

    private boolean hasPersistentProfile(String userUuid) {
        SakaiPerson sp = this.sakaiProxy.getSakaiPerson(userUuid);
        return sp != null;
    }

    private SakaiPerson transformUserProfileToSakaiPerson(UserProfile up) {
        log.info((Object)("Transforming: " + up.toString()));
        String userUuid = up.getUserUuid();
        if (StringUtils.isBlank((String)userUuid)) {
            log.error((Object)"Profile was invalid (missing uuid), cannot transform.");
            return null;
        }
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userUuid);
        if (sakaiPerson == null && (sakaiPerson = this.sakaiProxy.createSakaiPerson(userUuid)) == null) {
            throw new ProfileNotDefinedException("Couldn't create a SakaiPerson for " + userUuid);
        }
        sakaiPerson.setNickname(up.getNickname());
        sakaiPerson.setDateOfBirth(up.getDateOfBirth());
        sakaiPerson.setLabeledURI(up.getHomepage());
        sakaiPerson.setTelephoneNumber(up.getWorkphone());
        sakaiPerson.setHomePhone(up.getHomephone());
        sakaiPerson.setMobile(up.getMobilephone());
        sakaiPerson.setFacsimileTelephoneNumber(up.getFacsimile());
        sakaiPerson.setOrganizationalUnit(up.getDepartment());
        sakaiPerson.setTitle(up.getPosition());
        sakaiPerson.setCampus(up.getSchool());
        sakaiPerson.setRoomNumber(up.getRoom());
        sakaiPerson.setStaffProfile(up.getStaffProfile());
        sakaiPerson.setUniversityProfileUrl(up.getUniversityProfileUrl());
        sakaiPerson.setAcademicProfileUrl(up.getAcademicProfileUrl());
        sakaiPerson.setPublications(up.getPublications());
        sakaiPerson.setEducationCourse(up.getCourse());
        sakaiPerson.setEducationSubjects(up.getSubjects());
        sakaiPerson.setFavouriteBooks(up.getFavouriteBooks());
        sakaiPerson.setFavouriteTvShows(up.getFavouriteTvShows());
        sakaiPerson.setFavouriteMovies(up.getFavouriteMovies());
        sakaiPerson.setFavouriteQuotes(up.getFavouriteQuotes());
        sakaiPerson.setNotes(up.getPersonalSummary());
        return sakaiPerson;
    }

    private void enableSecurityAdvisor(SecurityAdvisor securityAdvisor) {
        this.securityService.pushAdvisor(securityAdvisor);
    }

    private void disableSecurityAdvisor(SecurityAdvisor advisor) {
        this.securityService.popAdvisor(advisor);
    }

    private void convertSakaiPersonImage() {
        String userUuid = this.ci.getUserUuid();
        byte[] image = this.sakaiProxy.getSakaiPersonJpegPhoto(userUuid);
        if (image == null || image.length == 0) {
            log.info((Object)("Profile2 image converter: No image binary to convert for " + userUuid + ". Skipping user..."));
        } else {
            byte[] imageMain = ProfileUtils.scaleImage((byte[])image, (int)200, (String)DEFAULT_MIME_TYPE);
            String mainResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 1);
            log.info((Object)("Profile2 image converter: mainResourceId: " + mainResourceId));
            if (!this.sakaiProxy.saveFile(mainResourceId, userUuid, DEFAULT_FILE_NAME, DEFAULT_MIME_TYPE, imageMain)) {
                log.error((Object)"Profile2 image converter: Saving main profile image failed.");
            } else {
                this.ci.setImage(imageMain);
                this.ci.setMimeType(DEFAULT_MIME_TYPE);
                this.ci.setFileName(DEFAULT_FILE_NAME);
                this.ci.setMainResourceId(mainResourceId);
                this.ci.setNeedsSaving(true);
            }
        }
    }

    private void generateAndPersistThumbnail() {
        String userUuid = this.ci.getUserUuid();
        byte[] imageThumbnail = ProfileUtils.scaleImage((byte[])this.ci.getImage(), (int)100, (String)this.ci.getMimeType());
        String thumbnailResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 2);
        log.info((Object)("Profile2 image converter: thumbnailResourceId:" + thumbnailResourceId));
        if (!this.sakaiProxy.saveFile(thumbnailResourceId, userUuid, DEFAULT_FILE_NAME, this.ci.getMimeType(), imageThumbnail)) {
            log.warn((Object)"Profile2 image converter: Saving thumbnail profile image failed. Main image will be used instead.");
        } else {
            this.ci.setThumbnailResourceId(thumbnailResourceId);
            this.ci.setNeedsSaving(true);
        }
    }

    private void generateAndPersistAvatar() {
        String userUuid = this.ci.getUserUuid();
        byte[] imageAvatar = ProfileUtils.createAvatar((byte[])this.ci.getImage(), (String)this.ci.getMimeType());
        String avatarResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 2);
        log.info((Object)("Profile2 image converter: avatarResourceId:" + avatarResourceId));
        if (!this.sakaiProxy.saveFile(avatarResourceId, userUuid, DEFAULT_FILE_NAME, this.ci.getMimeType(), imageAvatar)) {
            log.warn((Object)"Profile2 image converter: Saving avatar profile image failed. Main image will be used instead.");
        } else {
            this.ci.setAvatarResourceId(avatarResourceId);
            this.ci.setNeedsSaving(true);
        }
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setImageLogic(ProfileImageLogic imageLogic) {
        this.imageLogic = imageLogic;
    }

    class ConvertedImage {
        private String mainResourceId;
        private String thumbnailResourceId;
        private String avatarResourceId;
        private byte[] image;
        private String mimeType;
        private String userUuid;
        private String fileName;
        private boolean needsSaving = false;

        ConvertedImage() {
        }

        public boolean needsThumb() {
            return this.validBytes() && StringUtils.isBlank((String)this.thumbnailResourceId);
        }

        public boolean needsAvatar() {
            return this.validBytes() && StringUtils.isBlank((String)this.avatarResourceId);
        }

        public boolean validBytes() {
            return this.image != null && this.image.length > 0;
        }

        public String getMainResourceId() {
            return this.mainResourceId;
        }

        public void setMainResourceId(String mainResourceId) {
            this.mainResourceId = mainResourceId;
        }

        public String getThumbnailResourceId() {
            return this.thumbnailResourceId;
        }

        public void setThumbnailResourceId(String thumbnailResourceId) {
            this.thumbnailResourceId = thumbnailResourceId;
        }

        public String getAvatarResourceId() {
            return this.avatarResourceId;
        }

        public void setAvatarResourceId(String avatarResourceId) {
            this.avatarResourceId = avatarResourceId;
        }

        public byte[] getImage() {
            return this.image;
        }

        public void setImage(byte[] image) {
            this.image = image;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getUserUuid() {
            return this.userUuid;
        }

        public void setUserUuid(String userUuid) {
            this.userUuid = userUuid;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public boolean isNeedsSaving() {
            return this.needsSaving;
        }

        public void setNeedsSaving(boolean needsSaving) {
            this.needsSaving = needsSaving;
        }
    }
}

