/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.profile2.cache.CacheManager;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.hbm.model.ProfileFriend;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.BasicConnection;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.types.EmailType;
import org.sakaiproject.profile2.types.PrivacyType;
import org.sakaiproject.user.api.User;

public class ProfileConnectionsLogicImpl
implements ProfileConnectionsLogic {
    private static final Logger log = Logger.getLogger(ProfileConnectionsLogicImpl.class);
    private Cache cache;
    private final String CACHE_NAME = "org.sakaiproject.profile2.cache.connections";
    private SakaiProxy sakaiProxy;
    private ProfileDao dao;
    private ProfileLogic profileLogic;
    private ProfileLinkLogic linkLogic;
    private ProfilePrivacyLogic privacyLogic;
    private ProfilePreferencesLogic preferencesLogic;
    private CacheManager cacheManager;

    public List<BasicConnection> getBasicConnectionsForUser(String userUuid) {
        List<User> users = this.getConnectedUsers(userUuid);
        return this.getBasicConnections(users);
    }

    public List<Person> getConnectionsForUser(String userUuid) {
        List<User> users = this.getConnectedUsers(userUuid);
        return this.profileLogic.getPersons(users);
    }

    public int getConnectionsForUserCount(String userId) {
        return this.getConnectionsForUser(userId).size();
    }

    public List<Person> getConnectionRequestsForUser(String userId) {
        List users = this.sakaiProxy.getUsers(this.dao.getRequestedConnectionUserIdsForUser(userId));
        return this.profileLogic.getPersons(users);
    }

    public int getConnectionRequestsForUserCount(String userId) {
        return this.getConnectionRequestsForUser(userId).size();
    }

    public boolean isUserXFriendOfUserY(String userX, String userY) {
        if (userY.equals(userX)) {
            return true;
        }
        List<String> friendUuids = this.getConfirmedConnectionUserIdsForUser(userY);
        return friendUuids.contains(userX);
    }

    public List<Person> getConnectionsSubsetForSearch(List<Person> connections, String search) {
        return this.getConnectionsSubsetForSearch(connections, search, false);
    }

    public List<Person> getConnectionsSubsetForSearch(List<Person> connections, String search, boolean forMessaging) {
        ArrayList<Person> subList = new ArrayList<Person>();
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to get a connection list subset.");
        }
        for (Person p : connections) {
            if (!StringUtils.startsWithIgnoreCase((String)p.getDisplayName(), (String)search)) continue;
            if (subList.size() == 15) break;
            if (forMessaging && !this.privacyLogic.isActionAllowed(p.getUuid(), currentUserUuid, PrivacyType.PRIVACY_OPTION_MESSAGES)) continue;
            subList.add(p);
        }
        return subList;
    }

    public int getConnectionStatus(String userA, String userB) {
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        if (!StringUtils.equals((String)currentUserId, (String)userA)) {
            log.error((Object)("User: " + currentUserId + " attempted to get the connection status with " + userB + " on behalf of " + userA));
            throw new SecurityException("You are not authorised to perform that action.");
        }
        ProfileFriend record = this.dao.getConnectionRecord(userA, userB);
        if (record == null) {
            return 0;
        }
        if (record.isConfirmed()) {
            return 3;
        }
        if (StringUtils.equals((String)userA, (String)record.getUserUuid()) && !record.isConfirmed()) {
            return 1;
        }
        if (StringUtils.equals((String)userA, (String)record.getFriendUuid()) && !record.isConfirmed()) {
            return 2;
        }
        return 0;
    }

    public boolean requestFriend(String userId, String friendId) {
        if (userId == null || friendId == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogic.getFriendsForUser");
        }
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        if (!StringUtils.equals((String)currentUserId, (String)userId)) {
            log.error((Object)("User: " + currentUserId + " attempted to make connection request to " + friendId + " on behalf of " + userId));
            throw new SecurityException("You are not authorised to perform that action.");
        }
        ProfileFriend profileFriend = new ProfileFriend(userId, friendId, 1);
        if (this.dao.addNewConnection(profileFriend)) {
            log.info((Object)("User: " + userId + " requested friend: " + friendId));
            this.sendConnectionEmailNotification(friendId, userId, EmailType.EMAIL_NOTIFICATION_REQUEST);
            return true;
        }
        return false;
    }

    public boolean isFriendRequestPending(String fromUser, String toUser) {
        ProfileFriend profileFriend = this.dao.getPendingConnection(fromUser, toUser);
        if (profileFriend == null) {
            log.debug((Object)("ProfileLogic.isFriendRequestPending: No pending friend request from userId: " + fromUser + " to friendId: " + toUser + " found."));
            return false;
        }
        return true;
    }

    public boolean confirmFriendRequest(String fromUser, String toUser) {
        if (fromUser == null || toUser == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogic.confirmFriendRequest");
        }
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        if (!StringUtils.equals((String)currentUserId, (String)toUser)) {
            log.error((Object)("User: " + currentUserId + " attempted to confirm connection request from " + fromUser + " on behalf of " + toUser));
            throw new SecurityException("You are not authorised to perform that action.");
        }
        ProfileFriend profileFriend = this.dao.getPendingConnection(fromUser, toUser);
        if (profileFriend == null) {
            log.error((Object)("ProfileLogic.confirmFriendRequest() failed. No pending friend request from userId: " + fromUser + " to friendId: " + toUser + " found."));
            return false;
        }
        profileFriend.setConfirmed(true);
        profileFriend.setConfirmedDate(new Date());
        if (this.dao.updateConnection(profileFriend)) {
            log.info((Object)("User: " + fromUser + " confirmed friend request from: " + toUser));
            this.sendConnectionEmailNotification(fromUser, toUser, EmailType.EMAIL_NOTIFICATION_CONFIRM);
            this.evictFromCache(fromUser);
            this.evictFromCache(toUser);
            return true;
        }
        return false;
    }

    public boolean ignoreFriendRequest(String fromUser, String toUser) {
        if (fromUser == null || toUser == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogic.ignoreFriendRequest");
        }
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        if (!StringUtils.equals((String)currentUserId, (String)toUser)) {
            log.error((Object)("User: " + currentUserId + " attempted to ignore connection request from " + fromUser + " on behalf of " + toUser));
            throw new SecurityException("You are not authorised to perform that action.");
        }
        ProfileFriend profileFriend = this.dao.getPendingConnection(fromUser, toUser);
        if (profileFriend == null) {
            log.error((Object)("ProfileLogic.ignoreFriendRequest() failed. No pending friend request from userId: " + fromUser + " to friendId: " + toUser + " found."));
            return false;
        }
        if (this.dao.removeConnection(profileFriend)) {
            log.info((Object)("User: " + toUser + " ignored friend request from: " + fromUser));
            return true;
        }
        return false;
    }

    public boolean removeFriend(String userId, String friendId) {
        if (userId == null || friendId == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogic.removeFriend");
        }
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        if (!StringUtils.equals((String)currentUserId, (String)userId)) {
            log.error((Object)("User: " + currentUserId + " attempted to remove connection with " + friendId + " on behalf of " + userId));
            throw new SecurityException("You are not authorised to perform that action.");
        }
        ProfileFriend profileFriend = this.dao.getConnectionRecord(userId, friendId);
        if (profileFriend == null) {
            log.error((Object)("ProfileFriend record does not exist for userId: " + userId + ", friendId: " + friendId));
            return false;
        }
        if (this.dao.removeConnection(profileFriend)) {
            log.info((Object)("User: " + userId + " removed friend: " + friendId));
            this.evictFromCache(userId);
            this.evictFromCache(friendId);
            return true;
        }
        return false;
    }

    public BasicConnection getBasicConnection(String userUuid) {
        return this.getBasicConnection(this.sakaiProxy.getUserById(userUuid));
    }

    public BasicConnection getBasicConnection(User user) {
        BasicConnection p = new BasicConnection();
        p.setUuid(user.getId());
        p.setDisplayName(user.getDisplayName());
        p.setType(user.getType());
        p.setOnlineStatus(this.getOnlineStatus(user.getId()));
        return p;
    }

    public List<BasicConnection> getBasicConnections(List<User> users) {
        ArrayList<BasicConnection> list = new ArrayList<BasicConnection>();
        Map<String, Integer> onlineStatus = this.getOnlineStatus(this.sakaiProxy.getUuids(users));
        for (User u : users) {
            BasicConnection p = new BasicConnection();
            p.setUuid(u.getId());
            p.setDisplayName(u.getDisplayName());
            p.setType(u.getType());
            p.setOnlineStatus(onlineStatus.get(u.getId()).intValue());
            list.add(p);
        }
        return list;
    }

    public int getOnlineStatus(String userUuid) {
        boolean active = this.sakaiProxy.isUserActive(userUuid);
        if (!active) {
            return 0;
        }
        Long lastEventTime = this.sakaiProxy.getLastEventTimeForUser(userUuid);
        if (lastEventTime == null) {
            return 0;
        }
        long timeNow = new Date().getTime();
        if (timeNow - lastEventTime < 5000000L) {
            return 1;
        }
        return 2;
    }

    public Map<String, Integer> getOnlineStatus(List<String> userUuids) {
        List activeUuids = this.sakaiProxy.getActiveUsers(userUuids);
        Map lastEventTimes = this.sakaiProxy.getLastEventTimeForUsers(activeUuids);
        long timeNow = new Date().getTime();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String uuid : userUuids) {
            if (lastEventTimes.containsKey(uuid)) {
                if (timeNow - (Long)lastEventTimes.get(uuid) < 5000000L) {
                    map.put(uuid, 1);
                    continue;
                }
                map.put(uuid, 2);
                continue;
            }
            map.put(uuid, 0);
        }
        return map;
    }

    private List<User> getConnectedUsers(String userUuid) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to get a connection list.");
        }
        List<Object> users = new ArrayList<User>();
        if (!this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_MYFRIENDS)) {
            return users;
        }
        users = this.sakaiProxy.getUsers(this.getConfirmedConnectionUserIdsForUser(userUuid));
        return users;
    }

    private List<String> getConfirmedConnectionUserIdsForUser(String userUuid) {
        List<Object> userUuids = new ArrayList();
        if (this.cache.containsKey(userUuid)) {
            log.debug((Object)("Fetching connections from cache for: " + userUuid));
            userUuids = (List)this.cache.get(userUuid);
        } else {
            userUuids = this.dao.getConfirmedConnectionUserIdsForUser(userUuid);
            if (userUuids != null) {
                log.debug((Object)("Adding connections to cache for: " + userUuid));
                this.cache.put(userUuid, userUuids);
            } else {
                userUuids = new ArrayList();
            }
        }
        return userUuids;
    }

    private void sendConnectionEmailNotification(String toUuid, String fromUuid, EmailType messageType) {
        if (!this.preferencesLogic.isPreferenceEnabled(toUuid, messageType.toPreference())) {
            return;
        }
        if (messageType == EmailType.EMAIL_NOTIFICATION_REQUEST) {
            String emailTemplateKey = "profile2.connectionRequest";
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put("senderDisplayName", this.sakaiProxy.getUserDisplayName(fromUuid));
            replacementValues.put("localSakaiName", this.sakaiProxy.getServiceName());
            replacementValues.put("connectionLink", this.linkLogic.getEntityLinkToProfileConnections());
            replacementValues.put("localSakaiUrl", this.sakaiProxy.getPortalUrl());
            replacementValues.put("toolName", this.sakaiProxy.getCurrentToolTitle());
            this.sakaiProxy.sendEmail(toUuid, emailTemplateKey, replacementValues);
            return;
        }
        if (messageType == EmailType.EMAIL_NOTIFICATION_CONFIRM) {
            String emailTemplateKey = "profile2.connectionConfirm";
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put("senderDisplayName", this.sakaiProxy.getUserDisplayName(fromUuid));
            replacementValues.put("localSakaiName", this.sakaiProxy.getServiceName());
            replacementValues.put("connectionLink", this.linkLogic.getEntityLinkToProfileHome(fromUuid));
            replacementValues.put("localSakaiUrl", this.sakaiProxy.getPortalUrl());
            replacementValues.put("toolName", this.sakaiProxy.getCurrentToolTitle());
            this.sakaiProxy.sendEmail(toUuid, emailTemplateKey, replacementValues);
            return;
        }
    }

    private void evictFromCache(String cacheKey) {
        this.cache.remove(cacheKey);
        log.info((Object)("Evicted data in cache for key: " + cacheKey));
    }

    public void init() {
        this.cache = this.cacheManager.createCache("org.sakaiproject.profile2.cache.connections");
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setProfileLogic(ProfileLogic profileLogic) {
        this.profileLogic = profileLogic;
    }

    public void setLinkLogic(ProfileLinkLogic linkLogic) {
        this.linkLogic = linkLogic;
    }

    public void setPrivacyLogic(ProfilePrivacyLogic privacyLogic) {
        this.privacyLogic = privacyLogic;
    }

    public void setPreferencesLogic(ProfilePreferencesLogic preferencesLogic) {
        this.preferencesLogic = preferencesLogic;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

